/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.vibur.internal;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.Stoppable;
import org.vibur.dbcp.ViburDBCPDataSource;

public class ViburDBCPConnectionProvider
implements ConnectionProvider,
Configurable,
Stoppable {
    private static final String VIBUR_PREFIX = "hibernate.vibur.";
    private ViburDBCPDataSource dataSource = null;

    public void configure(Map configurationValues) {
        this.dataSource = new ViburDBCPDataSource(ViburDBCPConnectionProvider.transform(configurationValues));
        this.dataSource.start();
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void stop() {
        if (this.dataSource != null) {
            this.dataSource.terminate();
            this.dataSource = null;
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || ViburDBCPConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (this.isUnwrappableAs(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    private static Properties transform(Map<String, String> configurationValues) {
        String defaultAutoCommit;
        String defaultTransactionIsolationValue;
        String password;
        String username;
        String jdbcUrl;
        Properties result = new Properties();
        String driverClassName = configurationValues.get("hibernate.connection.driver_class");
        if (driverClassName != null) {
            result.setProperty("driverClassName", driverClassName);
        }
        if ((jdbcUrl = configurationValues.get("hibernate.connection.url")) != null) {
            result.setProperty("jdbcUrl", jdbcUrl);
        }
        if ((username = configurationValues.get("hibernate.connection.username")) != null) {
            result.setProperty("username", username);
        }
        if ((password = configurationValues.get("hibernate.connection.password")) != null) {
            result.setProperty("password", password);
        }
        if ((defaultTransactionIsolationValue = configurationValues.get("hibernate.connection.isolation")) != null) {
            result.setProperty("defaultTransactionIsolationValue", defaultTransactionIsolationValue);
        }
        if ((defaultAutoCommit = configurationValues.get("hibernate.connection.autocommit")) != null) {
            result.setProperty("defaultAutoCommit", defaultAutoCommit);
        }
        for (Map.Entry<String, String> entry : configurationValues.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(VIBUR_PREFIX)) continue;
            key = key.substring(VIBUR_PREFIX.length());
            result.setProperty(key, entry.getValue());
        }
        return result;
    }

    public ViburDBCPDataSource getDataSource() {
        return this.dataSource;
    }
}

