/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.testutil;

import java.util.Set;
import javax.validation.metadata.GroupConversionDescriptor;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.Formatting;

public class DescriptorAssert {
    public static GroupConversionDescriptorSetAssert assertThat(Set<GroupConversionDescriptor> groupConversions) {
        return new GroupConversionDescriptorSetAssert(groupConversions);
    }

    public static class GroupConversionDescriptorSetAssert
    extends CollectionAssert {
        protected GroupConversionDescriptorSetAssert(Set<GroupConversionDescriptor> actual) {
            super(actual);
        }

        public void containsConversion(Class<?> from, Class<?> to) {
            this.isNotNull();
            boolean foundMatchingConversion = false;
            Iterable actualConversions = (Iterable)this.actual;
            for (GroupConversionDescriptor groupConversionDescriptor : actualConversions) {
                if (!groupConversionDescriptor.getFrom().equals(from) || !groupConversionDescriptor.getTo().equals(to)) continue;
                foundMatchingConversion = true;
                break;
            }
            if (!foundMatchingConversion) {
                this.fail(Formatting.format((String)"<%s> does not contain a conversion from <%s> to <%s>.", (Object[])new Object[]{this.actual, from, to}));
            }
        }
    }
}

