/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.util.AnnotationLiteral;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.executable.ExecutableValidator;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.internal.engine.ValidatorImpl;
import org.hibernate.validator.internal.util.CollectionHelper;

public class ValidatorBean
implements Bean<Validator> {
    private final BeanManager beanManager;
    private final Set<Annotation> qualifiers;

    public ValidatorBean(BeanManager beanManager, Set<Annotation> qualifiers) {
        this.beanManager = beanManager;
        this.qualifiers = CollectionHelper.newHashSet();
        this.qualifiers.addAll(qualifiers);
        this.qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
    }

    public Class<?> getBeanClass() {
        return ValidatorImpl.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public String getName() {
        return null;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return ApplicationScoped.class;
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public Set<Type> getTypes() {
        HashSet<Type> types = new HashSet<Type>();
        types.add((Type)((Object)Validator.class));
        types.add((Type)((Object)ExecutableValidator.class));
        types.add((Type)((Object)Object.class));
        return types;
    }

    public boolean isAlternative() {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Validator create(CreationalContext<Validator> ctx) {
        ValidatorFactory validatorFactory = this.getReference(this.beanManager, ValidatorFactory.class);
        return validatorFactory.getValidator();
    }

    public void destroy(Validator instance, CreationalContext<Validator> ctx) {
    }

    private <T> T getReference(BeanManager beanManager, Class<T> clazz) {
        Set beans = beanManager.getBeans(clazz, this.qualifiers.toArray(new Annotation[this.qualifiers.size()]));
        for (Bean bean : beans) {
            for (Annotation annotation : bean.getQualifiers()) {
                if (!annotation.annotationType().getName().equals(HibernateValidator.class.getName())) continue;
                CreationalContext context = beanManager.createCreationalContext((Contextual)bean);
                return (T)beanManager.getReference(bean, clazz, context);
            }
        }
        return null;
    }
}

