/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.testing.jdbc.ConnectionProviderDelegate;
import org.hibernate.testing.jdbc.PreparedStatementObserver;

public class PreparedStatementProxyConnectionProvider
extends ConnectionProviderDelegate {
    private final Map<Connection, Connection> acquiredConnectionProxyByConnection = new LinkedHashMap<Connection, Connection>();
    private final PreparedStatementObserver preparedStatementObserver;

    public PreparedStatementProxyConnectionProvider(PreparedStatementObserver preparedStatementObserver) {
        this.preparedStatementObserver = preparedStatementObserver;
    }

    protected Connection actualConnection() throws SQLException {
        return super.getConnection();
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection actualConnection = this.actualConnection();
        Connection connectionProxy = this.acquiredConnectionProxyByConnection.get(actualConnection);
        if (connectionProxy == null) {
            connectionProxy = (Connection)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{Connection.class}, (InvocationHandler)new ConnectionHandler(actualConnection, this.preparedStatementObserver));
            this.acquiredConnectionProxyByConnection.put(actualConnection, connectionProxy);
        }
        return connectionProxy;
    }

    @Override
    public void closeConnection(Connection conn) throws SQLException {
        Connection actualConnection = Proxy.isProxyClass(conn.getClass()) ? ((ConnectionHandler)Proxy.getInvocationHandler(conn)).actualConnection : conn;
        this.acquiredConnectionProxyByConnection.remove(actualConnection);
        super.closeConnection(actualConnection);
    }

    @Override
    public void stop() {
        this.clear();
        super.stop();
        this.preparedStatementObserver.connectionProviderStopped();
    }

    public void clear() {
        this.acquiredConnectionProxyByConnection.clear();
    }

    private static class PreparedStatementHandler
    implements InvocationHandler {
        private final PreparedStatement actualPreparedStatement;
        private final PreparedStatementObserver preparedStatementObserver;

        PreparedStatementHandler(PreparedStatement actualPreparedStatement, PreparedStatementObserver preparedStatementObserver) {
            this.actualPreparedStatement = actualPreparedStatement;
            this.preparedStatementObserver = preparedStatementObserver;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                Object returnValue = method.invoke((Object)this.actualPreparedStatement, args);
                this.preparedStatementObserver.preparedStatementMethodInvoked((PreparedStatement)proxy, method, args, returnValue);
                return returnValue;
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }

    private static class ConnectionHandler
    implements InvocationHandler {
        private final Connection actualConnection;
        private final PreparedStatementObserver preparedStatementObserver;

        ConnectionHandler(Connection actualConnection, PreparedStatementObserver preparedStatementObserver) {
            this.actualConnection = actualConnection;
            this.preparedStatementObserver = preparedStatementObserver;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if ("prepareStatement".equals(methodName)) {
                String sql = (String)args[0];
                PreparedStatement preparedStatement = (PreparedStatement)Proxy.newProxyInstance(ClassLoader.getSystemClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)new PreparedStatementHandler(this.actualConnection.prepareStatement(sql), this.preparedStatementObserver));
                this.preparedStatementObserver.preparedStatementCreated(preparedStatement, sql);
                return preparedStatement;
            }
            return method.invoke((Object)this.actualConnection, args);
        }
    }
}

