/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.MDC;
import org.apache.log4j.NDC;
import org.hibernate.testing.logger.Log4DelegatingLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.LoggerProvider;

public class TestableLoggerProvider
implements LoggerProvider {
    private static final ConcurrentMap<String, Logger> reuseLoggerInstances = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String name) {
        Logger previous;
        Logger logger = (Logger)reuseLoggerInstances.get(name);
        if (logger == null && (previous = reuseLoggerInstances.putIfAbsent(name, logger = new Log4DelegatingLogger("".equals(name) ? "ROOT" : name))) != null) {
            return previous;
        }
        return logger;
    }

    public void clearMdc() {
        MDC.clear();
    }

    public Object getMdc(String key) {
        return MDC.get((String)key);
    }

    public Map<String, Object> getMdcMap() {
        return MDC.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putMdc(String key, Object val) {
        try {
            Object object = MDC.get((String)key);
            return object;
        }
        finally {
            MDC.put((String)key, (Object)val);
        }
    }

    public void removeMdc(String key) {
        MDC.remove((String)key);
    }

    public void clearNdc() {
        NDC.remove();
    }

    public String getNdc() {
        return NDC.get();
    }

    public int getNdcDepth() {
        return NDC.getDepth();
    }

    public String peekNdc() {
        return NDC.peek();
    }

    public String popNdc() {
        return NDC.pop();
    }

    public void pushNdc(String message) {
        NDC.push((String)message);
    }

    public void setNdcMaxDepth(int maxDepth) {
        NDC.setMaxDepth((int)maxDepth);
    }
}

