/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.logger;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.hibernate.testing.logger.LogListener;
import org.hibernate.testing.logger.Triggerable;
import org.jboss.logging.Logger;

final class TriggerOnPrefixLogListener
implements LogListener,
Triggerable {
    private Set<String> expectedPrefixes = new HashSet<String>();
    private final AtomicBoolean triggered = new AtomicBoolean(false);
    private final AtomicReference<String> triggerMessage = new AtomicReference<Object>(null);

    public TriggerOnPrefixLogListener(String expectedPrefix) {
        this.expectedPrefixes.add(expectedPrefix);
    }

    public TriggerOnPrefixLogListener(Set<String> expectedPrefixes) {
        this.expectedPrefixes = expectedPrefixes;
    }

    @Override
    public void loggedEvent(Logger.Level level, String renderedMessage, Throwable thrown) {
        if (renderedMessage != null) {
            for (String expectedPrefix : this.expectedPrefixes) {
                if (!renderedMessage.startsWith(expectedPrefix)) continue;
                this.triggered.set(true);
                this.triggerMessage.set(renderedMessage);
            }
        }
    }

    @Override
    public String triggerMessage() {
        return this.triggerMessage.get();
    }

    @Override
    public boolean wasTriggered() {
        return this.triggered.get();
    }

    @Override
    public void reset() {
        this.triggered.set(false);
        this.triggerMessage.set(null);
    }
}

