/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jdbc.connections.internal;

import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.internal.util.ConfigHelper;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.jdbc.connections.internal.ProxoolLogger;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.spi.UnknownUnwrapTypeException;
import org.jboss.logging.Logger;
import org.logicalcobwebs.proxool.ProxoolException;
import org.logicalcobwebs.proxool.ProxoolFacade;
import org.logicalcobwebs.proxool.configuration.JAXPConfigurator;
import org.logicalcobwebs.proxool.configuration.PropertyConfigurator;

public class ProxoolConnectionProvider
implements ConnectionProvider {
    public static final ProxoolLogger LOG = (ProxoolLogger)Logger.getMessageLogger(ProxoolLogger.class, (String)ProxoolConnectionProvider.class.getName());
    private static final String PROXOOL_JDBC_STEM = "proxool.";
    private String proxoolAlias;
    private boolean existingPool;
    private Integer isolation;
    private boolean autocommit;

    public Connection getConnection() throws SQLException {
        Connection c = DriverManager.getConnection(this.proxoolAlias);
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public boolean isUnwrappableAs(Class unwrapType) {
        return ConnectionProvider.class.equals((Object)unwrapType) || ProxoolConnectionProvider.class.isAssignableFrom(unwrapType);
    }

    public <T> T unwrap(Class<T> unwrapType) {
        if (ConnectionProvider.class.equals(unwrapType) || ProxoolConnectionProvider.class.isAssignableFrom(unwrapType)) {
            return (T)this;
        }
        throw new UnknownUnwrapTypeException(unwrapType);
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jaxpFile = props.getProperty("hibernate.proxool.xml");
        String propFile = props.getProperty("hibernate.proxool.properties");
        String externalConfig = props.getProperty("hibernate.proxool.existing_pool");
        this.proxoolAlias = props.getProperty("hibernate.proxool.pool_alias");
        if ("true".equals(externalConfig)) {
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = LOG.unableToConfigureProxoolProviderToUseExistingInMemoryPool("hibernate.proxool.pool_alias");
                LOG.error(msg);
                throw new HibernateException(msg);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            this.existingPool = true;
            LOG.configuringProxoolProviderUsingExistingPool(this.proxoolAlias);
        } else if (StringHelper.isNotEmpty((String)jaxpFile)) {
            LOG.configuringProxoolProviderUsingJaxpConfigurator(jaxpFile);
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = LOG.unableToConfigureProxoolProviderToUseJaxp("hibernate.proxool.pool_alias");
                LOG.error(msg);
                throw new HibernateException(msg);
            }
            try {
                JAXPConfigurator.configure((Reader)ConfigHelper.getConfigStreamReader((String)jaxpFile), (boolean)false);
            }
            catch (ProxoolException e) {
                String msg = LOG.unableToLoadJaxpConfiguratorFile(jaxpFile);
                LOG.error(msg, e);
                throw new HibernateException(msg, (Throwable)e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            LOG.configuringProxoolProviderToUsePoolAlias(this.proxoolAlias);
        } else if (StringHelper.isNotEmpty((String)propFile)) {
            LOG.configuringProxoolProviderUsingPropertiesFile(propFile);
            if (!StringHelper.isNotEmpty((String)this.proxoolAlias)) {
                String msg = LOG.unableToConfigureProxoolProviderToUsePropertiesFile("hibernate.proxool.pool_alias");
                LOG.error(msg);
                throw new HibernateException(msg);
            }
            try {
                PropertyConfigurator.configure((Properties)ConfigHelper.getConfigProperties((String)propFile));
            }
            catch (ProxoolException e) {
                String msg = LOG.unableToLoadPropertyConfiguratorFile(propFile);
                LOG.error(msg, e);
                throw new HibernateException(msg, (Throwable)e);
            }
            this.proxoolAlias = PROXOOL_JDBC_STEM + this.proxoolAlias;
            LOG.configuringProxoolProviderToUsePoolAlias(this.proxoolAlias);
        }
        this.isolation = ConfigurationHelper.getInteger((String)"hibernate.connection.isolation", (Map)props);
        if (this.isolation != null) {
            LOG.jdbcIsolationLevel(Environment.isolationLevelToString((int)this.isolation));
        }
        this.autocommit = ConfigurationHelper.getBoolean((String)"hibernate.connection.autocommit", (Map)props);
        LOG.autoCommmitMode(this.autocommit);
    }

    public void close() throws HibernateException {
        if (this.existingPool) {
            return;
        }
        try {
            if (ProxoolFacade.getAliases().length == 1) {
                ProxoolFacade.shutdown((int)0);
            } else {
                ProxoolFacade.removeConnectionPool((String)this.proxoolAlias.substring(PROXOOL_JDBC_STEM.length()));
            }
        }
        catch (Exception e) {
            String msg = LOG.exceptionClosingProxoolPool();
            LOG.warn(msg, e);
            throw new HibernateException(msg, (Throwable)e);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

