/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc;

import java.util.Properties;
import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.EntityRegion;
import org.hibernate.cache.QueryResultsRegion;
import org.hibernate.cache.RegionFactory;
import org.hibernate.cache.TimestampsRegion;
import org.hibernate.cache.jbc.CacheInstanceManager;
import org.hibernate.cache.jbc.builder.SharedCacheInstanceManager;
import org.hibernate.cache.jbc.collection.CollectionRegionImpl;
import org.hibernate.cache.jbc.entity.EntityRegionImpl;
import org.hibernate.cache.jbc.query.QueryResultsRegionImpl;
import org.hibernate.cache.jbc.timestamp.TimestampsRegionImpl;
import org.hibernate.cfg.Settings;
import org.hibernate.util.PropertiesHelper;

public class JBossCacheRegionFactory
implements RegionFactory {
    private CacheInstanceManager cacheInstanceManager;

    public JBossCacheRegionFactory(Properties props) {
        this();
    }

    public JBossCacheRegionFactory() {
    }

    public JBossCacheRegionFactory(CacheInstanceManager cacheInstanceManager) {
        this.cacheInstanceManager = cacheInstanceManager;
    }

    public CacheInstanceManager getCacheInstanceManager() {
        return this.cacheInstanceManager;
    }

    public void start(Settings settings, Properties properties) throws CacheException {
        if (this.cacheInstanceManager == null) {
            this.cacheInstanceManager = new SharedCacheInstanceManager();
        }
        this.cacheInstanceManager.start(settings, properties);
    }

    public void stop() {
        if (this.cacheInstanceManager != null) {
            this.cacheInstanceManager.stop();
        }
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EntityRegionImpl(this.cacheInstanceManager.getEntityCacheInstance(), regionName, JBossCacheRegionFactory.getRegionPrefix(properties), metadata);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new CollectionRegionImpl(this.cacheInstanceManager.getCollectionCacheInstance(), regionName, JBossCacheRegionFactory.getRegionPrefix(properties), metadata);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new QueryResultsRegionImpl(this.cacheInstanceManager.getQueryCacheInstance(), regionName, JBossCacheRegionFactory.getRegionPrefix(properties), properties);
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new TimestampsRegionImpl(this.cacheInstanceManager.getTimestampsCacheInstance(), regionName, JBossCacheRegionFactory.getRegionPrefix(properties), properties);
    }

    public static String getRegionPrefix(Properties properties) {
        return PropertiesHelper.getString((String)"hibernate.cache.region_prefix", (Properties)properties, null);
    }
}

