/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression.function;

import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.Renderable;
import org.hibernate.ejb.criteria.expression.LiteralExpression;
import org.hibernate.ejb.criteria.expression.function.BasicFunctionExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrimFunction
extends BasicFunctionExpression<String>
implements Serializable {
    public static final String NAME = "trim";
    public static final CriteriaBuilder.Trimspec DEFAULT_TRIMSPEC = CriteriaBuilder.Trimspec.BOTH;
    public static final char DEFAULT_TRIM_CHAR = ' ';
    private final CriteriaBuilder.Trimspec trimspec;
    private final Expression<Character> trimCharacter;
    private final Expression<String> trimSource;

    public TrimFunction(CriteriaBuilderImpl criteriaBuilder, CriteriaBuilder.Trimspec trimspec, Expression<Character> trimCharacter, Expression<String> trimSource) {
        super(criteriaBuilder, String.class, NAME);
        this.trimspec = trimspec;
        this.trimCharacter = trimCharacter;
        this.trimSource = trimSource;
    }

    public TrimFunction(CriteriaBuilderImpl criteriaBuilder, CriteriaBuilder.Trimspec trimspec, char trimCharacter, Expression<String> trimSource) {
        super(criteriaBuilder, String.class, NAME);
        this.trimspec = trimspec;
        this.trimCharacter = new LiteralExpression<Character>(criteriaBuilder, Character.valueOf(trimCharacter));
        this.trimSource = trimSource;
    }

    public TrimFunction(CriteriaBuilderImpl criteriaBuilder, Expression<String> trimSource) {
        this(criteriaBuilder, DEFAULT_TRIMSPEC, ' ', trimSource);
    }

    public TrimFunction(CriteriaBuilderImpl criteriaBuilder, Expression<Character> trimCharacter, Expression<String> trimSource) {
        this(criteriaBuilder, DEFAULT_TRIMSPEC, trimCharacter, trimSource);
    }

    public TrimFunction(CriteriaBuilderImpl criteriaBuilder, char trimCharacter, Expression<String> trimSource) {
        this(criteriaBuilder, DEFAULT_TRIMSPEC, trimCharacter, trimSource);
    }

    public TrimFunction(CriteriaBuilderImpl criteriaBuilder, CriteriaBuilder.Trimspec trimspec, Expression<String> trimSource) {
        this(criteriaBuilder, trimspec, ' ', trimSource);
    }

    public Expression<Character> getTrimCharacter() {
        return this.trimCharacter;
    }

    public Expression<String> getTrimSource() {
        return this.trimSource;
    }

    public CriteriaBuilder.Trimspec getTrimspec() {
        return this.trimspec;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getTrimCharacter(), registry);
        ParameterContainer.Helper.possibleParameter(this.getTrimSource(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return "trim(" + this.trimspec.name() + ' ' + ((Renderable)this.trimCharacter).render(renderingContext) + " from " + ((Renderable)this.trimSource).render(renderingContext) + ')';
    }
}

