/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImplementor;
import org.hibernate.ejb.criteria.expression.UnaryOperatorExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryArithmeticOperation<T>
extends ExpressionImpl<T>
implements UnaryOperatorExpression<T> {
    private final Operation operation;
    private final Expression<T> operand;

    public UnaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Operation operation, Expression<T> operand) {
        super(criteriaBuilder, operand.getJavaType());
        this.operation = operation;
        this.operand = operand;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @Override
    public Expression<T> getOperand() {
        return this.operand;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getOperand(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return (this.getOperation() == Operation.UNARY_MINUS ? (char)'-' : '+') + ((ExpressionImplementor)this.getOperand()).render(renderingContext);
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        UNARY_PLUS,
        UNARY_MINUS;

    }
}

