/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImplementor;
import org.hibernate.ejb.criteria.expression.LiteralExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullifExpression<T>
extends ExpressionImpl<T> {
    private final Expression<? extends T> primaryExpression;
    private final Expression<?> secondaryExpression;

    public NullifExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Expression<? extends T> primaryExpression, Expression<?> secondaryExpression) {
        super(criteriaBuilder, NullifExpression.determineType(javaType, primaryExpression));
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = secondaryExpression;
    }

    public NullifExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Expression<? extends T> primaryExpression, Object secondaryExpression) {
        super(criteriaBuilder, NullifExpression.determineType(javaType, primaryExpression));
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = new LiteralExpression<Object>(criteriaBuilder, secondaryExpression);
    }

    private static Class determineType(Class javaType, Expression primaryExpression) {
        return javaType != null ? javaType : primaryExpression.getJavaType();
    }

    public Expression<? extends T> getPrimaryExpression() {
        return this.primaryExpression;
    }

    public Expression<?> getSecondaryExpression() {
        return this.secondaryExpression;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getPrimaryExpression(), registry);
        ParameterContainer.Helper.possibleParameter(this.getSecondaryExpression(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return "nullif(" + ((ExpressionImplementor)this.getPrimaryExpression()).render(renderingContext) + ',' + ((ExpressionImplementor)this.getSecondaryExpression()).render(renderingContext) + ")";
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

