/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria.expression;

import javax.persistence.criteria.Expression;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.criteria.ParameterContainer;
import org.hibernate.ejb.criteria.ParameterRegistry;
import org.hibernate.ejb.criteria.expression.BinaryOperatorExpression;
import org.hibernate.ejb.criteria.expression.ExpressionImpl;
import org.hibernate.ejb.criteria.expression.ExpressionImplementor;
import org.hibernate.ejb.criteria.expression.LiteralExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryArithmeticOperation<N extends Number>
extends ExpressionImpl<N>
implements BinaryOperatorExpression<N> {
    private final Operation operator;
    private final Expression<? extends N> rhs;
    private final Expression<? extends N> lhs;

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Expression<? extends Number> expression) {
        return expression == null || expression.getJavaType() == null ? defaultType : expression.getJavaType();
    }

    public static Class<? extends Number> determineReturnType(Class<? extends Number> defaultType, Number numberLiteral) {
        return numberLiteral == null ? defaultType : numberLiteral.getClass();
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> resultType, Operation operator, Expression<? extends N> rhs, Expression<? extends N> lhs) {
        super(criteriaBuilder, resultType);
        this.operator = operator;
        this.rhs = rhs;
        this.lhs = lhs;
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> javaType, Operation operator, Expression<? extends N> rhs, N lhs) {
        super(criteriaBuilder, javaType);
        this.operator = operator;
        this.rhs = rhs;
        this.lhs = new LiteralExpression<N>(criteriaBuilder, lhs);
    }

    public BinaryArithmeticOperation(CriteriaBuilderImpl criteriaBuilder, Class<N> javaType, Operation operator, N rhs, Expression<? extends N> lhs) {
        super(criteriaBuilder, javaType);
        this.operator = operator;
        this.rhs = new LiteralExpression<N>(criteriaBuilder, rhs);
        this.lhs = lhs;
    }

    public Operation getOperator() {
        return this.operator;
    }

    @Override
    public Expression<? extends N> getRightHandOperand() {
        return this.rhs;
    }

    @Override
    public Expression<? extends N> getLeftHandOperand() {
        return this.lhs;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getRightHandOperand(), registry);
        ParameterContainer.Helper.possibleParameter(this.getLeftHandOperand(), registry);
    }

    @Override
    public String render(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.getOperator().apply(((ExpressionImplementor)this.getLeftHandOperand()).render(renderingContext), ((ExpressionImplementor)this.getRightHandOperand()).render(renderingContext));
    }

    @Override
    public String renderProjection(CriteriaQueryCompiler.RenderingContext renderingContext) {
        return this.render(renderingContext);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        ADD{

            String apply(String lhs, String rhs) {
                return lhs + " + " + rhs;
            }
        }
        ,
        SUBTRACT{

            String apply(String lhs, String rhs) {
                return lhs + " - " + rhs;
            }
        }
        ,
        MULTIPLY{

            String apply(String lhs, String rhs) {
                return lhs + " * " + rhs;
            }
        }
        ,
        DIVIDE{

            String apply(String lhs, String rhs) {
                return lhs + " / " + rhs;
            }
        }
        ,
        QUOT{

            String apply(String lhs, String rhs) {
                return lhs + " / " + rhs;
            }
        }
        ,
        MOD{

            String apply(String lhs, String rhs) {
                return lhs + " % " + rhs;
            }
        };


        abstract String apply(String var1, String var2);
    }
}

