/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Path;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ManagedType;
import javax.persistence.metamodel.MapAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.ejb.criteria.BasicPathUsageException;
import org.hibernate.ejb.criteria.CriteriaBuilderImpl;
import org.hibernate.ejb.criteria.CriteriaSubqueryImpl;
import org.hibernate.ejb.criteria.JoinImpl;
import org.hibernate.ejb.criteria.JoinImplementors;
import org.hibernate.ejb.criteria.MapKeyHelpers;
import org.hibernate.ejb.criteria.PathImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJoinImpl<O, K, V>
extends JoinImpl<O, V>
implements JoinImplementors.MapJoinImplementor<O, K, V> {
    private From<O, V> correlationParent;

    public MapJoinImpl(CriteriaBuilderImpl criteriaBuilder, Class<V> javaType, PathImpl<O> lhs, MapAttribute<? super O, K, V> joinProperty, JoinType joinType) {
        super(criteriaBuilder, javaType, lhs, joinProperty, joinType);
    }

    public MapAttribute<? super O, K, V> getAttribute() {
        return (MapAttribute)super.getAttribute();
    }

    public MapAttribute<? super O, K, V> getModel() {
        return this.getAttribute();
    }

    @Override
    protected ManagedType<V> getManagedType() {
        return (ManagedType)this.getAttribute().getElementType();
    }

    public Join<Map<K, V>, K> joinKey() {
        return this.joinKey(DEFAULT_JOIN_TYPE);
    }

    public Join<Map<K, V>, K> joinKey(JoinType jt) {
        if (Type.PersistenceType.BASIC.equals((Object)this.getAttribute().getKeyType().getPersistenceType())) {
            throw new BasicPathUsageException("Cannot join to map key of basic type", (Attribute<?, ?>)this.getAttribute());
        }
        if (jt.equals((Object)JoinType.RIGHT)) {
            throw new UnsupportedOperationException("RIGHT JOIN not supported");
        }
        MapKeyHelpers.MapPath<K, V> mapKeySource = new MapKeyHelpers.MapPath<K, V>(this.queryBuilder(), this.getAttribute().getJavaType(), this, this.getAttribute(), this.getParentPath().getModel());
        MapKeyHelpers.MapKeyAttribute<K> mapKeyAttribute = new MapKeyHelpers.MapKeyAttribute<K>(this.queryBuilder(), this.getAttribute());
        return new MapKeyHelpers.MapKeyJoin<K, V>(this.queryBuilder(), mapKeySource, mapKeyAttribute, jt);
    }

    public Path<K> key() {
        MapKeyHelpers.MapPath<K, V> mapKeySource = new MapKeyHelpers.MapPath<K, V>(this.queryBuilder(), this.getAttribute().getJavaType(), this, this.getAttribute(), this.getParentPath().getModel());
        MapKeyHelpers.MapKeyAttribute<K> mapKeyAttribute = new MapKeyHelpers.MapKeyAttribute<K>(this.queryBuilder(), this.getAttribute());
        return new MapKeyHelpers.MapKeyPath<K>(this.queryBuilder(), mapKeySource, mapKeyAttribute);
    }

    public Path<V> value() {
        return this;
    }

    public Expression<Map.Entry<K, V>> entry() {
        return new MapKeyHelpers.MapEntryExpression<K, V>(this.queryBuilder(), Map.Entry.class, this, this.getAttribute());
    }

    @Override
    public JoinImplementors.MapJoinImplementor<O, K, V> correlateTo(CriteriaSubqueryImpl subquery) {
        MapJoinImpl correlation = new MapJoinImpl(this.queryBuilder(), this.getJavaType(), this.getParentPath(), this.getAttribute(), this.getJoinType());
        correlation.defineJoinScope(subquery.getJoinScope());
        correlation.correlationParent = this;
        return correlation;
    }

    @Override
    public boolean isCorrelated() {
        return this.getCorrelationParent() != null;
    }

    @Override
    public From<O, V> getCorrelationParent() {
        return this.correlationParent;
    }
}

