/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.criteria;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Parameter;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.criteria.CriteriaQueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CriteriaQueryCompiler {
    private final HibernateEntityManagerImplementor entityManager;

    public CriteriaQueryCompiler(HibernateEntityManagerImplementor entityManager) {
        this.entityManager = entityManager;
    }

    public <T> TypedQuery<T> compile(CriteriaQuery<T> criteriaQuery) {
        CriteriaQueryImpl criteriaQueryImpl = (CriteriaQueryImpl)criteriaQuery;
        criteriaQueryImpl.validate();
        final HashMap explicitParameterMapping = new HashMap();
        final ArrayList implicitParameterBindings = new ArrayList();
        RenderingContext renderingContext = new RenderingContext(){
            private int aliasCount = 0;
            private int explicitParameterCount = 0;

            @Override
            public String generateAlias() {
                return "generatedAlias" + this.aliasCount++;
            }

            @Override
            public String generateParameterName() {
                return "param" + this.explicitParameterCount++;
            }

            @Override
            public void registerExplicitParameter(ParameterExpression<?> criteriaQueryParameter, String jpaqlParameterName) {
                explicitParameterMapping.put(criteriaQueryParameter, jpaqlParameterName);
            }

            @Override
            public void registerImplicitParameterBinding(ImplicitParameterBinding binding) {
                implicitParameterBindings.add(binding);
            }
        };
        RenderedCriteriaQuery renderedCriteriaQuery = criteriaQueryImpl.render(renderingContext);
        TypedQuery jpaqlQuery = this.entityManager.createQuery(renderedCriteriaQuery.getQueryString(), criteriaQuery.getResultType());
        for (ImplicitParameterBinding implicitParameterBinding : implicitParameterBindings) {
            implicitParameterBinding.bind(jpaqlQuery);
        }
        return this.wrap(jpaqlQuery, explicitParameterMapping);
    }

    private <X> TypedQuery<X> wrap(final TypedQuery<X> jpaqlQuery, final Map<ParameterExpression<?>, String> explicitParameterMapping) {
        return new TypedQuery<X>(){

            public List<X> getResultList() {
                return jpaqlQuery.getResultList();
            }

            public X getSingleResult() {
                return jpaqlQuery.getSingleResult();
            }

            public int getMaxResults() {
                return jpaqlQuery.getMaxResults();
            }

            public TypedQuery<X> setMaxResults(int i) {
                return jpaqlQuery.setMaxResults(i);
            }

            public int getFirstResult() {
                return jpaqlQuery.getFirstResult();
            }

            public TypedQuery<X> setFirstResult(int i) {
                return jpaqlQuery.setFirstResult(i);
            }

            public Map<String, Object> getHints() {
                return jpaqlQuery.getHints();
            }

            public TypedQuery<X> setHint(String name, Object value) {
                return jpaqlQuery.setHint(name, value);
            }

            public FlushModeType getFlushMode() {
                return jpaqlQuery.getFlushMode();
            }

            public TypedQuery<X> setFlushMode(FlushModeType flushModeType) {
                return jpaqlQuery.setFlushMode(flushModeType);
            }

            public LockModeType getLockMode() {
                return jpaqlQuery.getLockMode();
            }

            public TypedQuery<X> setLockMode(LockModeType lockModeType) {
                return jpaqlQuery.setLockMode(lockModeType);
            }

            public Set getParameters() {
                return explicitParameterMapping.keySet();
            }

            public boolean isBound(Parameter<?> param) {
                return jpaqlQuery.isBound(param);
            }

            public <T> T getParameterValue(Parameter<T> param) {
                return (T)jpaqlQuery.getParameterValue(this.mapToNamedParameter(param));
            }

            public <T> TypedQuery<X> setParameter(Parameter<T> param, T t) {
                return jpaqlQuery.setParameter(this.mapToNamedParameter(param), t);
            }

            private Parameter mapToNamedParameter(Parameter criteriaParameter) {
                return jpaqlQuery.getParameter((String)explicitParameterMapping.get((ParameterExpression)criteriaParameter));
            }

            public TypedQuery<X> setParameter(Parameter<Calendar> param, Calendar calendar, TemporalType temporalType) {
                return jpaqlQuery.setParameter(this.mapToNamedParameter(param), calendar, temporalType);
            }

            public TypedQuery<X> setParameter(Parameter<Date> param, Date date, TemporalType temporalType) {
                return jpaqlQuery.setParameter(this.mapToNamedParameter(param), date, temporalType);
            }

            public <T> T unwrap(Class<T> cls) {
                return (T)jpaqlQuery.unwrap(cls);
            }

            public int executeUpdate() {
                throw new IllegalArgumentException("Criteria queries do not support update queries");
            }

            public TypedQuery<X> setParameter(String s, Object o) {
                throw new IllegalArgumentException("Criteria queries do not support named parameters");
            }

            public TypedQuery<X> setParameter(String s, Calendar calendar, TemporalType temporalType) {
                throw new IllegalArgumentException("Criteria queries do not support named parameters");
            }

            public TypedQuery<X> setParameter(String s, Date date, TemporalType temporalType) {
                throw new IllegalArgumentException("Criteria queries do not support named parameters");
            }

            public Object getParameterValue(String name) {
                throw new IllegalArgumentException("Criteria queries do not support named parameters");
            }

            public Parameter<?> getParameter(String name) {
                throw new IllegalArgumentException("Criteria queries do not support named parameters");
            }

            public <T> Parameter<T> getParameter(String name, Class<T> type) {
                throw new IllegalArgumentException("Criteria queries do not support named parameters");
            }

            public TypedQuery<X> setParameter(int i, Object o) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public TypedQuery<X> setParameter(int i, Calendar calendar, TemporalType temporalType) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public TypedQuery<X> setParameter(int i, Date date, TemporalType temporalType) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public Object getParameterValue(int position) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public Parameter<?> getParameter(int position) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }

            public <T> Parameter<T> getParameter(int position, Class<T> type) {
                throw new IllegalArgumentException("Criteria queries do not support positioned parameters");
            }
        };
    }

    public static interface RenderedCriteriaQuery {
        public String getQueryString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RenderingContext {
        public String generateAlias();

        public String generateParameterName();

        public void registerExplicitParameter(ParameterExpression<?> var1, String var2);

        public void registerImplicitParameterBinding(ImplicitParameterBinding var1);
    }

    public static interface ImplicitParameterBinding {
        public void bind(TypedQuery var1);
    }
}

