/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityNotFoundException;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.NoResultException;
import javax.persistence.OptimisticLockException;
import javax.persistence.PersistenceContextType;
import javax.persistence.PersistenceException;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.AssertionFailure;
import org.hibernate.FlushMode;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.MappingException;
import org.hibernate.NonUniqueResultException;
import org.hibernate.ObjectDeletedException;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Query;
import org.hibernate.QueryException;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.StaleObjectStateException;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.TypeMismatchException;
import org.hibernate.UnresolvableObjectException;
import org.hibernate.ejb.EntityManagerFactoryImpl;
import org.hibernate.ejb.HibernateEntityManagerImplementor;
import org.hibernate.ejb.QueryImpl;
import org.hibernate.ejb.TransactionImpl;
import org.hibernate.ejb.criteria.CriteriaQueryCompiler;
import org.hibernate.ejb.transaction.JoinableCMTTransaction;
import org.hibernate.ejb.util.ConfigurationHelper;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.transaction.TransactionFactory;
import org.hibernate.util.CollectionHelper;
import org.hibernate.util.JTAHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEntityManagerImpl
implements HibernateEntityManagerImplementor,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractEntityManagerImpl.class);
    private EntityManagerFactoryImpl entityManagerFactory;
    protected transient TransactionImpl tx = new TransactionImpl(this);
    protected PersistenceContextType persistenceContextType;
    private FlushModeType flushModeType = FlushModeType.AUTO;
    private PersistenceUnitTransactionType transactionType;
    private Map properties;
    private CriteriaQueryCompiler criteriaQueryCompiler;

    protected AbstractEntityManagerImpl(EntityManagerFactoryImpl entityManagerFactory, PersistenceContextType type, PersistenceUnitTransactionType transactionType, Map properties) {
        this.entityManagerFactory = entityManagerFactory;
        this.persistenceContextType = type;
        this.transactionType = transactionType;
        this.properties = properties != null ? properties : CollectionHelper.EMPTY_MAP;
    }

    protected void postInit() {
        Object flushMode;
        if (PersistenceUnitTransactionType.JTA.equals((Object)this.transactionType)) {
            this.joinTransaction(true);
        }
        if ((flushMode = this.properties.get("org.hibernate.flushMode")) != null) {
            this.getSession().setFlushMode(ConfigurationHelper.getFlushMode(flushMode));
        }
        this.properties = null;
    }

    public javax.persistence.Query createQuery(String jpaqlString) {
        try {
            return new QueryImpl(this.getSession().createQuery(jpaqlString), this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> TypedQuery<T> createQuery(String jpaqlString, Class<T> resultClass) {
        try {
            Query hqlQuery = this.getSession().createQuery(jpaqlString);
            if (hqlQuery.getReturnTypes().length != 1) {
                throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
            }
            if (!resultClass.isAssignableFrom(hqlQuery.getReturnTypes()[0].getReturnedClass())) {
                throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + hqlQuery.getReturnTypes()[0].getReturnedClass() + "]");
            }
            return new QueryImpl(hqlQuery, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        if (this.criteriaQueryCompiler == null) {
            this.criteriaQueryCompiler = new CriteriaQueryCompiler(this);
        }
        return this.criteriaQueryCompiler.compile(criteriaQuery);
    }

    public javax.persistence.Query createNamedQuery(String name) {
        try {
            Query namedQuery = this.getSession().getNamedQuery(name);
            try {
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        try {
            Query namedQuery = this.getSession().getNamedQuery(name);
            try {
                if (namedQuery.getReturnTypes().length != 1) {
                    throw new IllegalArgumentException("Cannot create TypedQuery for query with more than one return");
                }
                if (!resultClass.isAssignableFrom(namedQuery.getReturnTypes()[0].getReturnedClass())) {
                    throw new IllegalArgumentException("Type specified for TypedQuery [" + resultClass.getName() + "] is incompatible with query return type [" + namedQuery.getReturnTypes()[0].getReturnedClass() + "]");
                }
                return new QueryImpl(namedQuery, this);
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        }
        catch (MappingException e) {
            throw new IllegalArgumentException("Named query not found: " + name);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, Class resultClass) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.addEntity("alias1", resultClass.getName(), LockMode.READ);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public javax.persistence.Query createNativeQuery(String sqlString, String resultSetMapping) {
        try {
            SQLQuery q = this.getSession().createSQLQuery(sqlString);
            q.setResultSetMapping(resultSetMapping);
            return new QueryImpl((Query)q, this);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        try {
            return (T)this.getSession().load(entityClass, (Serializable)primaryKey);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <A> A find(Class<A> entityClass, Object primaryKey) {
        try {
            return (A)this.getSession().get(entityClass, (Serializable)primaryKey);
        }
        catch (ObjectDeletedException e) {
            return null;
        }
        catch (ObjectNotFoundException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (TypeMismatchException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <T> T find(Class<T> tClass, Object o, Map<String, Object> stringObjectMap) {
        return null;
    }

    public <T> T find(Class<T> tClass, Object o, LockModeType lockModeType) {
        return null;
    }

    public <T> T find(Class<T> tClass, Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
        return null;
    }

    private void checkTransactionNeeded() {
        if (this.persistenceContextType == PersistenceContextType.TRANSACTION && !this.isTransactionInProgress()) {
            throw new TransactionRequiredException("no transaction is in progress for a TRANSACTION type persistence context");
        }
    }

    public void persist(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().persist(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public <A> A merge(A entity) {
        this.checkTransactionNeeded();
        try {
            return (A)this.getSession().merge(entity);
        }
        catch (ObjectDeletedException sse) {
            throw new IllegalArgumentException(sse);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public void remove(Object entity) {
        this.checkTransactionNeeded();
        try {
            this.getSession().delete(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public void refresh(Object entity) {
        this.checkTransactionNeeded();
        try {
            if (!this.getSession().contains(entity)) {
                throw new IllegalArgumentException("Entity not managed");
            }
            this.getSession().refresh(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public void refresh(Object o, Map<String, Object> stringObjectMap) {
    }

    public void refresh(Object o, LockModeType lockModeType) {
    }

    public void refresh(Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
    }

    public boolean contains(Object entity) {
        try {
            if (entity != null && !(entity instanceof HibernateProxy) && this.getSession().getSessionFactory().getClassMetadata(entity.getClass()) == null) {
                throw new IllegalArgumentException("Not an entity:" + entity.getClass());
            }
            return this.getSession().contains(entity);
        }
        catch (MappingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public LockModeType getLockMode(Object o) {
        return null;
    }

    public void setProperty(String s, Object o) {
    }

    public Map<String, Object> getProperties() {
        return null;
    }

    public Set<String> getSupportedProperties() {
        return null;
    }

    public void flush() {
        try {
            if (!this.isTransactionInProgress()) {
                throw new TransactionRequiredException("no transaction is in progress");
            }
            this.getSession().flush();
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    @Override
    public abstract Session getSession();

    protected abstract Session getRawSession();

    public EntityTransaction getTransaction() {
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            throw new IllegalStateException("A JTA EntityManager cannot use getTransaction()");
        }
        return this.tx;
    }

    public EntityManagerFactoryImpl getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManagerFactory().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEntityManagerFactory().getMetamodel();
    }

    public void setFlushMode(FlushModeType flushModeType) {
        this.flushModeType = flushModeType;
        if (flushModeType == FlushModeType.AUTO) {
            this.getSession().setFlushMode(FlushMode.AUTO);
        } else if (flushModeType == FlushModeType.COMMIT) {
            this.getSession().setFlushMode(FlushMode.COMMIT);
        } else {
            throw new AssertionFailure("Unknown FlushModeType: " + flushModeType);
        }
    }

    public void clear() {
        try {
            this.getSession().clear();
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public void detach(Object entity) {
        try {
            this.getSession().evict(entity);
        }
        catch (HibernateException he) {
            throw this.convert(he);
        }
    }

    public FlushModeType getFlushMode() {
        FlushMode mode = this.getSession().getFlushMode();
        if (mode == FlushMode.AUTO) {
            this.flushModeType = FlushModeType.AUTO;
        } else if (mode == FlushMode.COMMIT) {
            this.flushModeType = FlushModeType.COMMIT;
        } else {
            return null;
        }
        return this.flushModeType;
    }

    public void lock(Object entity, LockModeType lockMode) {
        try {
            if (!this.isTransactionInProgress()) {
                throw new TransactionRequiredException("no transaction is in progress");
            }
            if (!this.contains(entity)) {
                throw new IllegalArgumentException("entity not in the persistence context");
            }
            this.getSession().lock(entity, this.getLockMode(lockMode));
        }
        catch (HibernateException he) {
            this.throwPersistenceException(he);
        }
    }

    public void lock(Object o, LockModeType lockModeType, Map<String, Object> stringObjectMap) {
    }

    private LockMode getLockMode(LockModeType lockMode) {
        switch (lockMode) {
            case READ: {
                return LockMode.UPGRADE;
            }
            case WRITE: {
                return LockMode.FORCE;
            }
        }
        throw new AssertionFailure("Unknown LockModeType: " + lockMode);
    }

    @Override
    public boolean isTransactionInProgress() {
        return ((SessionImplementor)this.getRawSession()).isTransactionInProgress();
    }

    protected void markAsRollback() {
        log.debug("mark transaction for rollback");
        if (this.tx.isActive()) {
            this.tx.setRollbackOnly();
        } else if (PersistenceUnitTransactionType.JTA == this.transactionType) {
            TransactionManager transactionManager = ((SessionFactoryImplementor)this.getRawSession().getSessionFactory()).getTransactionManager();
            if (transactionManager == null) {
                throw new PersistenceException("Using a JTA persistence context wo setting hibernate.transaction.manager_lookup_class");
            }
            try {
                transactionManager.setRollbackOnly();
            }
            catch (SystemException e) {
                throw new PersistenceException("Unable to set the JTA transaction as RollbackOnly", (Throwable)e);
            }
        }
    }

    public void joinTransaction() {
        this.joinTransaction(false);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.equals(Session.class)) {
            return (T)this.getSession();
        }
        if (clazz.equals(SessionImplementor.class)) {
            return (T)this.getSession();
        }
        return null;
    }

    private void joinTransaction(boolean ignoreNotJoining) {
        this.getSession().isOpen();
        if (this.transactionType == PersistenceUnitTransactionType.JTA) {
            try {
                log.debug("Looking for a JTA transaction to join");
                final Session session = this.getSession();
                Transaction transaction = session.getTransaction();
                if (transaction != null && transaction instanceof JoinableCMTTransaction) {
                    JoinableCMTTransaction joinableCMTTransaction = (JoinableCMTTransaction)transaction;
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.JOINED) {
                        log.debug("Transaction already joined");
                        return;
                    }
                    joinableCMTTransaction.markForJoined();
                    session.isOpen();
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.NOT_JOINED) {
                        if (ignoreNotJoining) {
                            log.debug("No JTA transaction found");
                            return;
                        }
                        throw new TransactionRequiredException("No active JTA transaction on joinTransaction call");
                    }
                    if (joinableCMTTransaction.getStatus() == JoinableCMTTransaction.JoinStatus.MARKED_FOR_JOINED) {
                        throw new AssertionFailure("Transaction MARKED_FOR_JOINED after isOpen() call");
                    }
                    log.trace("Adding flush() and close() synchronization");
                    joinableCMTTransaction.registerSynchronization(new Synchronization(){

                        public void beforeCompletion() {
                            boolean flush = false;
                            TransactionFactory.Context ctx = null;
                            try {
                                ctx = (TransactionFactory.Context)session;
                                JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                javax.transaction.Transaction transaction = joinable.getTransaction();
                                if (transaction == null) {
                                    log.warn("Transaction not available on beforeCompletionPhase: assuming valid");
                                }
                                flush = !ctx.isFlushModeNever() && (transaction == null || !JTAHelper.isRollback((int)transaction.getStatus()));
                            }
                            catch (SystemException se) {
                                log.error("could not determine transaction status", (Throwable)se);
                                PersistenceException pe = new PersistenceException("could not determine transaction status in beforeCompletion()", (Throwable)se);
                                AbstractEntityManagerImpl.this.handlePersistenceException(pe);
                                throw pe;
                            }
                            catch (HibernateException he) {
                                AbstractEntityManagerImpl.this.throwPersistenceException(he);
                            }
                            try {
                                if (flush) {
                                    log.trace("automatically flushing session");
                                    ctx.managedFlush();
                                } else {
                                    log.trace("skipping managed flushing");
                                }
                            }
                            catch (HibernateException he) {
                                throw AbstractEntityManagerImpl.this.convert(he);
                            }
                            catch (PersistenceException pe) {
                                AbstractEntityManagerImpl.this.handlePersistenceException(pe);
                                throw pe;
                            }
                            catch (RuntimeException re) {
                                PersistenceException wrapped = new PersistenceException((Throwable)re);
                                AbstractEntityManagerImpl.this.handlePersistenceException(wrapped);
                                throw wrapped;
                            }
                        }

                        public void afterCompletion(int status) {
                            try {
                                if (4 == status && AbstractEntityManagerImpl.this.transactionType == PersistenceUnitTransactionType.JTA && session.isOpen()) {
                                    session.clear();
                                }
                                if (session.isOpen()) {
                                    JoinableCMTTransaction joinable = (JoinableCMTTransaction)session.getTransaction();
                                    joinable.resetStatus();
                                }
                            }
                            catch (HibernateException e) {
                                throw AbstractEntityManagerImpl.this.convert(e);
                            }
                        }
                    });
                }
                log.warn("Cannot join transaction: do not override {}", (Object)"hibernate.transaction.factory_class");
            }
            catch (HibernateException he) {
                throw this.convert(he);
            }
        } else if (!ignoreNotJoining) {
            log.warn("Calling joinTransaction() on a non JTA EntityManager");
        }
    }

    public Object getDelegate() {
        return this.getSession();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.tx = new TransactionImpl(this);
    }

    @Override
    public void handlePersistenceException(PersistenceException e) {
        if (e instanceof NoResultException) {
            return;
        }
        if (e instanceof javax.persistence.NonUniqueResultException) {
            return;
        }
        try {
            this.markAsRollback();
        }
        catch (Exception ne) {
            log.error("Unable to mark for rollback on PersistenceException: ", (Throwable)ne);
        }
    }

    @Override
    public void throwPersistenceException(PersistenceException e) {
        this.handlePersistenceException(e);
        throw e;
    }

    @Override
    public RuntimeException convert(HibernateException e) {
        if (e instanceof StaleStateException) {
            PersistenceException converted = this.wrapStaleStateException((StaleStateException)e);
            this.handlePersistenceException(converted);
            return converted;
        }
        if (e instanceof ObjectNotFoundException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof NonUniqueResultException) {
            javax.persistence.NonUniqueResultException converted = new javax.persistence.NonUniqueResultException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof UnresolvableObjectException) {
            EntityNotFoundException converted = new EntityNotFoundException(e.getMessage());
            this.handlePersistenceException((PersistenceException)converted);
            return converted;
        }
        if (e instanceof QueryException) {
            return new IllegalArgumentException(e);
        }
        if (e instanceof TransientObjectException) {
            try {
                this.markAsRollback();
            }
            catch (Exception ne) {
                log.error("Unable to mark for rollback on TransientObjectException: ", (Throwable)ne);
            }
            return new IllegalStateException(e);
        }
        PersistenceException converted = new PersistenceException((Throwable)e);
        this.handlePersistenceException(converted);
        return converted;
    }

    @Override
    public void throwPersistenceException(HibernateException e) {
        throw this.convert(e);
    }

    @Override
    public PersistenceException wrapStaleStateException(StaleStateException e) {
        OptimisticLockException pe;
        block7: {
            if (e instanceof StaleObjectStateException) {
                StaleObjectStateException sose = (StaleObjectStateException)e;
                Serializable identifier = sose.getIdentifier();
                if (identifier != null) {
                    try {
                        Object entity = this.getRawSession().load(sose.getEntityName(), identifier);
                        if (entity instanceof Serializable) {
                            pe = new OptimisticLockException(null, (Throwable)e, entity);
                            break block7;
                        }
                        pe = new OptimisticLockException((Throwable)e);
                    }
                    catch (EntityNotFoundException enfe) {
                        pe = new OptimisticLockException((Throwable)e);
                    }
                } else {
                    pe = new OptimisticLockException((Throwable)e);
                }
            } else {
                pe = new OptimisticLockException((Throwable)e);
            }
        }
        return pe;
    }
}

