/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.bytebuddy;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.Callable;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.NamingStrategy;
import net.bytebuddy.TypeCache;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.assign.Assigner;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import net.bytebuddy.implementation.bytecode.assign.reference.ReferenceTypeAwareAssigner;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.jar.asm.Type;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.hibernate.HibernateException;
import org.hibernate.bytecode.enhance.internal.bytebuddy.EnhancerImpl;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.internal.bytebuddy.BulkAccessorException;
import org.hibernate.bytecode.internal.bytebuddy.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.bytebuddy.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private final TypeCache<String> FAST_CLASSES = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);
    private final TypeCache<String> BULK_ACCESSORS = new TypeCache.WithInlineExpunction(TypeCache.Sort.SOFT);

    @Override
    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer(final Class clazz, final String[] getterNames, String[] setterNames, Class[] types) {
        final Method[] getters = new Method[getterNames.length];
        final Method[] setters = new Method[setterNames.length];
        BytecodeProviderImpl.findAccessors(clazz, getterNames, setterNames, types, getters, setters);
        final Constructor<?> constructor = BytecodeProviderImpl.findConstructor(clazz);
        Class fastClass = this.FAST_CLASSES.findOrInsert(clazz.getClassLoader(), (Object)clazz.getName(), new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return new ByteBuddy().with(TypeValidation.DISABLED).with((NamingStrategy)new NamingStrategy.SuffixingRandom("HibernateInstantiator")).subclass(ReflectionOptimizer.InstantiationOptimizer.class).method((ElementMatcher)ElementMatchers.named((String)"newInstance")).intercept((Implementation)MethodCall.construct((Constructor)constructor)).make().load(clazz.getClassLoader()).getLoaded();
            }
        }, (Object)clazz);
        fastClass = this.FAST_CLASSES.insert(clazz.getClassLoader(), (Object)clazz.getName(), fastClass);
        Class bulkAccessor = this.BULK_ACCESSORS.findOrInsert(clazz.getClassLoader(), (Object)clazz.getName(), new Callable<Class<?>>(){

            @Override
            public Class<?> call() throws Exception {
                return new ByteBuddy().with(TypeValidation.DISABLED).with((NamingStrategy)new NamingStrategy.SuffixingRandom("HibernateAccessOptimizer")).subclass(ReflectionOptimizer.AccessOptimizer.class).method((ElementMatcher)ElementMatchers.named((String)"getPropertyValues")).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new GetPropertyValues(clazz, getters)})).method((ElementMatcher)ElementMatchers.named((String)"setPropertyValues")).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new SetPropertyValues(clazz, setters)})).method((ElementMatcher)ElementMatchers.named((String)"getPropertyNames")).intercept((Implementation)MethodCall.call((Callable)new CloningPropertyCall(getterNames))).make().load(clazz.getClassLoader()).getLoaded();
            }
        }, (Object)clazz);
        try {
            return new ReflectionOptimizerImpl((ReflectionOptimizer.InstantiationOptimizer)fastClass.newInstance(), (ReflectionOptimizer.AccessOptimizer)bulkAccessor.newInstance());
        }
        catch (Exception exception) {
            throw new HibernateException(exception);
        }
    }

    private static void findAccessors(Class clazz, String[] getterNames, String[] setterNames, Class[] types, Method[] getters, Method[] setters) {
        int length = types.length;
        if (setterNames.length != length || getterNames.length != length) {
            throw new BulkAccessorException("bad number of accessors");
        }
        Class[] getParam = new Class[]{};
        Class[] setParam = new Class[1];
        for (int i = 0; i < length; ++i) {
            if (getterNames[i] != null) {
                Method getter = BytecodeProviderImpl.findAccessor(clazz, getterNames[i], getParam, i);
                if (getter.getReturnType() != types[i]) {
                    throw new BulkAccessorException("wrong return type: " + getterNames[i], i);
                }
                getters[i] = getter;
            }
            if (setterNames[i] == null) continue;
            setParam[0] = types[i];
            setters[i] = BytecodeProviderImpl.findAccessor(clazz, setterNames[i], setParam, i);
        }
    }

    private static Method findAccessor(Class clazz, String name, Class[] params, int index) throws BulkAccessorException {
        try {
            Method method = clazz.getDeclaredMethod(name, params);
            if (Modifier.isPrivate(method.getModifiers())) {
                throw new BulkAccessorException("private property", index);
            }
            return method;
        }
        catch (NoSuchMethodException e) {
            throw new BulkAccessorException("cannot find an accessor", index);
        }
    }

    private static Constructor<?> findConstructor(Class clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new HibernateException(e);
        }
    }

    @Override
    public Enhancer getEnhancer(EnhancementContext enhancementContext) {
        return new EnhancerImpl(enhancementContext);
    }

    public static class CloningPropertyCall
    implements Callable<String[]> {
        private final String[] propertyNames;

        private CloningPropertyCall(String[] propertyNames) {
            this.propertyNames = propertyNames;
        }

        @Override
        public String[] call() {
            return (String[])this.propertyNames.clone();
        }
    }

    private static class SetPropertyValues
    implements ByteCodeAppender {
        private final Class clazz;
        private final Method[] setters;

        public SetPropertyValues(Class clazz, Method[] setters) {
            this.clazz = clazz;
            this.setters = setters;
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            int index = 0;
            for (Method setter : this.setters) {
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName((Class)this.clazz));
                methodVisitor.visitVarInsn(25, 2);
                methodVisitor.visitLdcInsn((Object)index++);
                methodVisitor.visitInsn(50);
                if (setter.getParameterTypes()[0].isPrimitive()) {
                    PrimitiveUnboxingDelegate.forReferenceType((TypeDefinition)TypeDescription.Generic.OBJECT).assignUnboxedTo((TypeDescription.Generic)new TypeDescription.Generic.OfNonGenericType.ForLoadedType(setter.getParameterTypes()[0]), (Assigner)ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.DYNAMIC).apply(methodVisitor, implementationContext);
                } else {
                    methodVisitor.visitTypeInsn(192, Type.getInternalName(setter.getParameterTypes()[0]));
                }
                methodVisitor.visitMethodInsn(182, Type.getInternalName((Class)this.clazz), setter.getName(), Type.getMethodDescriptor((Method)setter), false);
            }
            methodVisitor.visitInsn(177);
            return new ByteCodeAppender.Size(4, instrumentedMethod.getStackSize());
        }
    }

    private static class GetPropertyValues
    implements ByteCodeAppender {
        private final Class clazz;
        private final Method[] getters;

        public GetPropertyValues(Class clazz, Method[] getters) {
            this.clazz = clazz;
            this.getters = getters;
        }

        public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
            methodVisitor.visitLdcInsn((Object)this.getters.length);
            methodVisitor.visitTypeInsn(189, Type.getInternalName(Object.class));
            int index = 0;
            for (Method getter : this.getters) {
                methodVisitor.visitInsn(89);
                methodVisitor.visitLdcInsn((Object)index++);
                methodVisitor.visitVarInsn(25, 1);
                methodVisitor.visitTypeInsn(192, Type.getInternalName((Class)this.clazz));
                methodVisitor.visitMethodInsn(182, Type.getInternalName((Class)this.clazz), getter.getName(), Type.getMethodDescriptor((Method)getter), false);
                if (getter.getReturnType().isPrimitive()) {
                    PrimitiveBoxingDelegate.forPrimitive((TypeDefinition)new TypeDescription.ForLoadedType(getter.getReturnType())).assignBoxedTo(TypeDescription.Generic.OBJECT, (Assigner)ReferenceTypeAwareAssigner.INSTANCE, Assigner.Typing.STATIC).apply(methodVisitor, implementationContext);
                }
                methodVisitor.visitInsn(83);
            }
            methodVisitor.visitInsn(176);
            return new ByteCodeAppender.Size(6, instrumentedMethod.getStackSize());
        }
    }
}

