/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime.spi;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.hibernate.bytecode.buildtime.spi.ClassDescriptor;
import org.hibernate.bytecode.buildtime.spi.ExecutionException;
import org.hibernate.bytecode.buildtime.spi.FieldFilter;
import org.hibernate.bytecode.buildtime.spi.Instrumenter;
import org.hibernate.bytecode.buildtime.spi.Logger;
import org.hibernate.bytecode.spi.ByteCodeHelper;
import org.hibernate.bytecode.spi.ClassTransformer;

public abstract class AbstractInstrumenter
implements Instrumenter {
    private static final int ZIP_MAGIC = 1347093252;
    private static final int CLASS_MAGIC = -889275714;
    protected final Logger logger;
    protected final Instrumenter.Options options;

    public AbstractInstrumenter(Logger logger2, Instrumenter.Options options) {
        this.logger = logger2;
        this.options = options;
    }

    protected abstract ClassDescriptor getClassDescriptor(byte[] var1) throws Exception;

    protected abstract ClassTransformer getClassTransformer(ClassDescriptor var1, Set var2);

    @Override
    public void execute(Set<File> files) {
        HashSet<String> classNames = new HashSet<String>();
        if (this.options.performExtendedInstrumentation()) {
            this.logger.debug("collecting class names for extended instrumentation determination");
            try {
                Iterator<File> i$ = files.iterator();
                while (i$.hasNext()) {
                    File file1;
                    File file = file1 = i$.next();
                    this.collectClassNames(file, classNames);
                }
            }
            catch (ExecutionException ee) {
                throw ee;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
        }
        this.logger.info("starting instrumentation");
        try {
            for (File file : files) {
                this.processFile(file, classNames);
            }
        }
        catch (ExecutionException ee) {
            throw ee;
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    private void collectClassNames(File file, final Set<String> classNames) throws Exception {
        if (this.isClassFile(file)) {
            byte[] bytes = ByteCodeHelper.readByteCode(file);
            ClassDescriptor descriptor = this.getClassDescriptor(bytes);
            classNames.add(descriptor.getName());
        } else if (this.isJarFile(file)) {
            ZipEntryHandler collector = new ZipEntryHandler(){

                @Override
                public void handleEntry(ZipEntry entry, byte[] byteCode) throws Exception {
                    DataInputStream din;
                    if (!entry.isDirectory() && (din = new DataInputStream(new ByteArrayInputStream(byteCode))).readInt() == -889275714) {
                        classNames.add(AbstractInstrumenter.this.getClassDescriptor(byteCode).getName());
                    }
                }
            };
            ZipFileProcessor processor = new ZipFileProcessor(collector);
            processor.process(file);
        }
    }

    protected final boolean isClassFile(File file) throws IOException {
        return this.checkMagic(file, -889275714L);
    }

    protected final boolean isJarFile(File file) throws IOException {
        return this.checkMagic(file, 1347093252L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean checkMagic(File file, long magic) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        try {
            int m = in.readInt();
            boolean bl = magic == (long)m;
            return bl;
        }
        finally {
            in.close();
        }
    }

    protected void processFile(File file, Set<String> classNames) throws Exception {
        if (this.isClassFile(file)) {
            this.logger.debug("processing class file : " + file.getAbsolutePath());
            this.processClassFile(file, classNames);
        } else if (this.isJarFile(file)) {
            this.logger.debug("processing jar file : " + file.getAbsolutePath());
            this.processJarFile(file, classNames);
        } else {
            this.logger.debug("ignoring file : " + file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processClassFile(File file, Set<String> classNames) throws Exception {
        byte[] bytes = ByteCodeHelper.readByteCode(file);
        ClassDescriptor descriptor = this.getClassDescriptor(bytes);
        ClassTransformer transformer = this.getClassTransformer(descriptor, classNames);
        if (transformer == null) {
            this.logger.debug("no trasformer for class file : " + file.getAbsolutePath());
            return;
        }
        this.logger.info("processing class : " + descriptor.getName() + ";  file = " + file.getAbsolutePath());
        byte[] transformedBytes = transformer.transform(this.getClass().getClassLoader(), descriptor.getName(), null, null, descriptor.getBytes());
        FileOutputStream out = new FileOutputStream(file);
        try {
            ((OutputStream)out).write(transformedBytes);
            out.flush();
        }
        finally {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processJarFile(final File file, final Set<String> classNames) throws Exception {
        block10: {
            File tempFile = File.createTempFile(file.getName(), null, new File(file.getAbsoluteFile().getParent()));
            try {
                FileOutputStream fout = new FileOutputStream(tempFile, false);
                try {
                    final ZipOutputStream out = new ZipOutputStream(fout);
                    ZipEntryHandler transformer = new ZipEntryHandler(){

                        @Override
                        public void handleEntry(ZipEntry entry, byte[] byteCode) throws Exception {
                            AbstractInstrumenter.this.logger.debug("starting zip entry : " + entry.toString());
                            if (!entry.isDirectory()) {
                                DataInputStream din = new DataInputStream(new ByteArrayInputStream(byteCode));
                                if (din.readInt() == -889275714) {
                                    ClassDescriptor descriptor = AbstractInstrumenter.this.getClassDescriptor(byteCode);
                                    ClassTransformer transformer = AbstractInstrumenter.this.getClassTransformer(descriptor, classNames);
                                    if (transformer == null) {
                                        AbstractInstrumenter.this.logger.debug("no transformer for zip entry :  " + entry.toString());
                                    } else {
                                        AbstractInstrumenter.this.logger.info("processing class : " + descriptor.getName() + ";  entry = " + file.getAbsolutePath());
                                        byteCode = transformer.transform(this.getClass().getClassLoader(), descriptor.getName(), null, null, descriptor.getBytes());
                                    }
                                } else {
                                    AbstractInstrumenter.this.logger.debug("ignoring zip entry : " + entry.toString());
                                }
                            }
                            ZipEntry outEntry = new ZipEntry(entry.getName());
                            outEntry.setMethod(entry.getMethod());
                            outEntry.setComment(entry.getComment());
                            outEntry.setSize(byteCode.length);
                            if (outEntry.getMethod() == 0) {
                                CRC32 crc = new CRC32();
                                crc.update(byteCode);
                                outEntry.setCrc(crc.getValue());
                                outEntry.setCompressedSize(byteCode.length);
                            }
                            out.putNextEntry(outEntry);
                            out.write(byteCode);
                            out.closeEntry();
                        }
                    };
                    ZipFileProcessor processor = new ZipFileProcessor(transformer);
                    processor.process(file);
                    out.close();
                }
                finally {
                    fout.close();
                }
                if (file.delete()) {
                    File newFile = new File(tempFile.getAbsolutePath());
                    if (!newFile.renameTo(file)) {
                        throw new IOException("can not rename " + tempFile + " to " + file);
                    }
                    break block10;
                }
                throw new IOException("can not delete " + file);
            }
            finally {
                if (!tempFile.delete()) {
                    this.logger.info("Unable to cleanup temporary jar file : " + tempFile.getAbsolutePath());
                }
            }
        }
    }

    private static class ZipFileProcessor {
        private final ZipEntryHandler entryHandler;

        public ZipFileProcessor(ZipEntryHandler entryHandler) {
            this.entryHandler = entryHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(File file) throws Exception {
            ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
            try {
                ZipEntry entry;
                while ((entry = zip.getNextEntry()) != null) {
                    byte[] bytes = ByteCodeHelper.readByteCode(zip);
                    this.entryHandler.handleEntry(entry, bytes);
                    zip.closeEntry();
                }
            }
            finally {
                zip.close();
            }
        }
    }

    private static interface ZipEntryHandler {
        public void handleEntry(ZipEntry var1, byte[] var2) throws Exception;
    }

    protected class CustomFieldFilter
    implements FieldFilter {
        private final ClassDescriptor descriptor;
        private final Set classNames;

        public CustomFieldFilter(ClassDescriptor descriptor, Set classNames) {
            this.descriptor = descriptor;
            this.classNames = classNames;
        }

        @Override
        public boolean shouldInstrumentField(String className, String fieldName) {
            if (this.descriptor.getName().equals(className)) {
                AbstractInstrumenter.this.logger.trace("accepting transformation of field [" + className + "." + fieldName + "]");
                return true;
            }
            AbstractInstrumenter.this.logger.trace("rejecting transformation of field [" + className + "." + fieldName + "]");
            return false;
        }

        @Override
        public boolean shouldTransformFieldAccess(String transformingClassName, String fieldOwnerClassName, String fieldName) {
            if (this.descriptor.getName().equals(fieldOwnerClassName)) {
                AbstractInstrumenter.this.logger.trace("accepting transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
                return true;
            }
            if (AbstractInstrumenter.this.options.performExtendedInstrumentation() && this.classNames.contains(fieldOwnerClassName)) {
                AbstractInstrumenter.this.logger.trace("accepting extended transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]");
                return true;
            }
            AbstractInstrumenter.this.logger.trace("rejecting transformation of field access [" + fieldOwnerClassName + "." + fieldName + "]; caller = " + transformingClassName);
            return false;
        }
    }
}

