/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Index;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PrimaryKey;
import org.hibernate.mapping.RelationalModel;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.tool.hbm2ddl.ColumnMetadata;
import org.hibernate.tool.hbm2ddl.TableMetadata;
import org.hibernate.util.CollectionHelper;

public class Table
implements RelationalModel,
Serializable {
    private String name;
    private String schema;
    private String catalog;
    private Map columns = new LinkedHashMap();
    private KeyValue idValue;
    private PrimaryKey primaryKey;
    private Map indexes = new HashMap();
    private Map foreignKeys = new HashMap();
    private Map uniqueKeys = new HashMap();
    private final int uniqueInteger;
    private boolean quoted;
    private boolean schemaQuoted;
    private static int tableCounter = 0;
    private List checkConstraints = new ArrayList();
    private String rowId;
    private String subselect;
    private boolean isAbstract;
    private boolean hasDenormalizedTables = false;
    private String comment;

    public Table() {
        this.uniqueInteger = tableCounter++;
    }

    public Table(String name) {
        this();
        this.setName(name);
    }

    public String getQualifiedName(Dialect dialect, String defaultCatalog, String defaultSchema) {
        if (this.subselect != null) {
            return "( " + this.subselect + " )";
        }
        String quotedName = this.getQuotedName(dialect);
        String usedSchema = this.schema == null ? defaultSchema : this.getQuotedSchema(dialect);
        String usedCatalog = this.catalog == null ? defaultCatalog : this.catalog;
        return Table.qualify(usedCatalog, usedSchema, quotedName);
    }

    public static String qualify(String catalog, String schema, String table) {
        StringBuffer qualifiedName = new StringBuffer();
        if (catalog != null) {
            qualifiedName.append(catalog).append('.');
        }
        if (schema != null) {
            qualifiedName.append(schema).append('.');
        }
        return qualifiedName.append(table).toString();
    }

    public String getName() {
        return this.name;
    }

    public String getQuotedName() {
        return this.quoted ? "`" + this.name + "`" : this.name;
    }

    public String getQuotedName(Dialect dialect) {
        return this.quoted ? dialect.openQuote() + this.name + dialect.closeQuote() : this.name;
    }

    public String getQuotedSchema() {
        return this.schemaQuoted ? "`" + this.schema + "`" : this.schema;
    }

    public String getQuotedSchema(Dialect dialect) {
        return this.schemaQuoted ? dialect.openQuote() + this.schema + dialect.closeQuote() : this.schema;
    }

    public void setName(String name) {
        if (name.charAt(0) == '`') {
            this.quoted = true;
            this.name = name.substring(1, name.length() - 1);
        } else {
            this.name = name;
        }
    }

    public Column getColumn(Column column) {
        if (column == null) {
            return null;
        }
        Column myColumn = (Column)this.columns.get(column.getCanonicalName());
        return column.equals(myColumn) ? myColumn : null;
    }

    public Column getColumn(int n) {
        Iterator iter = this.columns.values().iterator();
        for (int i = 0; i < n - 1; ++i) {
            iter.next();
        }
        return (Column)iter.next();
    }

    public void addColumn(Column column) {
        Column old = this.getColumn(column);
        if (old == null) {
            this.columns.put(column.getCanonicalName(), column);
            column.uniqueInteger = this.columns.size();
        } else {
            column.uniqueInteger = old.uniqueInteger;
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Iterator getColumnIterator() {
        return this.columns.values().iterator();
    }

    public Iterator getIndexIterator() {
        return this.indexes.values().iterator();
    }

    public Iterator getForeignKeyIterator() {
        return this.foreignKeys.values().iterator();
    }

    public Iterator getUniqueKeyIterator() {
        return this.getUniqueKeys().values().iterator();
    }

    Map getUniqueKeys() {
        if (this.uniqueKeys.size() > 1) {
            Iterator it = this.uniqueKeys.entrySet().iterator();
            HashMap finalUniqueKeys = new HashMap(this.uniqueKeys.size());
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                UniqueKey uk = (UniqueKey)entry.getValue();
                List columns = uk.getColumns();
                int size = finalUniqueKeys.size();
                boolean skip = false;
                Iterator tempUks = finalUniqueKeys.entrySet().iterator();
                while (tempUks.hasNext()) {
                    UniqueKey currentUk = (UniqueKey)tempUks.next().getValue();
                    if (!currentUk.getColumns().containsAll(columns) || !columns.containsAll(currentUk.getColumns())) continue;
                    skip = true;
                    break;
                }
                if (skip) continue;
                finalUniqueKeys.put(entry.getKey(), uk);
            }
            return finalUniqueKeys;
        }
        return this.uniqueKeys;
    }

    public void validateColumns(Dialect dialect, Mapping mapping, TableMetadata tableInfo) {
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            Column col = (Column)iter.next();
            ColumnMetadata columnInfo = tableInfo.getColumnMetadata(col.getName());
            if (columnInfo == null) {
                throw new HibernateException("Missing column: " + col.getName() + " in " + Table.qualify(tableInfo.getCatalog(), tableInfo.getSchema(), tableInfo.getName()));
            }
            boolean typesMatch = col.getSqlType(dialect, mapping).toLowerCase().startsWith(columnInfo.getTypeName().toLowerCase()) || columnInfo.getTypeCode() == col.getSqlTypeCode(mapping);
            if (typesMatch) continue;
            throw new HibernateException("Wrong column type in " + Table.qualify(tableInfo.getCatalog(), tableInfo.getSchema(), tableInfo.getName()) + " for column " + col.getName() + ". Found: " + columnInfo.getTypeName().toLowerCase() + ", expected: " + col.getSqlType(dialect, mapping));
        }
    }

    public Iterator sqlAlterStrings(Dialect dialect, Mapping p, TableMetadata tableInfo, String defaultCatalog, String defaultSchema) throws HibernateException {
        StringBuffer root = new StringBuffer("alter table ").append(this.getQualifiedName(dialect, defaultCatalog, defaultSchema)).append(' ').append(dialect.getAddColumnString());
        Iterator iter = this.getColumnIterator();
        ArrayList<String> results = new ArrayList<String>();
        while (iter.hasNext()) {
            String columnComment;
            boolean useUniqueConstraint;
            Column column = (Column)iter.next();
            ColumnMetadata columnInfo = tableInfo.getColumnMetadata(column.getName());
            if (columnInfo != null) continue;
            StringBuffer alter = new StringBuffer(root.toString()).append(' ').append(column.getQuotedName(dialect)).append(' ').append(column.getSqlType(dialect, p));
            String defaultValue = column.getDefaultValue(dialect, p);
            if (defaultValue != null) {
                alter.append(" default ").append(defaultValue);
            }
            if (column.isNullable()) {
                alter.append(dialect.getNullColumnString());
            } else {
                alter.append(" not null");
            }
            boolean bl = useUniqueConstraint = column.isUnique() && dialect.supportsUnique() && (!column.isNullable() || dialect.supportsNotNullUnique());
            if (useUniqueConstraint) {
                alter.append(" unique");
            }
            if (column.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                alter.append(" check(").append(column.getCheckConstraint()).append(")");
            }
            if ((columnComment = column.getComment()) != null) {
                alter.append(dialect.getColumnComment(columnComment));
            }
            results.add(alter.toString());
        }
        return results.iterator();
    }

    public boolean hasPrimaryKey() {
        return this.getPrimaryKey() != null;
    }

    public String sqlTemporaryTableCreateString(Dialect dialect, Mapping mapping) throws HibernateException {
        StringBuffer buffer = new StringBuffer(dialect.getCreateTemporaryTableString()).append(' ').append(this.name).append(" (");
        Iterator itr = this.getColumnIterator();
        while (itr.hasNext()) {
            Column column = (Column)itr.next();
            buffer.append(column.getQuotedName(dialect)).append(' ');
            buffer.append(column.getSqlType(dialect, mapping));
            if (column.isNullable()) {
                buffer.append(dialect.getNullColumnString());
            } else {
                buffer.append(" not null");
            }
            if (!itr.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(") ");
        buffer.append(dialect.getCreateTemporaryTablePostfix());
        return buffer.toString();
    }

    public String sqlCreateString(Dialect dialect, Mapping p, String defaultCatalog, String defaultSchema) {
        StringBuffer buf = new StringBuffer(this.hasPrimaryKey() ? dialect.getCreateTableString() : dialect.getCreateMultisetTableString()).append(' ').append(this.getQualifiedName(dialect, defaultCatalog, defaultSchema)).append(" (");
        boolean identityColumn = this.idValue != null && this.idValue.isIdentityColumn(p.getIdentifierGeneratorFactory(), dialect);
        String pkname = null;
        if (this.hasPrimaryKey() && identityColumn) {
            pkname = ((Column)this.getPrimaryKey().getColumnIterator().next()).getQuotedName(dialect);
        }
        Iterator iter = this.getColumnIterator();
        while (iter.hasNext()) {
            String columnComment;
            boolean useUniqueConstraint;
            Column col = (Column)iter.next();
            buf.append(col.getQuotedName(dialect)).append(' ');
            if (identityColumn && col.getQuotedName(dialect).equals(pkname)) {
                if (dialect.hasDataTypeInIdentityColumn()) {
                    buf.append(col.getSqlType(dialect, p));
                }
                buf.append(' ').append(dialect.getIdentityColumnString(col.getSqlTypeCode(p)));
            } else {
                buf.append(col.getSqlType(dialect, p));
                String defaultValue = col.getDefaultValue(dialect, p);
                if (defaultValue != null) {
                    buf.append(" default ").append(defaultValue);
                }
                if (col.isNullable()) {
                    buf.append(dialect.getNullColumnString());
                } else {
                    buf.append(" not null");
                }
            }
            boolean bl = useUniqueConstraint = col.isUnique() && (!col.isNullable() || dialect.supportsNotNullUnique());
            if (useUniqueConstraint) {
                if (dialect.supportsUnique()) {
                    buf.append(" unique");
                } else {
                    UniqueKey uk = this.getOrCreateUniqueKey(col.getQuotedName(dialect) + '_');
                    uk.addColumn(col);
                }
            }
            if (col.hasCheckConstraint() && dialect.supportsColumnCheck()) {
                buf.append(" check (").append(col.getCheckConstraint()).append(")");
            }
            if ((columnComment = col.getComment()) != null) {
                buf.append(dialect.getColumnComment(columnComment));
            }
            if (!iter.hasNext()) continue;
            buf.append(", ");
        }
        if (this.hasPrimaryKey()) {
            buf.append(", ").append(this.getPrimaryKey().sqlConstraintString(dialect));
        }
        if (dialect.supportsUniqueConstraintInCreateAlterTable()) {
            Iterator ukiter = this.getUniqueKeyIterator();
            while (ukiter.hasNext()) {
                UniqueKey uk = (UniqueKey)ukiter.next();
                String constraint = uk.sqlConstraintString(dialect);
                if (constraint == null) continue;
                buf.append(", ").append(constraint);
            }
        }
        if (dialect.supportsTableCheck()) {
            Iterator chiter = this.checkConstraints.iterator();
            while (chiter.hasNext()) {
                buf.append(", check (").append(chiter.next()).append(')');
            }
        }
        buf.append(')');
        if (this.comment != null) {
            buf.append(dialect.getTableComment(this.comment));
        }
        return buf.append(dialect.getTableTypeString()).toString();
    }

    public String sqlDropString(Dialect dialect, String defaultCatalog, String defaultSchema) {
        StringBuffer buf = new StringBuffer("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            buf.append("if exists ");
        }
        buf.append(this.getQualifiedName(dialect, defaultCatalog, defaultSchema)).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            buf.append(" if exists");
        }
        return buf.toString();
    }

    public PrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(PrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public Index getOrCreateIndex(String indexName) {
        Index index = (Index)this.indexes.get(indexName);
        if (index == null) {
            index = new Index();
            index.setName(indexName);
            index.setTable(this);
            this.indexes.put(indexName, index);
        }
        return index;
    }

    public Index getIndex(String indexName) {
        return (Index)this.indexes.get(indexName);
    }

    public Index addIndex(Index index) {
        Index current = (Index)this.indexes.get(index.getName());
        if (current != null) {
            throw new MappingException("Index " + index.getName() + " already exists!");
        }
        this.indexes.put(index.getName(), index);
        return index;
    }

    public UniqueKey addUniqueKey(UniqueKey uniqueKey) {
        UniqueKey current = (UniqueKey)this.uniqueKeys.get(uniqueKey.getName());
        if (current != null) {
            throw new MappingException("UniqueKey " + uniqueKey.getName() + " already exists!");
        }
        this.uniqueKeys.put(uniqueKey.getName(), uniqueKey);
        return uniqueKey;
    }

    public UniqueKey createUniqueKey(List keyColumns) {
        String keyName = "UK" + this.uniqueColumnString(keyColumns.iterator());
        UniqueKey uk = this.getOrCreateUniqueKey(keyName);
        uk.addColumns(keyColumns.iterator());
        return uk;
    }

    public UniqueKey getUniqueKey(String keyName) {
        return (UniqueKey)this.uniqueKeys.get(keyName);
    }

    public UniqueKey getOrCreateUniqueKey(String keyName) {
        UniqueKey uk = (UniqueKey)this.uniqueKeys.get(keyName);
        if (uk == null) {
            uk = new UniqueKey();
            uk.setName(keyName);
            uk.setTable(this);
            this.uniqueKeys.put(keyName, uk);
        }
        return uk;
    }

    public void createForeignKeys() {
    }

    public ForeignKey createForeignKey(String keyName, List keyColumns, String referencedEntityName) {
        return this.createForeignKey(keyName, keyColumns, referencedEntityName, null);
    }

    public ForeignKey createForeignKey(String keyName, List keyColumns, String referencedEntityName, List referencedColumns) {
        ForeignKeyKey key = new ForeignKeyKey(keyColumns, referencedEntityName, referencedColumns);
        ForeignKey fk = (ForeignKey)this.foreignKeys.get(key);
        if (fk == null) {
            fk = new ForeignKey();
            if (keyName != null) {
                fk.setName(keyName);
            } else {
                fk.setName("FK" + this.uniqueColumnString(keyColumns.iterator(), referencedEntityName));
            }
            fk.setTable(this);
            this.foreignKeys.put(key, fk);
            fk.setReferencedEntityName(referencedEntityName);
            fk.addColumns(keyColumns.iterator());
            if (referencedColumns != null) {
                fk.addReferencedColumns(referencedColumns.iterator());
            }
        }
        if (keyName != null) {
            fk.setName(keyName);
        }
        return fk;
    }

    public String uniqueColumnString(Iterator iterator) {
        return this.uniqueColumnString(iterator, null);
    }

    public String uniqueColumnString(Iterator iterator, String referencedEntityName) {
        int result = 0;
        if (referencedEntityName != null) {
            result += referencedEntityName.hashCode();
        }
        while (iterator.hasNext()) {
            result += iterator.next().hashCode();
        }
        return (Integer.toHexString(this.name.hashCode()) + Integer.toHexString(result)).toUpperCase();
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        if (schema != null && schema.charAt(0) == '`') {
            this.schemaQuoted = true;
            this.schema = schema.substring(1, schema.length() - 1);
        } else {
            this.schema = schema;
        }
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public int getUniqueInteger() {
        return this.uniqueInteger;
    }

    public void setIdentifierValue(KeyValue idValue) {
        this.idValue = idValue;
    }

    public KeyValue getIdentifierValue() {
        return this.idValue;
    }

    public boolean isSchemaQuoted() {
        return this.schemaQuoted;
    }

    public boolean isQuoted() {
        return this.quoted;
    }

    public void setQuoted(boolean quoted) {
        this.quoted = quoted;
    }

    public void addCheckConstraint(String constraint) {
        this.checkConstraints.add(constraint);
    }

    public boolean containsColumn(Column column) {
        return this.columns.containsValue(column);
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append(this.getClass().getName()).append('(');
        if (this.getCatalog() != null) {
            buf.append(this.getCatalog() + ".");
        }
        if (this.getSchema() != null) {
            buf.append(this.getSchema() + ".");
        }
        buf.append(this.getName()).append(')');
        return buf.toString();
    }

    public String getSubselect() {
        return this.subselect;
    }

    public void setSubselect(String subselect) {
        this.subselect = subselect;
    }

    public boolean isSubselect() {
        return this.subselect != null;
    }

    public boolean isAbstractUnionTable() {
        return this.hasDenormalizedTables() && this.isAbstract;
    }

    public boolean hasDenormalizedTables() {
        return this.hasDenormalizedTables;
    }

    void setHasDenormalizedTables() {
        this.hasDenormalizedTables = true;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isPhysicalTable() {
        return !this.isSubselect() && !this.isAbstractUnionTable();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public Iterator getCheckConstraintsIterator() {
        return this.checkConstraints.iterator();
    }

    public Iterator sqlCommentStrings(Dialect dialect, String defaultCatalog, String defaultSchema) {
        ArrayList<String> comments = new ArrayList<String>();
        if (dialect.supportsCommentOn()) {
            String tableName = this.getQualifiedName(dialect, defaultCatalog, defaultSchema);
            if (this.comment != null) {
                StringBuffer buf = new StringBuffer().append("comment on table ").append(tableName).append(" is '").append(this.comment).append("'");
                comments.add(buf.toString());
            }
            Iterator iter = this.getColumnIterator();
            while (iter.hasNext()) {
                Column column = (Column)iter.next();
                String columnComment = column.getComment();
                if (columnComment == null) continue;
                StringBuffer buf = new StringBuffer().append("comment on column ").append(tableName).append('.').append(column.getQuotedName(dialect)).append(" is '").append(columnComment).append("'");
                comments.add(buf.toString());
            }
        }
        return comments.iterator();
    }

    static class ForeignKeyKey
    implements Serializable {
        String referencedClassName;
        List columns;
        List referencedColumns;

        ForeignKeyKey(List columns, String referencedClassName, List referencedColumns) {
            this.referencedClassName = referencedClassName;
            this.columns = new ArrayList();
            this.columns.addAll(columns);
            if (referencedColumns != null) {
                this.referencedColumns = new ArrayList();
                this.referencedColumns.addAll(referencedColumns);
            } else {
                this.referencedColumns = CollectionHelper.EMPTY_LIST;
            }
        }

        public int hashCode() {
            return ((Object)this.columns).hashCode() + ((Object)this.referencedColumns).hashCode();
        }

        public boolean equals(Object other) {
            ForeignKeyKey fkk = (ForeignKeyKey)other;
            return ((Object)fkk.columns).equals(this.columns) && fkk.referencedClassName.equals(this.referencedClassName) && ((Object)fkk.referencedColumns).equals(this.referencedColumns);
        }
    }
}

