/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.AnyMetaDef;
import org.hibernate.annotations.AnyMetaDefs;
import org.hibernate.annotations.MetaValue;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinderHelper {
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static Logger log = LoggerFactory.getLogger(BinderHelper.class);
    public static final Set<String> PRIMITIVE_NAMES;

    private BinderHelper() {
    }

    public static Property shallowCopy(Property property) {
        Property clone = new Property();
        clone.setCascade(property.getCascade());
        clone.setInsertable(property.isInsertable());
        clone.setLazy(property.isLazy());
        clone.setName(property.getName());
        clone.setNodeName(property.getNodeName());
        clone.setNaturalIdentifier(property.isNaturalIdentifier());
        clone.setOptimisticLocked(property.isOptimisticLocked());
        clone.setOptional(property.isOptional());
        clone.setPersistentClass(property.getPersistentClass());
        clone.setPropertyAccessorName(property.getPropertyAccessorName());
        clone.setSelectable(property.isSelectable());
        clone.setUpdateable(property.isUpdateable());
        clone.setValue(property.getValue());
        return clone;
    }

    public static void createSyntheticPropertyReference(Ejb3JoinColumn[] columns, PersistentClass ownerEntity, PersistentClass associatedEntity, Value value, boolean inverse, ExtendedMappings mappings) {
        PersistentClass associatedClass;
        if (columns[0].isImplicit() || StringHelper.isNotEmpty((String)columns[0].getMappedBy())) {
            return;
        }
        int fkEnum = Ejb3JoinColumn.checkReferencedColumnsType(columns, ownerEntity, mappings);
        PersistentClass persistentClass = associatedClass = columns[0].getPropertyHolder() != null ? columns[0].getPropertyHolder().getPersistentClass() : null;
        if (2 == fkEnum) {
            Component embeddedComp;
            StringBuilder propertyNameBuffer = new StringBuilder("_");
            propertyNameBuffer.append(associatedClass.getEntityName().replace('.', '_'));
            propertyNameBuffer.append("_").append(columns[0].getPropertyName());
            String syntheticPropertyName = propertyNameBuffer.toString();
            Object columnOwner = BinderHelper.findColumnOwner(ownerEntity, columns[0].getReferencedColumn(), mappings);
            List<Property> properties = BinderHelper.findPropertiesByColumns(columnOwner, columns, mappings);
            Property synthProp = null;
            if (properties != null) {
                embeddedComp = columnOwner instanceof PersistentClass ? new Component((PersistentClass)columnOwner) : new Component((Join)columnOwner);
                embeddedComp.setEmbedded(true);
                embeddedComp.setNodeName(syntheticPropertyName);
                embeddedComp.setComponentClassName(embeddedComp.getOwner().getClassName());
                for (Property property : properties) {
                    Property clone = BinderHelper.shallowCopy(property);
                    clone.setInsertable(false);
                    clone.setUpdateable(false);
                    clone.setNaturalIdentifier(false);
                    embeddedComp.addProperty(clone);
                }
            } else {
                StringBuilder columnsList = new StringBuilder();
                columnsList.append("referencedColumnNames(");
                for (Ejb3JoinColumn column : columns) {
                    columnsList.append(column.getReferencedColumn()).append(", ");
                }
                columnsList.setLength(columnsList.length() - 2);
                columnsList.append(") ");
                if (associatedEntity != null) {
                    columnsList.append("of ").append(associatedEntity.getEntityName()).append(".").append(columns[0].getPropertyName()).append(" ");
                } else if (columns[0].getPropertyHolder() != null) {
                    columnsList.append("of ").append(columns[0].getPropertyHolder().getEntityName()).append(".").append(columns[0].getPropertyName()).append(" ");
                }
                columnsList.append("referencing ").append(ownerEntity.getEntityName()).append(" not mapped to a single property");
                throw new AnnotationException(columnsList.toString());
            }
            synthProp = new Property();
            synthProp.setName(syntheticPropertyName);
            synthProp.setNodeName(syntheticPropertyName);
            synthProp.setPersistentClass(ownerEntity);
            synthProp.setUpdateable(false);
            synthProp.setInsertable(false);
            synthProp.setValue((Value)embeddedComp);
            synthProp.setPropertyAccessorName("embedded");
            ownerEntity.addProperty(synthProp);
            TableBinder.createUniqueConstraint((Value)embeddedComp);
            if (value instanceof ToOne) {
                ((ToOne)value).setReferencedPropertyName(syntheticPropertyName);
                mappings.addUniquePropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
            } else if (value instanceof Collection) {
                ((Collection)value).setReferencedPropertyName(syntheticPropertyName);
                mappings.addPropertyReference(ownerEntity.getEntityName(), syntheticPropertyName);
            } else {
                throw new AssertionFailure("Do a property ref on an unexpected Value type: " + value.getClass().getName());
            }
            mappings.addPropertyReferencedAssociation((inverse ? "inverse__" : ANNOTATION_STRING_DEFAULT) + associatedClass.getEntityName(), columns[0].getPropertyName(), syntheticPropertyName);
        }
    }

    private static List<Property> findPropertiesByColumns(Object columnOwner, Ejb3JoinColumn[] columns, ExtendedMappings mappings) {
        Iterator it;
        HashMap<Column, Set<Property>> columnsToProperty = new HashMap<Column, Set<Property>>();
        ArrayList<Column> orderedColumns = new ArrayList<Column>(columns.length);
        Table referencedTable = null;
        if (columnOwner instanceof PersistentClass) {
            referencedTable = ((PersistentClass)columnOwner).getTable();
        } else if (columnOwner instanceof Join) {
            referencedTable = ((Join)columnOwner).getTable();
        } else {
            throw new AssertionFailure(columnOwner == null ? "columnOwner is null" : "columnOwner neither PersistentClass nor Join: " + columnOwner.getClass());
        }
        for (Ejb3JoinColumn column1 : columns) {
            Column column = new Column(mappings.getPhysicalColumnName(column1.getReferencedColumn(), referencedTable));
            orderedColumns.add(column);
            columnsToProperty.put(column, new HashSet());
        }
        boolean isPersistentClass = columnOwner instanceof PersistentClass;
        Iterator iterator = it = isPersistentClass ? ((PersistentClass)columnOwner).getPropertyIterator() : ((Join)columnOwner).getPropertyIterator();
        while (it.hasNext()) {
            BinderHelper.matchColumnsByProperty((Property)it.next(), columnsToProperty);
        }
        if (isPersistentClass) {
            BinderHelper.matchColumnsByProperty(((PersistentClass)columnOwner).getIdentifierProperty(), columnsToProperty);
        }
        ArrayList<Property> orderedProperties = new ArrayList<Property>();
        for (Column column : orderedColumns) {
            boolean found = false;
            for (Property property : (Set)columnsToProperty.get(column)) {
                if (property.getColumnSpan() != 1) continue;
                orderedProperties.add(property);
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return orderedProperties;
    }

    private static void matchColumnsByProperty(Property property, Map<Column, Set<Property>> columnsToProperty) {
        if (property == null) {
            return;
        }
        if ("noop".equals(property.getPropertyAccessorName()) || "embedded".equals(property.getPropertyAccessorName())) {
            return;
        }
        Iterator columnIt = property.getColumnIterator();
        while (columnIt.hasNext()) {
            Object column = columnIt.next();
            if (!columnsToProperty.containsKey(column)) continue;
            columnsToProperty.get(column).add(property);
        }
    }

    public static Property findPropertyByName(PersistentClass associatedClass, String propertyName) {
        Property property = null;
        Property idProperty = associatedClass.getIdentifierProperty();
        String idName = idProperty != null ? idProperty.getName() : null;
        try {
            if (propertyName == null || propertyName.length() == 0 || propertyName.equals(idName)) {
                property = idProperty;
            } else {
                if (propertyName.indexOf(idName + ".") == 0) {
                    property = idProperty;
                    propertyName = propertyName.substring(idName.length() + 1);
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
        }
        catch (MappingException e) {
            try {
                if (associatedClass.getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = associatedClass.getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static Property findPropertyByName(Component component, String propertyName) {
        Property property = null;
        try {
            if (propertyName == null || propertyName.length() == 0) {
                return null;
            }
            StringTokenizer st = new StringTokenizer(propertyName, ".", false);
            while (st.hasMoreElements()) {
                String element = (String)st.nextElement();
                if (property == null) {
                    property = component.getProperty(element);
                    continue;
                }
                if (!property.isComposite()) {
                    return null;
                }
                property = ((Component)property.getValue()).getProperty(element);
            }
        }
        catch (MappingException e) {
            try {
                if (component.getOwner().getIdentifierMapper() == null) {
                    return null;
                }
                StringTokenizer st = new StringTokenizer(propertyName, ".", false);
                while (st.hasMoreElements()) {
                    String element = (String)st.nextElement();
                    if (property == null) {
                        property = component.getOwner().getIdentifierMapper().getProperty(element);
                        continue;
                    }
                    if (!property.isComposite()) {
                        return null;
                    }
                    property = ((Component)property.getValue()).getProperty(element);
                }
            }
            catch (MappingException ee) {
                return null;
            }
        }
        return property;
    }

    public static String getRelativePath(PropertyHolder propertyHolder, String propertyName) {
        if (propertyHolder == null) {
            return propertyName;
        }
        String path = propertyHolder.getPath();
        String entityName = propertyHolder.getPersistentClass().getEntityName();
        if (path.length() == entityName.length()) {
            return propertyName;
        }
        return StringHelper.qualify((String)path.substring(entityName.length() + 1), (String)propertyName);
    }

    public static Object findColumnOwner(PersistentClass persistentClass, String columnName, ExtendedMappings mappings) {
        if (StringHelper.isEmpty((String)columnName)) {
            return persistentClass;
        }
        PersistentClass current = persistentClass;
        Object result = null;
        boolean found = false;
        do {
            result = current;
            Table currentTable = current.getTable();
            try {
                mappings.getPhysicalColumnName(columnName, currentTable);
                found = true;
            }
            catch (MappingException me) {
                // empty catch block
            }
            Iterator joins = current.getJoinIterator();
            while (!found && joins.hasNext()) {
                result = joins.next();
                currentTable = ((Join)result).getTable();
                try {
                    mappings.getPhysicalColumnName(columnName, currentTable);
                    found = true;
                }
                catch (MappingException me) {}
            }
            current = current.getSuperclass();
        } while (!found && current != null);
        return found ? result : null;
    }

    public static void makeIdGenerator(SimpleValue id, String generatorType, String generatorName, ExtendedMappings mappings, Map<String, IdGenerator> localGenerators) {
        Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generatorType);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        if (id.getColumnSpan() == 1) {
            params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        }
        params.put("identifier_normalizer", mappings.getObjectNameNormalizer());
        if (!BinderHelper.isDefault(generatorName)) {
            boolean avoidOverriding;
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            String identifierGeneratorStrategy = gen.getIdentifierGeneratorStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("seqhilo") || identifierGeneratorStrategy.equals(MultipleHiLoPerTableGenerator.class.getName());
            if (generatorType == null || !avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
            }
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
        }
        if ("assigned".equals(generatorType)) {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorProperties(params);
    }

    public static boolean isDefault(String annotationString) {
        return annotationString != null && annotationString.length() == 0;
    }

    public static Any buildAnyValue(String anyMetaDefName, Ejb3JoinColumn[] columns, javax.persistence.Column metaColumn, PropertyData inferredData, boolean cascadeOnDelete, Nullability nullability, PropertyHolder propertyHolder, EntityBinder entityBinder, boolean optional, ExtendedMappings mappings) {
        Ejb3Column[] metaColumns;
        Any value = new Any(columns[0].getTable());
        AnyMetaDef metaAnnDef = (AnyMetaDef)inferredData.getProperty().getAnnotation(AnyMetaDef.class);
        if (metaAnnDef != null) {
            BinderHelper.bindAnyMetaDefs((XAnnotatedElement)inferredData.getProperty(), mappings);
        } else {
            metaAnnDef = mappings.getAnyMetaDef(anyMetaDefName);
        }
        if (metaAnnDef != null) {
            value.setIdentifierType(metaAnnDef.idType());
            value.setMetaType(metaAnnDef.metaType());
            HashMap<Object, String> values = new HashMap<Object, String>();
            Type metaType = TypeFactory.heuristicType((String)value.getMetaType());
            for (MetaValue metaValue : metaAnnDef.metaValues()) {
                try {
                    Object discrim = ((DiscriminatorType)metaType).stringToObject(metaValue.value());
                    String entityName = metaValue.targetEntity().getName();
                    values.put(discrim, entityName);
                }
                catch (ClassCastException cce) {
                    throw new MappingException("metaType was not a DiscriminatorType: " + metaType.getName());
                }
                catch (Exception e) {
                    throw new MappingException("could not interpret metaValue", (Throwable)e);
                }
            }
            if (!values.isEmpty()) {
                value.setMetaValues(values);
            }
        } else {
            throw new AnnotationException("Unable to find @AnyMetaDef for an @(ManyTo)Any mapping: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName()));
        }
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        for (Ejb3Column column : metaColumns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{metaColumn}, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings)) {
            column.setTable(value.getTable());
        }
        for (Ejb3Column column : metaColumns) {
            column.linkWithValue((SimpleValue)value);
        }
        String propertyName = inferredData.getPropertyName();
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        for (Ejb3JoinColumn column : columns) {
            column.linkWithValue((SimpleValue)value);
        }
        return value;
    }

    public static void bindAnyMetaDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        boolean mustHaveName;
        AnyMetaDef defAnn = (AnyMetaDef)annotatedElement.getAnnotation(AnyMetaDef.class);
        AnyMetaDefs defsAnn = (AnyMetaDefs)annotatedElement.getAnnotation(AnyMetaDefs.class);
        boolean bl = mustHaveName = XClass.class.isAssignableFrom(annotatedElement.getClass()) || XPackage.class.isAssignableFrom(annotatedElement.getClass());
        if (defAnn != null) {
            BinderHelper.checkAnyMetaDefValidity(mustHaveName, defAnn, annotatedElement);
            BinderHelper.bindAnyMetaDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (AnyMetaDef def : defsAnn.value()) {
                BinderHelper.checkAnyMetaDefValidity(mustHaveName, def, annotatedElement);
                BinderHelper.bindAnyMetaDef(def, mappings);
            }
        }
    }

    private static void checkAnyMetaDefValidity(boolean mustHaveName, AnyMetaDef defAnn, XAnnotatedElement annotatedElement) {
        if (mustHaveName && BinderHelper.isDefault(defAnn.name())) {
            String name = XClass.class.isAssignableFrom(annotatedElement.getClass()) ? ((XClass)annotatedElement).getName() : ((XPackage)annotatedElement).getName();
            throw new AnnotationException("@AnyMetaDef.name cannot be null on an entity or a package: " + name);
        }
    }

    private static void bindAnyMetaDef(AnyMetaDef defAnn, ExtendedMappings mappings) {
        if (BinderHelper.isDefault(defAnn.name())) {
            return;
        }
        log.info("Binding Any Meta definition: {}", (Object)defAnn.name());
        mappings.addAnyMetaDef(defAnn);
    }

    public static MappedSuperclass getMappedSuperclassOrNull(XClass declaringClass, Map<XClass, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings) {
        boolean retrieve = false;
        if (declaringClass != null) {
            InheritanceState inheritanceState = inheritanceStatePerClass.get(declaringClass);
            if (inheritanceState == null) {
                throw new org.hibernate.annotations.common.AssertionFailure("Declaring class is not found in the inheritance state hierarchy: " + declaringClass);
            }
            if (inheritanceState.isEmbeddableSuperclass()) {
                retrieve = true;
            }
        }
        return retrieve ? mappings.getMappedSuperclass(mappings.getReflectionManager().toClass(declaringClass)) : null;
    }

    public static String getPath(PropertyHolder holder, PropertyData property) {
        return StringHelper.qualify((String)holder.getPath(), (String)property.getPropertyName());
    }

    static PropertyData getPropertyAnnotatedWithMapsId(boolean isId, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        XClass persistentXClass;
        try {
            persistentXClass = mappings.getReflectionManager().classForName(propertyHolder.getPersistentClass().getClassName(), AnnotationBinder.class);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionFailure("PersistentClass name cannot be converted into a Class", (Throwable)e);
        }
        String propertyPath = isId ? ANNOTATION_STRING_DEFAULT : propertyName;
        PropertyData annotatedWithMapsId = mappings.getPropertyAnnotatedWithMapsId(persistentXClass, propertyPath);
        return annotatedWithMapsId;
    }

    static {
        HashSet<String> primitiveNames = new HashSet<String>();
        primitiveNames.add(Byte.TYPE.getName());
        primitiveNames.add(Short.TYPE.getName());
        primitiveNames.add(Integer.TYPE.getName());
        primitiveNames.add(Long.TYPE.getName());
        primitiveNames.add(Float.TYPE.getName());
        primitiveNames.add(Double.TYPE.getName());
        primitiveNames.add(Character.TYPE.getName());
        primitiveNames.add(Boolean.TYPE.getName());
        PRIMITIVE_NAMES = Collections.unmodifiableSet(primitiveNames);
    }
}

