/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeMap;
import javax.persistence.Access;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyContainer {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBinder.class);
    private final TreeMap<String, XProperty> fieldAccessMap;
    private final TreeMap<String, XProperty> propertyAccessMap;
    private final XClass xClass;
    private final AccessType explicitClassDefinedAccessType;

    PropertyContainer(XClass clazz) {
        this.xClass = clazz;
        this.fieldAccessMap = this.initProperties(AccessType.FIELD);
        this.propertyAccessMap = this.initProperties(AccessType.PROPERTY);
        this.explicitClassDefinedAccessType = this.determineClassDefinedAccessStrategy();
        this.checkForJpaAccess();
    }

    public XClass getXClass() {
        return this.xClass;
    }

    public AccessType getExplicitAccessStrategy() {
        return this.explicitClassDefinedAccessType;
    }

    public boolean hasExplicitAccessStrategy() {
        return !this.explicitClassDefinedAccessType.equals((Object)AccessType.DEFAULT);
    }

    public Collection<XProperty> getProperties(AccessType accessType) {
        if (AccessType.DEFAULT == accessType || AccessType.PROPERTY == accessType) {
            return this.propertyAccessMap.values();
        }
        return this.fieldAccessMap.values();
    }

    public void assertTypesAreResolvable(AccessType access) {
        TreeMap<String, XProperty> xprops = AccessType.PROPERTY.equals((Object)access) || AccessType.DEFAULT.equals((Object)access) ? this.propertyAccessMap : this.fieldAccessMap;
        for (XProperty property : xprops.values()) {
            if (property.isTypeResolved() || PropertyContainer.discoverTypeWithoutReflection(property)) continue;
            String msg = "Property " + StringHelper.qualify((String)this.xClass.getName(), (String)property.getName()) + " has an unbound type and no explicit target entity. Resolve this Generic usage issue" + " or set an explicit target attribute (eg @OneToMany(target=) or use an explicit @Type";
            throw new AnnotationException(msg);
        }
    }

    private void checkForJpaAccess() {
        AccessType accessType;
        Access access;
        ArrayList<XProperty> tmpList = new ArrayList<XProperty>();
        for (XProperty property : this.fieldAccessMap.values()) {
            access = (Access)property.getAnnotation(Access.class);
            if (access == null) continue;
            accessType = AccessType.getAccessStrategy(access.value());
            if (accessType == AccessType.PROPERTY) {
                log.warn("Placing @Access(AccessType.PROPERTY) on a field does not have any effect.");
                continue;
            }
            tmpList.add(property);
        }
        for (XProperty property : tmpList) {
            this.fieldAccessMap.remove(property.getName());
            this.propertyAccessMap.put(property.getName(), property);
        }
        tmpList.clear();
        for (XProperty property : this.propertyAccessMap.values()) {
            access = (Access)property.getAnnotation(Access.class);
            if (access == null) continue;
            accessType = AccessType.getAccessStrategy(access.value());
            if (accessType == AccessType.FIELD) {
                log.warn("Placing @Access(AccessType.FIELD) on a field does not have any effect.");
                continue;
            }
            tmpList.add(property);
        }
        for (XProperty property : tmpList) {
            this.propertyAccessMap.remove(property.getName());
            this.fieldAccessMap.put(property.getName(), property);
        }
    }

    private TreeMap<String, XProperty> initProperties(AccessType access) {
        TreeMap<String, XProperty> propertiesMap = new TreeMap<String, XProperty>();
        List properties = this.xClass.getDeclaredProperties(access.getType());
        for (XProperty property : properties) {
            if (PropertyContainer.mustBeSkipped(property)) continue;
            propertiesMap.put(property.getName(), property);
        }
        return propertiesMap;
    }

    private AccessType determineClassDefinedAccessStrategy() {
        Access access;
        AccessType hibernateDefinedAccessType = AccessType.DEFAULT;
        AccessType jpaDefinedAccessType = AccessType.DEFAULT;
        org.hibernate.annotations.AccessType accessType = (org.hibernate.annotations.AccessType)this.xClass.getAnnotation(org.hibernate.annotations.AccessType.class);
        if (accessType != null) {
            hibernateDefinedAccessType = AccessType.getAccessStrategy(accessType.value());
        }
        if ((access = (Access)this.xClass.getAnnotation(Access.class)) != null) {
            jpaDefinedAccessType = AccessType.getAccessStrategy(access.value());
        }
        if (hibernateDefinedAccessType != AccessType.DEFAULT && jpaDefinedAccessType != AccessType.DEFAULT && hibernateDefinedAccessType != jpaDefinedAccessType) {
            throw new MappingException("@AccessType and @Access specified with contradicting values. Use of @Access only is recommended. ");
        }
        AccessType classDefinedAccessType = hibernateDefinedAccessType != AccessType.DEFAULT ? hibernateDefinedAccessType : jpaDefinedAccessType;
        return classDefinedAccessType;
    }

    private static boolean discoverTypeWithoutReflection(XProperty p) {
        if (p.isAnnotationPresent(OneToOne.class) && !((OneToOne)p.getAnnotation(OneToOne.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(OneToMany.class) && !((OneToMany)p.getAnnotation(OneToMany.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(ManyToOne.class) && !((ManyToOne)p.getAnnotation(ManyToOne.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(ManyToMany.class) && !((ManyToMany)p.getAnnotation(ManyToMany.class)).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(Any.class)) {
            return true;
        }
        if (p.isAnnotationPresent(ManyToAny.class)) {
            if (!p.isCollection() && !p.isArray()) {
                throw new AnnotationException("@ManyToAny used on a non collection non array property: " + p.getName());
            }
            return true;
        }
        if (p.isAnnotationPresent(Type.class)) {
            return true;
        }
        return p.isAnnotationPresent(Target.class);
    }

    private static boolean mustBeSkipped(XProperty property) {
        return property.isAnnotationPresent(Transient.class) || "net.sf.cglib.transform.impl.InterceptFieldCallback".equals(property.getType().getName()) || "org.hibernate.bytecode.javassist.FieldHandler".equals(property.getType().getName());
    }
}

