/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyJoinColumn;
import javax.persistence.MapKeyJoinColumns;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.OrderColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.EntityMode;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.Any;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.CollectionId;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.GenericGenerators;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.JoinColumnsOrFormulas;
import org.hibernate.annotations.LazyToOne;
import org.hibernate.annotations.LazyToOneOption;
import org.hibernate.annotations.ManyToAny;
import org.hibernate.annotations.MapKey;
import org.hibernate.annotations.MapKeyManyToMany;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NaturalId;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Parent;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.Tuplizer;
import org.hibernate.annotations.Tuplizers;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XAnnotatedElement;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.annotations.common.reflection.XPackage;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.cfg.AccessType;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CreateKeySecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.JoinedSubclassFkSecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.OneToOneSecondPass;
import org.hibernate.cfg.PropertyContainer;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.SecondaryTableSecondPass;
import org.hibernate.cfg.ToOneFkSecondPass;
import org.hibernate.cfg.UniqueConstraintHolder;
import org.hibernate.cfg.WrappedInferredData;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.MapKeyColumnDelegator;
import org.hibernate.cfg.annotations.MapKeyJoinColumnDelegator;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.StringHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final Logger log = LoggerFactory.getLogger(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindDefaults(ExtendedMappings mappings) {
        IdGenerator idGen;
        Map defaults = mappings.getReflectionManager().getDefaults();
        List anns = (List)defaults.get(SequenceGenerator.class);
        if (anns != null) {
            for (SequenceGenerator ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
                if (idGen == null) continue;
                mappings.addDefaultGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(TableGenerator.class)) != null) {
            for (SequenceGenerator ann : anns) {
                idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
                if (idGen == null) continue;
                mappings.addDefaultGenerator(idGen);
            }
        }
        if ((anns = (List)defaults.get(NamedQuery.class)) != null) {
            for (SequenceGenerator ann : anns) {
                QueryBinder.bindQuery((NamedQuery)ann, mappings, true);
            }
        }
        if ((anns = (List)defaults.get(javax.persistence.NamedNativeQuery.class)) != null) {
            for (SequenceGenerator ann : anns) {
                QueryBinder.bindNativeQuery((javax.persistence.NamedNativeQuery)ann, mappings, true);
            }
        }
        if ((anns = (List)defaults.get(SqlResultSetMapping.class)) != null) {
            for (SequenceGenerator ann : anns) {
                QueryBinder.bindSqlResultsetMapping((SqlResultSetMapping)ann, mappings, true);
            }
        }
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        SequenceGenerator ann;
        XPackage pckg;
        try {
            pckg = mappings.getReflectionManager().packageForName(packageName);
        }
        catch (ClassNotFoundException cnf) {
            log.warn("Package not found or wo package-info.java: {}", (Object)packageName);
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = (SequenceGenerator)pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
            mappings.addGenerator(idGen);
            log.debug("Add sequence generator with name: {}", (Object)idGen.getName());
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = (TableGenerator)pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
            mappings.addGenerator(idGen);
        }
        AnnotationBinder.bindGenericGenerators((XAnnotatedElement)pckg, mappings);
        AnnotationBinder.bindQueries((XAnnotatedElement)pckg, mappings);
        AnnotationBinder.bindFilterDefs((XAnnotatedElement)pckg, mappings);
        AnnotationBinder.bindTypeDefs((XAnnotatedElement)pckg, mappings);
        BinderHelper.bindAnyMetaDefs((XAnnotatedElement)pckg, mappings);
    }

    private static void bindGenericGenerators(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        GenericGenerator defAnn = (GenericGenerator)annotatedElement.getAnnotation(GenericGenerator.class);
        GenericGenerators defsAnn = (GenericGenerators)annotatedElement.getAnnotation(GenericGenerators.class);
        if (defAnn != null) {
            AnnotationBinder.bindGenericGenerator(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (GenericGenerator def : defsAnn.value()) {
                AnnotationBinder.bindGenericGenerator(def, mappings);
            }
        }
    }

    private static void bindGenericGenerator(GenericGenerator def, ExtendedMappings mappings) {
        IdGenerator idGen = AnnotationBinder.buildIdGenerator(def, mappings);
        mappings.addGenerator(idGen);
    }

    private static void bindQueries(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        Object ann = (SqlResultSetMapping)annotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping(ann, mappings, false);
        ann = (SqlResultSetMappings)annotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (ann != null) {
            for (SqlResultSetMapping current : ann.value()) {
                QueryBinder.bindSqlResultsetMapping(current, mappings, false);
            }
        }
        ann = (NamedQuery)annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)ann, mappings, false);
        ann = (org.hibernate.annotations.NamedQuery)annotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)ann, mappings);
        ann = (javax.persistence.NamedQueries)annotatedElement.getAnnotation(javax.persistence.NamedQueries.class);
        QueryBinder.bindQueries((javax.persistence.NamedQueries)ann, mappings, false);
        ann = (NamedQueries)annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings);
        ann = (javax.persistence.NamedNativeQuery)annotatedElement.getAnnotation(javax.persistence.NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((javax.persistence.NamedNativeQuery)ann, mappings, false);
        ann = (NamedNativeQuery)annotatedElement.getAnnotation(NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((NamedNativeQuery)ann, mappings);
        ann = (javax.persistence.NamedNativeQueries)annotatedElement.getAnnotation(javax.persistence.NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((javax.persistence.NamedNativeQueries)ann, mappings, false);
        ann = (NamedNativeQueries)annotatedElement.getAnnotation(NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((NamedNativeQueries)ann, mappings);
    }

    private static IdGenerator buildIdGenerator(Annotation ann, Mappings mappings) {
        IdGenerator idGen = new IdGenerator();
        if (mappings.getSchemaName() != null) {
            idGen.addParam("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            idGen.addParam("catalog", mappings.getCatalogName());
        }
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!BinderHelper.isDefault(tabGen.table())) {
                idGen.addParam("table", tabGen.table());
            }
            if (!BinderHelper.isDefault(tabGen.catalog())) {
                idGen.addParam("catalog", tabGen.catalog());
            }
            if (!BinderHelper.isDefault(tabGen.schema())) {
                idGen.addParam("schema", tabGen.schema());
            }
            if (!BinderHelper.isDefault(tabGen.pkColumnName())) {
                idGen.addParam("primary_key_column", tabGen.pkColumnName());
            }
            if (!BinderHelper.isDefault(tabGen.valueColumnName())) {
                idGen.addParam("value_column", tabGen.valueColumnName());
            }
            if (!BinderHelper.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize() - 1));
            log.debug("Add table generator with name: {}", (Object)idGen.getName());
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("seqhilo");
            if (!BinderHelper.isDefault(seqGen.sequenceName())) {
                idGen.addParam("sequence", seqGen.sequenceName());
            }
            if (seqGen.initialValue() != 1) {
                log.warn("Hibernate does not support SequenceGenerator.initialValue()");
            }
            idGen.addParam("max_lo", String.valueOf(seqGen.allocationSize() - 1));
            log.debug("Add sequence generator with name: {}", (Object)idGen.getName());
        } else if (ann instanceof GenericGenerator) {
            Parameter[] params;
            GenericGenerator genGen = (GenericGenerator)ann;
            idGen.setName(genGen.name());
            idGen.setIdentifierGeneratorStrategy(genGen.strategy());
            for (Parameter parameter : params = genGen.parameters()) {
                idGen.addParam(parameter.name(), parameter.value());
            }
            log.debug("Add generic generator with name: {}", (Object)idGen.getName());
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings) throws MappingException {
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        AnnotatedClassType classType = mappings.getClassType(clazzToProcess);
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType)) {
            AnnotationBinder.bindQueries((XAnnotatedElement)clazzToProcess, mappings);
            AnnotationBinder.bindTypeDefs((XAnnotatedElement)clazzToProcess, mappings);
            AnnotationBinder.bindFilterDefs((XAnnotatedElement)clazzToProcess, mappings);
        }
        if (!AnnotationBinder.isEntityClassType(clazzToProcess, classType)) {
            return;
        }
        log.info("Binding entity from annotated class: {}", (Object)clazzToProcess.getName());
        PersistentClass superEntity = AnnotationBinder.getSuperEntity(clazzToProcess, inheritanceStatePerClass, mappings, inheritanceState);
        AnnotationBinder.bindQueries((XAnnotatedElement)clazzToProcess, mappings);
        AnnotationBinder.bindFilterDefs((XAnnotatedElement)clazzToProcess, mappings);
        AnnotationBinder.bindTypeDefs((XAnnotatedElement)clazzToProcess, mappings);
        BinderHelper.bindAnyMetaDefs((XAnnotatedElement)clazzToProcess, mappings);
        String schema = "";
        String table = "";
        String catalog = "";
        ArrayList<UniqueConstraintHolder> uniqueConstraints = new ArrayList();
        if (clazzToProcess.isAnnotationPresent(Table.class)) {
            Table tabAnn = (Table)clazzToProcess.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            uniqueConstraints = TableBinder.buildUniqueConstraintHolders(tabAnn.uniqueConstraints());
        }
        Ejb3JoinColumn[] inheritanceJoinedColumns = AnnotationBinder.makeInheritanceJoinColumns(clazzToProcess, mappings, inheritanceState, superEntity);
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        String discrimValue = null;
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            DiscriminatorColumn discAnn = (DiscriminatorColumn)clazzToProcess.getAnnotation(DiscriminatorColumn.class);
            DiscriminatorType discriminatorType = discAnn != null ? discAnn.discriminatorType() : DiscriminatorType.STRING;
            DiscriminatorFormula discFormulaAnn = (DiscriminatorFormula)clazzToProcess.getAnnotation(DiscriminatorFormula.class);
            if (!inheritanceState.hasParents()) {
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, discFormulaAnn, mappings);
            }
            if (discAnn != null && inheritanceState.hasParents()) {
                log.warn("Discriminator column has to be defined in the root entity, it will be ignored in subclass: {}", (Object)clazzToProcess.getName());
            }
            discrimValue = clazzToProcess.isAnnotationPresent(DiscriminatorValue.class) ? ((DiscriminatorValue)clazzToProcess.getAnnotation(DiscriminatorValue.class)).value() : null;
        }
        PersistentClass persistentClass = AnnotationBinder.makePersistentClass(inheritanceState, superEntity);
        Proxy proxyAnn = (Proxy)clazzToProcess.getAnnotation(Proxy.class);
        BatchSize sizeAnn = (BatchSize)clazzToProcess.getAnnotation(BatchSize.class);
        Where whereAnn = (Where)clazzToProcess.getAnnotation(Where.class);
        Entity entityAnn = (Entity)clazzToProcess.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = (org.hibernate.annotations.Entity)clazzToProcess.getAnnotation(org.hibernate.annotations.Entity.class);
        Cache cacheAnn = (Cache)clazzToProcess.getAnnotation(Cache.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, clazzToProcess, persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.setCache(cacheAnn);
        entityBinder.setInheritanceState(inheritanceState);
        if (!inheritanceState.hasParents()) {
            AnnotationBinder.bindFilters(clazzToProcess, entityBinder, mappings);
        }
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            Check checkAnn = (Check)clazzToProcess.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, inheritanceState.hasDenormalizedTable() ? superEntity.getTable() : null);
        } else if (clazzToProcess.isAnnotationPresent(Table.class)) {
            log.warn("Illegal use of @Table in a subclass of a SINGLE_TABLE hierarchy: " + clazzToProcess.getName());
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, persistentClass, entityBinder, mappings, inheritanceStatePerClass);
        SecondaryTable secTabAnn = (SecondaryTable)clazzToProcess.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = (SecondaryTables)clazzToProcess.getAnnotation(SecondaryTables.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn);
        OnDelete onDeleteAnn = (OnDelete)clazzToProcess.getAnnotation(OnDelete.class);
        boolean onDeleteAppropriate = false;
        if (InheritanceType.JOINED.equals((Object)inheritanceState.getType()) && inheritanceState.hasParents()) {
            onDeleteAppropriate = true;
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey((KeyValue)key);
            ForeignKey fk = (ForeignKey)clazzToProcess.getAnnotation(ForeignKey.class);
            if (fk != null && !BinderHelper.isDefault(fk.name())) {
                key.setForeignKeyName(fk.name());
            }
            if (onDeleteAnn != null) {
                key.setCascadeDeleteEnabled(OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action()));
            } else {
                key.setCascadeDeleteEnabled(false);
            }
            JoinedSubclassFkSecondPass sp = new JoinedSubclassFkSecondPass(jsc, inheritanceJoinedColumns, (SimpleValue)key, mappings);
            mappings.addSecondPass(sp);
            mappings.addSecondPass(new CreateKeySecondPass(jsc));
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            if (inheritanceState.hasParents()) {
                if (persistentClass.getEntityPersisterClass() == null) {
                    persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
                }
            } else if (inheritanceState.hasSiblings() || !discriminatorColumn.isImplicit()) {
                AnnotationBinder.bindDiscriminatorToPersistentClass((RootClass)persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder);
                entityBinder.bindDiscriminatorValue();
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.getType()) && inheritanceState.hasParents() && persistentClass.getEntityPersisterClass() == null) {
            persistentClass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        if (onDeleteAnn != null && !onDeleteAppropriate) {
            log.warn("Inapropriate use of @OnDelete on entity, annotation ignored: {}", (Object)propertyHolder.getEntityName());
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators((XAnnotatedElement)clazzToProcess, mappings);
        List<PropertyData> elements = AnnotationBinder.getElementsToProcess(persistentClass, clazzToProcess, inheritanceStatePerClass, entityBinder, mappings);
        boolean subclassAndSingleTableStrategy = inheritanceState.getType() == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents();
        HashSet<String> idProperties = new HashSet<String>();
        IdClass idClass = null;
        XClass current = null;
        if (!inheritanceState.hasParents()) {
            InheritanceState state = inheritanceState;
            do {
                if (!(current = state.getClazz()).isAnnotationPresent(IdClass.class)) continue;
                idClass = (IdClass)current.getAnnotation(IdClass.class);
                break;
            } while ((state = InheritanceState.getSuperclassInheritanceState(current, inheritanceStatePerClass)) != null);
        }
        if (idClass != null) {
            XClass compositeClass = mappings.getReflectionManager().toXClass(idClass.value());
            boolean isComponent = true;
            AccessType propertyAccessor = entityBinder.getPropertyAccessor((XAnnotatedElement)compositeClass);
            String generatorType = "assigned";
            String generator = "";
            PropertyPreloadedData inferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", compositeClass);
            PropertyPreloadedData baseInferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessType(), "id", current);
            HashMap<String, IdGenerator> localGenerators = new HashMap<String, IdGenerator>();
            boolean ignoreIdAnnotations = entityBinder.isIgnoreIdAnnotations();
            entityBinder.setIgnoreIdAnnotations(true);
            AnnotationBinder.bindId(generatorType, generator, inferredData, baseInferredData, null, propertyHolder, localGenerators, isComponent, propertyAccessor, entityBinder, true, false, mappings, inheritanceStatePerClass);
            inferredData = new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass);
            Component mapper = AnnotationBinder.fillComponent(propertyHolder, inferredData, baseInferredData, propertyAccessor, false, entityBinder, true, true, false, mappings, inheritanceStatePerClass);
            entityBinder.setIgnoreIdAnnotations(ignoreIdAnnotations);
            persistentClass.setIdentifierMapper(mapper);
            org.hibernate.mapping.MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, mappings);
            if (superclass != null) {
                superclass.setDeclaredIdentifierMapper(mapper);
            } else {
                persistentClass.setDeclaredIdentifierMapper(mapper);
            }
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue((Value)mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            Iterator properties = mapper.getPropertyIterator();
            while (properties.hasNext()) {
                idProperties.add(((Property)properties.next()).getName());
            }
        }
        HashSet missingIdProperties = new HashSet(idProperties);
        for (PropertyData propertyAnnotatedElement : elements) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idProperties.contains(propertyName)) {
                AnnotationBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement.getProperty(), propertyAnnotatedElement, classGenerators, entityBinder, false, false, false, mappings, inheritanceStatePerClass);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (missingIdProperties.size() != 0) {
            StringBuilder missings = new StringBuilder();
            for (String property : missingIdProperties) {
                missings.append(property).append(", ");
            }
            throw new AnnotationException("Unable to find properties (" + missings.substring(0, missings.length() - 2) + ") in entity annotated with @IdClass:" + persistentClass.getEntityName());
        }
        if (!inheritanceState.hasParents()) {
            RootClass rootClass = (RootClass)persistentClass;
            mappings.addSecondPass(new CreateKeySecondPass(rootClass));
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass(persistentClass);
        mappings.addSecondPass(new SecondaryTableSecondPass(entityBinder, propertyHolder, (XAnnotatedElement)clazzToProcess));
        entityBinder.processComplementaryTableDefinitions((org.hibernate.annotations.Table)clazzToProcess.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.processComplementaryTableDefinitions((Tables)clazzToProcess.getAnnotation(Tables.class));
    }

    private static PersistentClass makePersistentClass(InheritanceState inheritanceState, PersistentClass superEntity) {
        RootClass persistentClass;
        if (!inheritanceState.hasParents()) {
            persistentClass = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.getType())) {
            persistentClass = new SingleTableSubclass(superEntity);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.getType())) {
            persistentClass = new JoinedSubclass(superEntity);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.getType())) {
            persistentClass = new UnionSubclass(superEntity);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.getType());
        }
        return persistentClass;
    }

    private static Ejb3JoinColumn[] makeInheritanceJoinColumns(XClass clazzToProcess, ExtendedMappings mappings, InheritanceState inheritanceState, PersistentClass superEntity) {
        boolean hasJoinedColumns;
        Ejb3JoinColumn[] inheritanceJoinedColumns = null;
        boolean bl = hasJoinedColumns = inheritanceState.hasParents() && InheritanceType.JOINED.equals((Object)inheritanceState.getType());
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            PrimaryKeyJoinColumns jcsAnn = (PrimaryKeyJoinColumns)clazzToProcess.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    PrimaryKeyJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, null, (Value)superEntity.getIdentifier(), null, null, mappings);
                }
            } else {
                PrimaryKeyJoinColumn jcAnn = (PrimaryKeyJoinColumn)clazzToProcess.getAnnotation(PrimaryKeyJoinColumn.class);
                inheritanceJoinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, null, (Value)superEntity.getIdentifier(), null, null, mappings)};
            }
            log.debug("Subclass joined column(s) created");
        } else if (clazzToProcess.isAnnotationPresent(PrimaryKeyJoinColumns.class) || clazzToProcess.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            log.warn("Root entity should not hold an PrimaryKeyJoinColum(s), will be ignored");
        }
        return inheritanceJoinedColumns;
    }

    private static PersistentClass getSuperEntity(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings, InheritanceState inheritanceState) {
        PersistentClass superEntity;
        InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazzToProcess, inheritanceStatePerClass);
        PersistentClass persistentClass = superEntity = superEntityState != null ? mappings.getClass(superEntityState.getClazz().getName()) : null;
        if (superEntity == null && inheritanceState.hasParents()) {
            throw new AssertionFailure("Subclass has to be binded after it's mother class: " + superEntityState.getClazz().getName());
        }
        return superEntity;
    }

    private static boolean isEntityClassType(XClass clazzToProcess, AnnotatedClassType classType) {
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType) || AnnotatedClassType.NONE.equals((Object)classType) || AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
            if (AnnotatedClassType.NONE.equals((Object)classType) && clazzToProcess.isAnnotationPresent(org.hibernate.annotations.Entity.class)) {
                log.warn("Class annotated @org.hibernate.annotations.Entity but not javax.persistence.Entity (most likely a user error): {}", (Object)clazzToProcess.getName());
            }
            return false;
        }
        if (!classType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + clazzToProcess.getName());
        }
        return true;
    }

    private static List<PropertyData> getElementsToProcess(PersistentClass persistentClass, XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, EntityBinder entityBinder, ExtendedMappings mappings) {
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        assert (!inheritanceState.isEmbeddableSuperclass());
        List<XClass> classesToProcess = AnnotationBinder.getMappedSuperclassesTillNextEntityOrdered(persistentClass, clazzToProcess, inheritanceStatePerClass, mappings);
        AccessType accessType = AnnotationBinder.determineDefaultAccessType(clazzToProcess, inheritanceStatePerClass);
        ArrayList<PropertyData> elements = new ArrayList<PropertyData>();
        int deep = classesToProcess.size();
        boolean hasIdentifier = false;
        for (int index = 0; index < deep; ++index) {
            PropertyContainer properyContainer = new PropertyContainer(classesToProcess.get(index));
            boolean currentHasIdentifier = AnnotationBinder.addElementsOfClass(elements, accessType, properyContainer, mappings);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        entityBinder.setPropertyAccessType(accessType);
        if (!hasIdentifier && !inheritanceState.hasParents()) {
            throw new AnnotationException("No identifier specified for entity: " + clazzToProcess.getName());
        }
        return elements;
    }

    private static AccessType determineDefaultAccessType(XClass annotatedClass, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        for (XClass xclass = annotatedClass; xclass != null && !Object.class.getName().equals(xclass.getName()); xclass = xclass.getSuperclass()) {
            if (!xclass.isAnnotationPresent(Entity.class) && !xclass.isAnnotationPresent(MappedSuperclass.class)) continue;
            for (XProperty prop : xclass.getDeclaredProperties(AccessType.PROPERTY.getType())) {
                if (!prop.isAnnotationPresent(Id.class) && !prop.isAnnotationPresent(EmbeddedId.class)) continue;
                return AccessType.PROPERTY;
            }
            for (XProperty prop : xclass.getDeclaredProperties(AccessType.FIELD.getType())) {
                if (!prop.isAnnotationPresent(Id.class) && !prop.isAnnotationPresent(EmbeddedId.class)) continue;
                return AccessType.FIELD;
            }
        }
        throw new AnnotationException("No identifier specified for entity: " + annotatedClass.getName());
    }

    private static List<XClass> getMappedSuperclassesTillNextEntityOrdered(PersistentClass persistentClass, XClass annotatedClass, Map<XClass, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings) {
        InheritanceState superclassState;
        ArrayList<XClass> classesToProcess = new ArrayList<XClass>();
        XClass currentClassInHierarchy = annotatedClass;
        ReflectionManager reflectionManager = mappings.getReflectionManager();
        do {
            classesToProcess.add(0, currentClassInHierarchy);
            XClass superClass = currentClassInHierarchy;
            do {
                superClass = superClass.getSuperclass();
                superclassState = inheritanceStatePerClass.get(superClass);
            } while (superClass != null && !reflectionManager.equals(superClass, Object.class) && superclassState == null);
            currentClassInHierarchy = superClass;
        } while (superclassState != null && superclassState.isEmbeddableSuperclass());
        org.hibernate.mapping.MappedSuperclass mappedSuperclass = null;
        InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(annotatedClass, inheritanceStatePerClass);
        PersistentClass superEntity = superEntityState != null ? mappings.getClass(superEntityState.getClazz().getName()) : null;
        int lastMappedSuperclass = classesToProcess.size() - 1;
        for (int index = 0; index < lastMappedSuperclass; ++index) {
            org.hibernate.mapping.MappedSuperclass parentSuperclass = mappedSuperclass;
            Class type = mappings.getReflectionManager().toClass((XClass)classesToProcess.get(index));
            mappedSuperclass = mappings.getMappedSuperclass(type);
            if (mappedSuperclass != null) continue;
            mappedSuperclass = new org.hibernate.mapping.MappedSuperclass(parentSuperclass, superEntity);
            mappedSuperclass.setMappedClass(type);
            mappings.addMappedSuperclass(type, mappedSuperclass);
        }
        if (mappedSuperclass != null) {
            persistentClass.setSuperMappedSuperclass(mappedSuperclass);
        }
        return classesToProcess;
    }

    private static void bindFilters(XClass annotatedClass, EntityBinder entityBinder, ExtendedMappings mappings) {
        AnnotationBinder.bindFilters((XAnnotatedElement)annotatedClass, entityBinder);
        for (XClass classToProcess = annotatedClass.getSuperclass(); classToProcess != null; classToProcess = classToProcess.getSuperclass()) {
            AnnotatedClassType classType = mappings.getClassType(classToProcess);
            if (!AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType)) continue;
            AnnotationBinder.bindFilters((XAnnotatedElement)classToProcess, entityBinder);
        }
    }

    private static void bindFilters(XAnnotatedElement annotatedElement, EntityBinder entityBinder) {
        Filter filterAnn;
        Filters filtersAnn = (Filters)annotatedElement.getAnnotation(Filters.class);
        if (filtersAnn != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter.name(), filter.condition());
            }
        }
        if ((filterAnn = (Filter)annotatedElement.getAnnotation(Filter.class)) != null) {
            entityBinder.addFilter(filterAnn.name(), filterAnn.condition());
        }
    }

    private static void bindFilterDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        FilterDef defAnn = (FilterDef)annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = (FilterDefs)annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, ExtendedMappings mappings) {
        HashMap<String, Type> params = new HashMap<String, Type>();
        for (ParamDef param : defAnn.parameters()) {
            params.put(param.name(), TypeFactory.heuristicType((String)param.type()));
        }
        FilterDefinition def = new FilterDefinition(defAnn.name(), defAnn.defaultCondition(), params);
        log.info("Binding filter definition: {}", (Object)def.getFilterName());
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        TypeDef defAnn = (TypeDef)annotatedElement.getAnnotation(TypeDef.class);
        TypeDefs defsAnn = (TypeDefs)annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindTypeDef(TypeDef defAnn, ExtendedMappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        if (BinderHelper.isDefault(defAnn.name()) && defAnn.defaultForType().equals(Void.TYPE)) {
            throw new AnnotationException("Either name or defaultForType (or both) attribute should be set in TypeDef having typeClass " + defAnn.typeClass().getName());
        }
        if (!BinderHelper.isDefault(defAnn.name())) {
            log.info("Binding type definition: {}", (Object)defAnn.name());
            mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
        }
        if (!defAnn.defaultForType().equals(Void.TYPE)) {
            log.info("Binding type definition: {}", (Object)defAnn.defaultForType().getName());
            mappings.addTypeDef(defAnn.defaultForType().getName(), defAnn.typeClass().getName(), params);
        }
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator((Value)discrim);
            discriminatorColumn.linkWithValue(discrim);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug("Setting discriminator for entity {}", (Object)rootClass.getEntityName());
        }
    }

    private static boolean addElementsOfClass(List<PropertyData> elements, AccessType defaultAccessType, PropertyContainer propertyContainer, ExtendedMappings mappings) {
        boolean hasIdentifier = false;
        AccessType accessType = defaultAccessType;
        if (propertyContainer.hasExplicitAccessStrategy()) {
            accessType = propertyContainer.getExplicitAccessStrategy();
        }
        propertyContainer.assertTypesAreResolvable(accessType);
        Collection<XProperty> properties = propertyContainer.getProperties(accessType);
        for (XProperty p : properties) {
            boolean currentHasIdentifier = AnnotationBinder.addProperty(propertyContainer.getXClass(), p, elements, accessType.getType(), mappings);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        return hasIdentifier;
    }

    private static boolean addProperty(XClass declaringClass, XProperty property, List<PropertyData> annElts, String propertyAccessor, ExtendedMappings mappings) {
        boolean hasIdentifier;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(declaringClass, property, propertyAccessor, mappings.getReflectionManager());
        XProperty element = propertyAnnotatedElement.getProperty();
        if (element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class)) {
            annElts.add(0, propertyAnnotatedElement);
            hasIdentifier = true;
        } else {
            annElts.add(propertyAnnotatedElement);
            hasIdentifier = false;
        }
        return hasIdentifier;
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, XProperty property, PropertyData inferredData, HashMap<String, IdGenerator> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, boolean inSecondPass, ExtendedMappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) throws MappingException {
        block96: {
            NaturalId naturalIdAnn;
            Object ann;
            int length;
            Ejb3Column[] columns = null;
            Ejb3JoinColumn[] joinColumns = null;
            log.debug("Processing annotations of {}.{}", (Object)propertyHolder.getEntityName(), (Object)inferredData.getPropertyName());
            if (property.isAnnotationPresent(Parent.class)) {
                if (!propertyHolder.isComponent()) {
                    throw new AnnotationException("@Parent cannot be applied outside an embeddable object: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)property.getName()));
                }
                propertyHolder.setParentProperty(property.getName());
                return;
            }
            Object anns = null;
            if (property.isAnnotationPresent(JoinColumn.class)) {
                anns = new JoinColumn[]{(JoinColumn)property.getAnnotation(JoinColumn.class)};
            } else if (property.isAnnotationPresent(JoinColumns.class) && (length = ((JoinColumn[])(anns = (ann = (JoinColumns)property.getAnnotation(JoinColumns.class)).value())).length) == 0) {
                throw new AnnotationException("Cannot bind an empty @JoinColumns");
            }
            if (anns != null) {
                joinColumns = Ejb3JoinColumn.buildJoinColumns((JoinColumn[])anns, null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            } else if (property.isAnnotationPresent(JoinColumnsOrFormulas.class)) {
                ann = (JoinColumnsOrFormulas)property.getAnnotation(JoinColumnsOrFormulas.class);
                joinColumns = Ejb3JoinColumn.buildJoinColumnsOrFormulas((JoinColumnsOrFormulas)ann, null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            }
            if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
                javax.persistence.Column ann2 = (javax.persistence.Column)property.getAnnotation(javax.persistence.Column.class);
                Formula formulaAnn = (Formula)property.getAnnotation(Formula.class);
                columns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann2}, formulaAnn, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            } else if (property.isAnnotationPresent(Columns.class)) {
                anns = (Columns)property.getAnnotation(Columns.class);
                columns = Ejb3Column.buildColumnFromAnnotation(anns.columns(), null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            }
            if (joinColumns == null && (property.isAnnotationPresent(javax.persistence.ManyToOne.class) || property.isAnnotationPresent(OneToOne.class))) {
                JoinTable joinTableAnn = propertyHolder.getJoinTable(property);
                if (joinTableAnn != null) {
                    joinColumns = Ejb3JoinColumn.buildJoinColumns(joinTableAnn.inverseJoinColumns(), null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
                    if (StringHelper.isEmpty((String)joinTableAnn.name())) {
                        throw new AnnotationException("JoinTable.name() on a @ToOne association has to be explicit: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName()));
                    }
                } else {
                    OneToOne oneToOneAnn = (OneToOne)property.getAnnotation(OneToOne.class);
                    String mappedBy = oneToOneAnn != null ? oneToOneAnn.mappedBy() : null;
                    joinColumns = Ejb3JoinColumn.buildJoinColumns(null, mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
                }
            } else if (joinColumns == null && (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(CollectionOfElements.class) || property.isAnnotationPresent(ElementCollection.class))) {
                OneToMany oneToMany = (OneToMany)property.getAnnotation(OneToMany.class);
                String mappedBy = oneToMany != null ? oneToMany.mappedBy() : "";
                joinColumns = Ejb3JoinColumn.buildJoinColumns(null, mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            } else if (joinColumns == null && property.isAnnotationPresent(Any.class)) {
                throw new AnnotationException("@Any requires an explicit @JoinColumn(s): " + StringHelper.qualify((String)propertyHolder.getPath(), (String)property.getName()));
            }
            if (columns == null && !property.isAnnotationPresent(ManyToMany.class)) {
                columns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            }
            if (nullability == Nullability.FORCED_NOT_NULL) {
                for (Ejb3Column col : columns) {
                    col.forceNotNull();
                }
            }
            XClass returnedClass = inferredData.getClassOrElement();
            if (!entityBinder.isIgnoreIdAnnotations() && (property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(EmbeddedId.class))) {
                String string;
                if (isIdentifierMapper) {
                    throw new AnnotationException("@IdClass class should not have @Id nor @EmbeddedId properties");
                }
                log.debug("{} is an id", (Object)inferredData.getPropertyName());
                HashMap localGenerators = (HashMap)classGenerators.clone();
                localGenerators.putAll(AnnotationBinder.buildLocalGenerators((XAnnotatedElement)property, mappings));
                boolean isComponent = returnedClass.isAnnotationPresent(Embeddable.class) || property.isAnnotationPresent(EmbeddedId.class);
                AccessType propertyAccessor = entityBinder.getPropertyAccessor((XAnnotatedElement)returnedClass);
                GeneratedValue generatedValue = (GeneratedValue)property.getAnnotation(GeneratedValue.class);
                String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy()) : "assigned";
                String string2 = string = generatedValue != null ? generatedValue.generator() : "";
                if (isComponent) {
                    generatorType = "assigned";
                }
                AnnotationBinder.bindId(generatorType, string, inferredData, columns, propertyHolder, localGenerators, isComponent, propertyAccessor, entityBinder, false, isIdentifierMapper, mappings, inheritanceStatePerClass);
                log.debug("Bind {} on {}", (Object)(isComponent ? "@EmbeddedId" : "@Id"), (Object)inferredData.getPropertyName());
            } else if (property.isAnnotationPresent(Version.class)) {
                if (isIdentifierMapper) {
                    throw new AnnotationException("@IdClass class should not have @Version property");
                }
                if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
                    throw new AnnotationException("Unable to define/override @Version on a subclass: " + propertyHolder.getEntityName());
                }
                if (!propertyHolder.isEntity()) {
                    throw new AnnotationException("Unable to define @Version on an embedded class: " + propertyHolder.getEntityName());
                }
                log.debug("{} is a version property", (Object)inferredData.getPropertyName());
                RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
                PropertyBinder propBinder = new PropertyBinder();
                propBinder.setName(inferredData.getPropertyName());
                propBinder.setReturnedClassName(inferredData.getTypeName());
                propBinder.setLazy(false);
                propBinder.setAccessType(inferredData.getDefaultAccess());
                propBinder.setColumns(columns);
                propBinder.setHolder(propertyHolder);
                propBinder.setProperty(property);
                propBinder.setReturnedClass(inferredData.getPropertyClass());
                propBinder.setMappings(mappings);
                propBinder.setDeclaringClass(inferredData.getDeclaringClass());
                Property prop = propBinder.bind();
                propBinder.getSimpleValueBinder().setVersion(true);
                rootClass.setVersion(prop);
                org.hibernate.mapping.MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, mappings);
                if (superclass != null) {
                    superclass.setDeclaredVersion(prop);
                } else {
                    rootClass.setDeclaredVersion(prop);
                }
                SimpleValue simpleValue = (SimpleValue)prop.getValue();
                simpleValue.setNullValue("undefined");
                rootClass.setOptimisticLockMode(0);
                log.debug("Version name: {}, unsavedValue: {}", (Object)rootClass.getVersion().getName(), (Object)((SimpleValue)rootClass.getVersion().getValue()).getNullValue());
            } else if (property.isAnnotationPresent(javax.persistence.ManyToOne.class)) {
                javax.persistence.ManyToOne ann3 = (javax.persistence.ManyToOne)property.getAnnotation(javax.persistence.ManyToOne.class);
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                    throw new AnnotationException("@Column(s) not allowed on a @ManyToOne property: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName()));
                }
                Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
                NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
                boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
                boolean bl = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                JoinTable assocTable = propertyHolder.getJoinTable(property);
                if (assocTable != null) {
                    Join join = propertyHolder.addJoin(assocTable, false);
                    for (Ejb3JoinColumn joinColumn : joinColumns) {
                        joinColumn.setSecondaryTableName(join.getTable().getName());
                    }
                }
                AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann3.cascade(), hibernateCascade, false), joinColumns, ann3.optional(), ignoreNotFound, bl, mappings.getReflectionManager().toXClass(ann3.targetEntity()), propertyHolder, inferredData, false, isIdentifierMapper, inSecondPass, mappings);
            } else if (property.isAnnotationPresent(OneToOne.class)) {
                OneToOne ann4 = (OneToOne)property.getAnnotation(OneToOne.class);
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                    throw new AnnotationException("@Column(s) not allowed on a @OneToOne property: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName()));
                }
                boolean trueOneToOne = property.isAnnotationPresent(PrimaryKeyJoinColumn.class) || property.isAnnotationPresent(PrimaryKeyJoinColumns.class);
                Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
                NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
                boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                OnDelete onDelete = (OnDelete)property.getAnnotation(OnDelete.class);
                boolean onDeleteCascade = onDelete != null && OnDeleteAction.CASCADE.equals((Object)onDelete.action());
                JoinTable assocTable = propertyHolder.getJoinTable(property);
                if (assocTable != null) {
                    Join join = propertyHolder.addJoin(assocTable, false);
                    for (Ejb3JoinColumn joinColumn : joinColumns) {
                        joinColumn.setSecondaryTableName(join.getTable().getName());
                    }
                }
                AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann4.cascade(), hibernateCascade, false), joinColumns, ann4.optional(), AnnotationBinder.getFetchMode(ann4.fetch()), ignoreNotFound, onDeleteCascade, mappings.getReflectionManager().toXClass(ann4.targetEntity()), propertyHolder, inferredData, ann4.mappedBy(), trueOneToOne, isIdentifierMapper, inSecondPass, mappings);
            } else if (property.isAnnotationPresent(Any.class)) {
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Columns.class)) {
                    throw new AnnotationException("@Column(s) not allowed on a @Any property: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName()));
                }
                Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
                OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
                boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                JoinTable assocTable = propertyHolder.getJoinTable(property);
                if (assocTable != null) {
                    Join join = propertyHolder.addJoin(assocTable, false);
                    for (Ejb3JoinColumn joinColumn : joinColumns) {
                        joinColumn.setSecondaryTableName(join.getTable().getName());
                    }
                }
                AnnotationBinder.bindAny(AnnotationBinder.getCascadeStrategy(null, hibernateCascade, false), joinColumns, onDeleteCascade, nullability, propertyHolder, inferredData, entityBinder, isIdentifierMapper, mappings);
            } else if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(CollectionOfElements.class) || property.isAnnotationPresent(ElementCollection.class) || property.isAnnotationPresent(ManyToAny.class)) {
                Ejb3Column[] elementColumns;
                PropertyData virtualProperty;
                OneToMany oneToManyAnn = (OneToMany)property.getAnnotation(OneToMany.class);
                ManyToMany manyToManyAnn = (ManyToMany)property.getAnnotation(ManyToMany.class);
                ElementCollection elementCollectionAnn = (ElementCollection)property.getAnnotation(ElementCollection.class);
                CollectionOfElements collectionOfElementsAnn = (CollectionOfElements)property.getAnnotation(CollectionOfElements.class);
                IndexColumn indexColumn = property.isAnnotationPresent(OrderColumn.class) ? IndexColumn.buildColumnFromAnnotation((OrderColumn)property.getAnnotation(OrderColumn.class), propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings) : IndexColumn.buildColumnFromAnnotation((org.hibernate.annotations.IndexColumn)property.getAnnotation(org.hibernate.annotations.IndexColumn.class), propertyHolder, inferredData, mappings);
                CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(propertyHolder.getEntityName(), property, !indexColumn.isImplicit(), property.isAnnotationPresent(CollectionOfElements.class) || property.isAnnotationPresent(MapKey.class));
                collectionBinder.setIndexColumn(indexColumn);
                javax.persistence.MapKey mapKeyAnn = (javax.persistence.MapKey)property.getAnnotation(javax.persistence.MapKey.class);
                collectionBinder.setMapKey(mapKeyAnn);
                collectionBinder.setPropertyName(inferredData.getPropertyName());
                BatchSize batchAnn = (BatchSize)property.getAnnotation(BatchSize.class);
                collectionBinder.setBatchSize(batchAnn);
                OrderBy ejb3OrderByAnn = (OrderBy)property.getAnnotation(OrderBy.class);
                org.hibernate.annotations.OrderBy orderByAnn = (org.hibernate.annotations.OrderBy)property.getAnnotation(org.hibernate.annotations.OrderBy.class);
                collectionBinder.setEjb3OrderBy(ejb3OrderByAnn);
                collectionBinder.setSqlOrderBy(orderByAnn);
                Sort sortAnn = (Sort)property.getAnnotation(Sort.class);
                collectionBinder.setSort(sortAnn);
                Cache cachAnn = (Cache)property.getAnnotation(Cache.class);
                collectionBinder.setCache(cachAnn);
                collectionBinder.setPropertyHolder(propertyHolder);
                Cascade hibernateCascade = (Cascade)property.getAnnotation(Cascade.class);
                NotFound notFound = (NotFound)property.getAnnotation(NotFound.class);
                boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
                collectionBinder.setIgnoreNotFound(ignoreNotFound);
                collectionBinder.setCollectionType(inferredData.getProperty().getElementClass());
                collectionBinder.setMappings(mappings);
                collectionBinder.setAccessType(inferredData.getDefaultAccess());
                boolean isJPA2ForValueMapping = property.isAnnotationPresent(ElementCollection.class);
                PropertyData propertyData = virtualProperty = isJPA2ForValueMapping ? inferredData : new WrappedInferredData(inferredData, "element");
                if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
                    javax.persistence.Column ann5 = (javax.persistence.Column)property.getAnnotation(javax.persistence.Column.class);
                    Formula formulaAnn = (Formula)property.getAnnotation(Formula.class);
                    elementColumns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann5}, formulaAnn, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                } else if (property.isAnnotationPresent(Columns.class)) {
                    Columns anns2 = (Columns)property.getAnnotation(Columns.class);
                    elementColumns = Ejb3Column.buildColumnFromAnnotation(anns2.columns(), null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                } else {
                    elementColumns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, virtualProperty, entityBinder.getSecondaryTables(), mappings);
                }
                javax.persistence.Column[] keyColumns = null;
                Boolean isJPA2 = null;
                if (property.isAnnotationPresent(MapKeyColumn.class)) {
                    isJPA2 = Boolean.TRUE;
                    keyColumns = new javax.persistence.Column[]{new MapKeyColumnDelegator((MapKeyColumn)property.getAnnotation(MapKeyColumn.class))};
                } else if (property.isAnnotationPresent(MapKey.class)) {
                    if (isJPA2 == null) {
                        isJPA2 = Boolean.FALSE;
                    }
                    keyColumns = ((MapKey)property.getAnnotation(MapKey.class)).columns();
                }
                if (isJPA2 == null) {
                    isJPA2 = Boolean.TRUE;
                }
                keyColumns = keyColumns != null && keyColumns.length > 0 ? keyColumns : null;
                WrappedInferredData mapKeyVirtualProperty = new WrappedInferredData(inferredData, "mapkey");
                Ejb3Column[] mapColumns = Ejb3Column.buildColumnFromAnnotation(keyColumns, null, Nullability.FORCED_NOT_NULL, propertyHolder, isJPA2 != false ? inferredData : mapKeyVirtualProperty, isJPA2 != false ? "_KEY" : null, entityBinder.getSecondaryTables(), mappings);
                collectionBinder.setMapKeyColumns(mapColumns);
                JoinColumn[] joinKeyColumns = null;
                isJPA2 = null;
                if (property.isAnnotationPresent(MapKeyJoinColumns.class)) {
                    isJPA2 = Boolean.TRUE;
                    MapKeyJoinColumn[] mapKeyJoinColumns = ((MapKeyJoinColumns)property.getAnnotation(MapKeyJoinColumns.class)).value();
                    joinKeyColumns = new JoinColumn[mapKeyJoinColumns.length];
                    int index = 0;
                    for (MapKeyJoinColumn joinColumn : mapKeyJoinColumns) {
                        joinKeyColumns[index] = new MapKeyJoinColumnDelegator(joinColumn);
                        ++index;
                    }
                    if (joinKeyColumns != null) {
                        throw new AnnotationException("@MapKeyJoinColumn and @MapKeyJoinColumns used on the same property: " + StringHelper.qualify((String)propertyHolder.getClassName(), (String)property.getName()));
                    }
                } else if (property.isAnnotationPresent(MapKeyJoinColumn.class)) {
                    isJPA2 = Boolean.TRUE;
                    joinKeyColumns = new JoinColumn[]{new MapKeyJoinColumnDelegator((MapKeyJoinColumn)property.getAnnotation(MapKeyJoinColumn.class))};
                } else if (property.isAnnotationPresent(MapKeyManyToMany.class)) {
                    if (isJPA2 == null) {
                        isJPA2 = Boolean.FALSE;
                    }
                    joinKeyColumns = ((MapKeyManyToMany)property.getAnnotation(MapKeyManyToMany.class)).joinColumns();
                }
                if (isJPA2 == null) {
                    isJPA2 = Boolean.TRUE;
                }
                mapKeyVirtualProperty = new WrappedInferredData(inferredData, "mapkey");
                Ejb3JoinColumn[] mapJoinColumns = Ejb3JoinColumn.buildJoinColumnsWithDefaultColumnSuffix(joinKeyColumns, null, entityBinder.getSecondaryTables(), propertyHolder, isJPA2 != false ? inferredData.getPropertyName() : mapKeyVirtualProperty.getPropertyName(), isJPA2 != false ? "_KEY" : null, mappings);
                collectionBinder.setMapKeyManyToManyColumns(mapJoinColumns);
                collectionBinder.setEmbedded(property.isAnnotationPresent(Embedded.class));
                collectionBinder.setElementColumns(elementColumns);
                collectionBinder.setProperty(property);
                if (oneToManyAnn != null && manyToManyAnn != null) {
                    throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
                }
                String mappedBy = null;
                if (oneToManyAnn != null) {
                    for (Ejb3JoinColumn column : joinColumns) {
                        if (!column.isSecondary()) continue;
                        throw new NotYetImplementedException("Collections having FK in secondary table");
                    }
                    collectionBinder.setFkJoinColumns(joinColumns);
                    mappedBy = oneToManyAnn.mappedBy();
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(oneToManyAnn.targetEntity()));
                    collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade, oneToManyAnn.orphanRemoval()));
                    collectionBinder.setOneToMany(true);
                } else if (elementCollectionAnn != null || collectionOfElementsAnn != null) {
                    for (Ejb3JoinColumn column : joinColumns) {
                        if (!column.isSecondary()) continue;
                        throw new NotYetImplementedException("Collections having FK in secondary table");
                    }
                    collectionBinder.setFkJoinColumns(joinColumns);
                    mappedBy = "";
                    Class targetElement = elementCollectionAnn != null ? elementCollectionAnn.targetClass() : collectionOfElementsAnn.targetElement();
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(targetElement));
                    collectionBinder.setOneToMany(true);
                } else if (manyToManyAnn != null) {
                    mappedBy = manyToManyAnn.mappedBy();
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(manyToManyAnn.targetEntity()));
                    collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade, false));
                    collectionBinder.setOneToMany(false);
                } else if (property.isAnnotationPresent(ManyToAny.class)) {
                    mappedBy = "";
                    collectionBinder.setTargetEntity(mappings.getReflectionManager().toXClass(Void.TYPE));
                    collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(null, hibernateCascade, false));
                    collectionBinder.setOneToMany(false);
                }
                collectionBinder.setMappedBy(mappedBy);
                AnnotationBinder.bindJoinedTableAssociation(property, mappings, entityBinder, collectionBinder, propertyHolder, inferredData, mappedBy);
                OnDelete onDeleteAnn = (OnDelete)property.getAnnotation(OnDelete.class);
                boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
                collectionBinder.setCascadeDeleteEnabled(onDeleteCascade);
                if (isIdentifierMapper) {
                    collectionBinder.setInsertable(false);
                    collectionBinder.setUpdatable(false);
                }
                if (property.isAnnotationPresent(CollectionId.class)) {
                    HashMap localGenerators = (HashMap)classGenerators.clone();
                    localGenerators.putAll(AnnotationBinder.buildLocalGenerators((XAnnotatedElement)property, mappings));
                    collectionBinder.setLocalGenerators(localGenerators);
                }
                collectionBinder.setInheritanceStatePerClass(inheritanceStatePerClass);
                collectionBinder.setDeclaringClass(inferredData.getDeclaringClass());
                collectionBinder.bind();
            } else {
                boolean isComponent;
                Embeddable embeddableAnn = (Embeddable)returnedClass.getAnnotation(Embeddable.class);
                Embedded embeddedAnn = (Embedded)property.getAnnotation(Embedded.class);
                boolean bl = isComponent = embeddedAnn != null || embeddableAnn != null;
                if (isComponent) {
                    AccessType propertyAccessor = entityBinder.getPropertyAccessor((XAnnotatedElement)property);
                    AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAccessor, entityBinder, isIdentifierMapper, mappings, isComponentEmbedded, inheritanceStatePerClass);
                } else {
                    boolean optional = true;
                    boolean lazy = false;
                    if (property.isAnnotationPresent(Basic.class)) {
                        Basic basic = (Basic)property.getAnnotation(Basic.class);
                        optional = basic.optional();
                        boolean bl2 = lazy = basic.fetch() == FetchType.LAZY;
                    }
                    if (!optional && nullability != Nullability.FORCED_NULL) {
                        for (Ejb3Column col : columns) {
                            col.forceNotNull();
                        }
                    }
                    PropertyBinder propertyBinder = new PropertyBinder();
                    propertyBinder.setName(inferredData.getPropertyName());
                    propertyBinder.setReturnedClassName(inferredData.getTypeName());
                    propertyBinder.setLazy(lazy);
                    propertyBinder.setAccessType(inferredData.getDefaultAccess());
                    propertyBinder.setColumns(columns);
                    propertyBinder.setHolder(propertyHolder);
                    propertyBinder.setProperty(property);
                    propertyBinder.setReturnedClass(inferredData.getPropertyClass());
                    propertyBinder.setMappings(mappings);
                    if (isIdentifierMapper) {
                        propertyBinder.setInsertable(false);
                        propertyBinder.setUpdatable(false);
                    }
                    propertyBinder.setDeclaringClass(inferredData.getDeclaringClass());
                    propertyBinder.bind();
                }
            }
            Index index = (Index)property.getAnnotation(Index.class);
            if (index != null) {
                if (joinColumns != null) {
                    for (Ejb3JoinColumn column : joinColumns) {
                        column.addIndex(index, inSecondPass);
                    }
                } else if (columns != null) {
                    for (Ejb3Column column : columns) {
                        column.addIndex(index, inSecondPass);
                    }
                }
            }
            if ((naturalIdAnn = (NaturalId)property.getAnnotation(NaturalId.class)) == null) break block96;
            if (joinColumns != null) {
                for (Ejb3JoinColumn ejb3JoinColumn : joinColumns) {
                    ejb3JoinColumn.addUniqueKey("_UniqueKey", inSecondPass);
                }
            } else {
                for (Ejb3Column ejb3Column : columns) {
                    ejb3Column.addUniqueKey("_UniqueKey", inSecondPass);
                }
            }
        }
    }

    private static void bindJoinedTableAssociation(XProperty property, ExtendedMappings mappings, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        TableBinder associationTableBinder = new TableBinder();
        JoinTable assocTable = propertyHolder.getJoinTable(property);
        CollectionTable collectionTable = (CollectionTable)property.getAnnotation(CollectionTable.class);
        if (assocTable != null || collectionTable != null) {
            JoinColumn[] inverseJoins;
            JoinColumn[] joins;
            UniqueConstraint[] uniqueConstraints;
            String tableName;
            String schema;
            String catalog;
            if (collectionTable != null) {
                catalog = collectionTable.catalog();
                schema = collectionTable.schema();
                tableName = collectionTable.name();
                uniqueConstraints = collectionTable.uniqueConstraints();
                joins = collectionTable.joinColumns();
                inverseJoins = null;
            } else {
                catalog = assocTable.catalog();
                schema = assocTable.schema();
                tableName = assocTable.name();
                uniqueConstraints = assocTable.uniqueConstraints();
                joins = assocTable.joinColumns();
                inverseJoins = assocTable.inverseJoinColumns();
            }
            collectionBinder.setExplicitAssociationTable(true);
            if (!BinderHelper.isDefault(schema)) {
                associationTableBinder.setSchema(schema);
            }
            if (!BinderHelper.isDefault(catalog)) {
                associationTableBinder.setCatalog(catalog);
            }
            if (!BinderHelper.isDefault(tableName)) {
                associationTableBinder.setName(tableName);
            }
            associationTableBinder.setUniqueConstraints(uniqueConstraints);
            annJoins = joins.length == 0 ? null : joins;
            annInverseJoins = inverseJoins == null || inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        associationTableBinder.setMappings(mappings);
        collectionBinder.setTableBinder(associationTableBinder);
        collectionBinder.setJoinColumns(joinColumns);
        collectionBinder.setInverseJoinColumns(inverseJoinColumns);
    }

    private static void bindComponent(PropertyData inferredData, PropertyHolder propertyHolder, AccessType propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, ExtendedMappings mappings, boolean isComponentEmbedded, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccessor, true, entityBinder, isComponentEmbedded, isIdentifierMapper, false, mappings, inheritanceStatePerClass);
        XProperty property = inferredData.getProperty();
        AnnotationBinder.setupComponentTuplizer(property, comp);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue((Value)comp);
        binder.setProperty(inferredData.getProperty());
        binder.setAccessType(inferredData.getDefaultAccess());
        Property prop = binder.make();
        propertyHolder.addProperty(prop, inferredData.getDeclaringClass());
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        return AnnotationBinder.fillComponent(propertyHolder, inferredData, null, propertyAccessor, isNullable, entityBinder, isComponentEmbedded, isIdentifierMapper, inSecondPass, mappings, inheritanceStatePerClass);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, PropertyData baseInferredData, AccessType propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        PropertyContainer propContainer;
        Component comp = new Component(propertyHolder.getPersistentClass());
        comp.setEmbedded(isComponentEmbedded);
        comp.setTable(propertyHolder.getTable());
        if (!isIdentifierMapper) {
            comp.setComponentClassName(inferredData.getClassOrElementName());
        } else {
            comp.setComponentClassName(comp.getOwner().getClassName());
        }
        comp.setNodeName(inferredData.getPropertyName());
        String subpath = StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName());
        log.debug("Binding component with path: {}", (Object)subpath);
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, inferredData, propertyHolder, mappings);
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        XClass returnedClassOrElement = inferredData.getClassOrElement();
        ArrayList<PropertyData> baseClassElements = null;
        if (baseInferredData != null) {
            baseClassElements = new ArrayList<PropertyData>();
            XClass baseReturnedClassOrElement = baseInferredData.getClassOrElement();
            AnnotationBinder.bindTypeDefs((XAnnotatedElement)baseReturnedClassOrElement, mappings);
            propContainer = new PropertyContainer(baseReturnedClassOrElement);
            AnnotationBinder.addElementsOfClass(baseClassElements, propertyAccessor, propContainer, mappings);
        }
        AnnotationBinder.bindTypeDefs((XAnnotatedElement)returnedClassOrElement, mappings);
        propContainer = new PropertyContainer(returnedClassOrElement);
        AnnotationBinder.addElementsOfClass(classElements, propertyAccessor, propContainer, mappings);
        for (XClass superClass = inferredData.getPropertyClass().getSuperclass(); superClass != null && superClass.isAnnotationPresent(MappedSuperclass.class); superClass = superClass.getSuperclass()) {
            propContainer = new PropertyContainer(superClass);
            AnnotationBinder.addElementsOfClass(classElements, propertyAccessor, propContainer, mappings);
        }
        if (baseClassElements != null && !AnnotationBinder.hasIdClassAnnotations(inferredData.getPropertyClass())) {
            for (int i = 0; i < classElements.size(); ++i) {
                classElements.set(i, (PropertyData)baseClassElements.get(i));
            }
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            AnnotationBinder.processElementAnnotations(subHolder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement.getProperty(), propertyAnnotatedElement, new HashMap<String, IdGenerator>(), entityBinder, isIdentifierMapper, isComponentEmbedded, inSecondPass, mappings, inheritanceStatePerClass);
        }
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, PropertyData inferredData, Ejb3Column[] columns, PropertyHolder propertyHolder, Map<String, IdGenerator> localGenerators, boolean isComposite, AccessType propertyAccessor, EntityBinder entityBinder, boolean isEmbedded, boolean isIdentifierMapper, ExtendedMappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        AnnotationBinder.bindId(generatorType, generatorName, inferredData, null, columns, propertyHolder, localGenerators, isComposite, propertyAccessor, entityBinder, isEmbedded, isIdentifierMapper, mappings, inheritanceStatePerClass);
    }

    private static void bindId(String generatorType, String generatorName, PropertyData inferredData, PropertyData baseInferredData, Ejb3Column[] columns, PropertyHolder propertyHolder, Map<String, IdGenerator> localGenerators, boolean isComposite, AccessType propertyAccessor, EntityBinder entityBinder, boolean isEmbedded, boolean isIdentifierMapper, ExtendedMappings mappings, Map<XClass, InheritanceState> inheritanceStatePerClass) {
        Component id;
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Unable to define/override @Id(s) on a subclass: " + propertyHolder.getEntityName());
        }
        RootClass rootClass = (RootClass)persistentClass;
        String persistentClassName = rootClass.getClassName();
        if (isComposite) {
            Component componentId = id = AnnotationBinder.fillComponent(propertyHolder, inferredData, baseInferredData, propertyAccessor, false, entityBinder, isEmbedded, isIdentifierMapper, false, mappings, inheritanceStatePerClass);
            componentId.setKey(true);
            if (rootClass.getIdentifier() != null) {
                throw new AnnotationException(componentId.getComponentClassName() + " must not have @Id properties when used as an @EmbeddedId");
            }
            if (componentId.getPropertySpan() == 0) {
                throw new AnnotationException(componentId.getComponentClassName() + " has no persistent id property");
            }
            XProperty property = inferredData.getProperty();
            AnnotationBinder.setupComponentTuplizer(property, componentId);
        } else {
            for (Ejb3Column column : columns) {
                column.forceNotNull();
            }
            SimpleValueBinder value = new SimpleValueBinder();
            value.setPropertyName(inferredData.getPropertyName());
            value.setReturnedClassName(inferredData.getTypeName());
            value.setColumns(columns);
            value.setPersistentClassName(persistentClassName);
            value.setMappings(mappings);
            value.setType(inferredData.getProperty(), inferredData.getClassOrElement());
            id = value.make();
        }
        rootClass.setIdentifier((KeyValue)id);
        BinderHelper.makeIdGenerator((SimpleValue)id, generatorType, generatorName, mappings, localGenerators);
        if (isEmbedded) {
            rootClass.setEmbeddedIdentifier(inferredData.getPropertyClass() == null);
        } else {
            PropertyBinder binder = new PropertyBinder();
            binder.setName(inferredData.getPropertyName());
            binder.setValue((Value)id);
            binder.setAccessType(inferredData.getDefaultAccess());
            binder.setProperty(inferredData.getProperty());
            Property prop = binder.make();
            rootClass.setIdentifierProperty(prop);
            org.hibernate.mapping.MappedSuperclass superclass = BinderHelper.getMappedSuperclassOrNull(inferredData.getDeclaringClass(), inheritanceStatePerClass, mappings);
            if (superclass != null) {
                superclass.setDeclaredIdentifierProperty(prop);
            } else {
                rootClass.setDeclaredIdentifierProperty(prop);
            }
        }
    }

    private static void setupComponentTuplizer(XProperty property, Component component) {
        if (property == null) {
            return;
        }
        if (property.isAnnotationPresent(Tuplizers.class)) {
            for (Tuplizer tuplizer : ((Tuplizers)property.getAnnotation(Tuplizers.class)).value()) {
                EntityMode mode = EntityMode.parse((String)tuplizer.entityMode());
                component.addTuplizer(mode, tuplizer.impl().getName());
            }
        }
        if (property.isAnnotationPresent(Tuplizer.class)) {
            Tuplizer tuplizer = (Tuplizer)property.getAnnotation(Tuplizer.class);
            EntityMode mode = EntityMode.parse((String)tuplizer.entityMode());
            component.addTuplizer(mode, tuplizer.impl().getName());
        }
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, boolean ignoreNotFound, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, boolean unique, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings) {
        String fkName;
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity, mappings)) {
            value.setReferencedEntityName(inferredData.getClassOrElementName());
        } else {
            value.setReferencedEntityName(targetEntity.getName());
        }
        AnnotationBinder.defineFetchingStrategy((ToOne)value, inferredData.getProperty());
        value.setIgnoreNotFound(ignoreNotFound);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        value.setTypeName(inferredData.getClassOrElementName());
        String propertyName = inferredData.getPropertyName();
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        ForeignKey fk = (ForeignKey)inferredData.getProperty().getAnnotation(ForeignKey.class);
        String string = fkName = fk != null ? fk.name() : "";
        if (!BinderHelper.isDefault(fkName)) {
            value.setForeignKeyName(fkName);
        }
        String path = propertyHolder.getPath() + "." + propertyName;
        ToOneFkSecondPass secondPass = new ToOneFkSecondPass((ToOne)value, columns, !optional && unique, propertyHolder.getEntityOwnerClassName(), path, mappings);
        if (inSecondPass) {
            secondPass.doSecondPass(mappings.getClasses());
        } else {
            mappings.addSecondPass(secondPass);
        }
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue((Value)value);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setUpdatable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        binder.setProperty(inferredData.getProperty());
        Property prop = binder.make();
        propertyHolder.addProperty(prop, columns, inferredData.getDeclaringClass());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static void defineFetchingStrategy(ToOne toOne, XProperty property) {
        FetchType fetchType;
        LazyToOne lazy = (LazyToOne)property.getAnnotation(LazyToOne.class);
        Fetch fetch = (Fetch)property.getAnnotation(Fetch.class);
        javax.persistence.ManyToOne manyToOne = (javax.persistence.ManyToOne)property.getAnnotation(javax.persistence.ManyToOne.class);
        OneToOne oneToOne = (OneToOne)property.getAnnotation(OneToOne.class);
        if (manyToOne != null) {
            fetchType = manyToOne.fetch();
        } else {
            if (oneToOne == null) throw new AssertionFailure("Define fetch strategy on a property not annotated with @OneToMany nor @OneToOne");
            fetchType = oneToOne.fetch();
        }
        if (lazy != null) {
            toOne.setLazy(lazy.value() != LazyToOneOption.FALSE);
            toOne.setUnwrapProxy(lazy.value() == LazyToOneOption.NO_PROXY);
        } else {
            toOne.setLazy(fetchType == FetchType.LAZY);
            toOne.setUnwrapProxy(false);
        }
        if (fetch == null) {
            toOne.setFetchMode(AnnotationBinder.getFetchMode(fetchType));
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.JOIN) {
            toOne.setFetchMode(FetchMode.JOIN);
            toOne.setLazy(false);
            toOne.setUnwrapProxy(false);
            return;
        }
        if (fetch.value() == org.hibernate.annotations.FetchMode.SELECT) {
            toOne.setFetchMode(FetchMode.SELECT);
            return;
        }
        if (fetch.value() != org.hibernate.annotations.FetchMode.SUBSELECT) throw new AssertionFailure("Unknown FetchMode: " + (Object)((Object)fetch.value()));
        throw new AnnotationException("Use of FetchMode.SUBSELECT not allowed on ToOne associations");
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] joinColumns, boolean optional, FetchMode fetchMode, boolean ignoreNotFound, boolean cascadeOnDelete, XClass targetEntity, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, boolean inSecondPass, ExtendedMappings mappings) {
        String propertyName = inferredData.getPropertyName();
        log.debug("Fetching {} with {}", (Object)propertyName, (Object)fetchMode);
        boolean mapToPK = true;
        if (!trueOneToOne) {
            KeyValue identifier = propertyHolder.getIdentifier();
            if (identifier == null) {
                mapToPK = false;
            } else {
                Iterator idColumns = identifier.getColumnIterator();
                ArrayList<String> idColumnNames = new ArrayList<String>();
                while (idColumns.hasNext()) {
                    Column currentColumn = (Column)idColumns.next();
                    idColumnNames.add(currentColumn.getName());
                }
                for (Ejb3JoinColumn col : joinColumns) {
                    if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                    mapToPK = false;
                    break;
                }
            }
        }
        if (trueOneToOne || mapToPK || !BinderHelper.isDefault(mappedBy)) {
            OneToOneSecondPass secondPass = new OneToOneSecondPass(mappedBy, propertyHolder.getEntityName(), propertyName, propertyHolder, inferredData, targetEntity, ignoreNotFound, cascadeOnDelete, optional, cascadeStrategy, joinColumns, mappings);
            if (inSecondPass) {
                secondPass.doSecondPass(mappings.getClasses());
            } else {
                mappings.addSecondPass(secondPass, BinderHelper.isDefault(mappedBy));
            }
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, joinColumns, optional, ignoreNotFound, cascadeOnDelete, targetEntity, propertyHolder, inferredData, true, isIdentifierMapper, inSecondPass, mappings);
        }
    }

    private static void bindAny(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean cascadeOnDelete, Nullability nullability, PropertyHolder propertyHolder, PropertyData inferredData, EntityBinder entityBinder, boolean isIdentifierMapper, ExtendedMappings mappings) {
        Any anyAnn = (Any)inferredData.getProperty().getAnnotation(Any.class);
        if (anyAnn == null) {
            throw new AssertionFailure("Missing @Any annotation: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName()));
        }
        org.hibernate.mapping.Any value = BinderHelper.buildAnyValue(anyAnn.metaDef(), columns, anyAnn.metaColumn(), inferredData, cascadeOnDelete, nullability, propertyHolder, entityBinder, anyAnn.optional(), mappings);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue((Value)value);
        binder.setLazy(anyAnn.fetch() == FetchType.LAZY);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setUpdatable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setAccessType(inferredData.getDefaultAccess());
        binder.setCascade(cascadeStrategy);
        Property prop = binder.make();
        propertyHolder.addProperty(prop, columns, inferredData.getDeclaringClass());
    }

    private static String generatorType(GenerationType generatorEnum) {
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "seqhilo";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static EnumSet<org.hibernate.annotations.CascadeType> convertToHibernateCascadeType(CascadeType[] ejbCascades) {
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = EnumSet.noneOf(org.hibernate.annotations.CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            block8: for (CascadeType cascade : ejbCascades) {
                switch (cascade) {
                    case ALL: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.ALL);
                        continue block8;
                    }
                    case PERSIST: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.PERSIST);
                        continue block8;
                    }
                    case MERGE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.MERGE);
                        continue block8;
                    }
                    case REMOVE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REMOVE);
                        continue block8;
                    }
                    case REFRESH: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REFRESH);
                        continue block8;
                    }
                    case DETACH: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.DETACH);
                    }
                }
            }
        }
        return hibernateCascadeSet;
    }

    private static String getCascadeStrategy(CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation, boolean orphanRemoval) {
        org.hibernate.annotations.CascadeType[] hibernateCascades;
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            hibernateCascadeSet.addAll(Arrays.asList(hibernateCascades));
        }
        if (orphanRemoval) {
            hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.DELETE_ORPHAN);
            hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REMOVE);
        }
        StringBuilder cascade = new StringBuilder();
        for (org.hibernate.annotations.CascadeType aHibernateCascadeSet : hibernateCascadeSet) {
            switch (aHibernateCascadeSet) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case EVICT: 
                case DETACH: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    cascade.append(",").append("delete");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    public static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(XAnnotatedElement annElt, Mappings mappings) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = (TableGenerator)annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = (SequenceGenerator)annElt.getAnnotation(SequenceGenerator.class);
        GenericGenerator genGen = (GenericGenerator)annElt.getAnnotation(GenericGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (genGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(genGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(XClass clazz, ExtendedMappings mappings) {
        return mappings.getReflectionManager().equals(clazz, Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz);
            if (superclassState != null) {
                boolean nonDefault;
                superclassState.setHasSiblings(true);
                InheritanceState superEntityState = InheritanceState.getInheritanceStateOfSuperEntity(clazz, inheritanceStatePerClass);
                state.setHasParents(superEntityState != null);
                boolean bl = nonDefault = state.getType() != null && !InheritanceType.SINGLE_TABLE.equals((Object)state.getType());
                if (superclassState.getType() != null) {
                    boolean mixingStrategy;
                    boolean bl2 = mixingStrategy = state.getType() != null && !state.getType().equals((Object)superclassState.getType());
                    if (nonDefault && mixingStrategy) {
                        log.warn("Mixing inheritance strategy in a entity hierarchy is not allowed, ignoring sub strategy in: {}", (Object)clazz.getName());
                    }
                    state.setType(superclassState.getType());
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }

    private static boolean hasIdClassAnnotations(XClass idClass) {
        if (idClass.getAnnotation(Embeddable.class) != null) {
            return true;
        }
        List properties = idClass.getDeclaredProperties("field");
        for (XProperty property : properties) {
            if (!property.isAnnotationPresent(javax.persistence.Column.class) && !property.isAnnotationPresent(OneToMany.class) && !property.isAnnotationPresent(javax.persistence.ManyToOne.class) && !property.isAnnotationPresent(Id.class) && !property.isAnnotationPresent(GeneratedValue.class) && !property.isAnnotationPresent(OneToOne.class) && !property.isAnnotationPresent(ManyToMany.class)) continue;
            return true;
        }
        List methods = idClass.getDeclaredMethods();
        for (XMethod method : methods) {
            if (!method.isAnnotationPresent(javax.persistence.Column.class) && !method.isAnnotationPresent(OneToMany.class) && !method.isAnnotationPresent(javax.persistence.ManyToOne.class) && !method.isAnnotationPresent(Id.class) && !method.isAnnotationPresent(GeneratedValue.class) && !method.isAnnotationPresent(OneToOne.class) && !method.isAnnotationPresent(ManyToMany.class)) continue;
            return true;
        }
        return false;
    }
}

