/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.persistence.AssociationOverride;
import javax.persistence.AssociationOverrides;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.EntityResult;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.FetchType;
import javax.persistence.FieldResult;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.QueryHint;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.AnnotationException;
import org.hibernate.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotationfactory.AnnotationFactory;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.reflection.Filter;
import org.hibernate.reflection.java.JavaAnnotationReader;
import org.hibernate.reflection.java.JavaXProperty;
import org.hibernate.reflection.java.xml.XMLContext;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJB3OverridenAnnotationReader
extends JavaAnnotationReader {
    private static final Map<Class, String> annotationToXml;
    private static final String SCHEMA_VALIDATION = "Activate schema validation for more informations";
    private static final Filter FILTER;
    private XMLContext xmlContext;
    private String className;
    private String propertyName;
    private PropertyType propertyType;
    private boolean isFieldAccess;
    private transient Annotation[] annotations;
    private static final String WORD_SEPARATOR = "-";
    private transient List<Element> elementsForProperty;
    private AccessibleObject mirroredAttribute;

    public EJB3OverridenAnnotationReader(AnnotatedElement el, XMLContext xmlContext) {
        super(el);
        this.xmlContext = xmlContext;
        if (el instanceof Class) {
            Class clazz = (Class)el;
            this.className = clazz.getName();
        } else if (el instanceof Field) {
            Field field = (Field)el;
            this.className = field.getDeclaringClass().getName();
            this.propertyName = field.getName();
            this.propertyType = PropertyType.FIELD;
            String expectedGetter = "get" + Character.toUpperCase(this.propertyName.charAt(0)) + this.propertyName.substring(1);
            try {
                this.mirroredAttribute = field.getDeclaringClass().getDeclaredMethod(expectedGetter, new Class[0]);
            }
            catch (NoSuchMethodException e) {}
        } else if (el instanceof Method) {
            Method method = (Method)el;
            this.className = method.getDeclaringClass().getName();
            this.propertyName = method.getName();
            if (JavaXProperty.isProperty(method, null, FILTER)) {
                if (this.propertyName.startsWith("get")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("get".length()));
                } else if (this.propertyName.startsWith("is")) {
                    this.propertyName = Introspector.decapitalize(this.propertyName.substring("is".length()));
                } else {
                    throw new RuntimeException("Method " + this.propertyName + " is not a property getter");
                }
                this.propertyType = PropertyType.PROPERTY;
                try {
                    this.mirroredAttribute = method.getDeclaringClass().getDeclaredField(this.propertyName);
                }
                catch (NoSuchFieldException e) {}
            } else {
                this.propertyType = PropertyType.METHOD;
            }
        } else {
            this.className = null;
            this.propertyName = null;
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        this.initAnnotations();
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return (T)annotation;
        }
        return null;
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        this.initAnnotations();
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Annotation[] getAnnotations() {
        this.initAnnotations();
        return this.annotations;
    }

    private void initAnnotations() {
        if (this.annotations == null) {
            XMLContext.Default defaults = this.xmlContext.getDefault(this.className);
            if (this.className != null && this.propertyName == null) {
                Element tree = this.xmlContext.getXMLTree(this.className, null);
                Annotation[] annotations = super.getAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                Object current = this.getEntity(tree, defaults);
                if (current != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getMappedSuperclass(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getEmbeddable(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getTable(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getSecondaryTables(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getPrimaryKeyJoinColumns(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getIdClass(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getInheritance(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getDiscriminatorValue(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getDiscriminatorColumn(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getSequenceGenerator(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getTableGenerator(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getNamedQueries(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getNamedNativeQueries(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getSqlResultSetMappings(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getExcludeDefaultListeners(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getExcludeSuperclassListeners(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getAccessType(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getAttributeOverrides(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getAssociationOverrides(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                if ((current = this.getEntityListeners(tree, defaults)) != null) {
                    annotationList.add((Annotation)current);
                }
                this.annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            } else if (this.className != null && this.propertyName != null) {
                Element tree = this.xmlContext.getXMLTree(this.className, this.propertyName);
                Annotation[] annotations = super.getAnnotations();
                ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
                for (Annotation annotation : annotations) {
                    if (annotationToXml.containsKey(annotation.annotationType())) continue;
                    annotationList.add(annotation);
                }
                this.preCalculateElementsForProperty(tree);
                Transient transientAnn = this.getTransient(defaults);
                if (transientAnn != null) {
                    annotationList.add((Annotation)transientAnn);
                } else {
                    AccessType annotation;
                    if (defaults.canUseJavaAnnotations() && (annotation = super.getAnnotation(AccessType.class)) != null) {
                        annotationList.add(annotation);
                    }
                    this.getId(annotationList, defaults);
                    this.getEmbeddedId(annotationList, defaults);
                    this.getEmbedded(annotationList, defaults);
                    this.getBasic(annotationList, defaults);
                    this.getVersion(annotationList, defaults);
                    this.getAssociation(ManyToOne.class, annotationList, defaults);
                    this.getAssociation(OneToOne.class, annotationList, defaults);
                    this.getAssociation(OneToMany.class, annotationList, defaults);
                    this.getAssociation(ManyToMany.class, annotationList, defaults);
                }
                this.processEventAnnotations(annotationList, defaults);
                this.annotations = annotationList.toArray(new Annotation[annotationList.size()]);
            } else {
                this.annotations = super.getAnnotations();
            }
        }
    }

    private void processEventAnnotations(List<Annotation> annotationList, XMLContext.Default defaults) {
        boolean eventElement = false;
        for (Element element : this.elementsForProperty) {
            AnnotationDescriptor ad;
            String elementName = element.getName();
            if ("pre-persist".equals(elementName)) {
                ad = new AnnotationDescriptor(PrePersist.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                eventElement = true;
                continue;
            }
            if ("pre-remove".equals(elementName)) {
                ad = new AnnotationDescriptor(PreRemove.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                eventElement = true;
                continue;
            }
            if ("pre-update".equals(elementName)) {
                ad = new AnnotationDescriptor(PreUpdate.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                eventElement = true;
                continue;
            }
            if ("post-persist".equals(elementName)) {
                ad = new AnnotationDescriptor(PostPersist.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                eventElement = true;
                continue;
            }
            if ("post-remove".equals(elementName)) {
                ad = new AnnotationDescriptor(PostRemove.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                eventElement = true;
                continue;
            }
            if ("post-update".equals(elementName)) {
                ad = new AnnotationDescriptor(PostUpdate.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                eventElement = true;
                continue;
            }
            if (!"post-load".equals(elementName)) continue;
            ad = new AnnotationDescriptor(PostLoad.class);
            annotationList.add((Annotation)AnnotationFactory.create(ad));
            eventElement = true;
        }
        if (!eventElement && defaults.canUseJavaAnnotations()) {
            PrePersist ann = super.getAnnotation(PrePersist.class);
            if (ann != null) {
                annotationList.add((Annotation)ann);
            }
            if ((ann = super.getAnnotation(PreRemove.class)) != null) {
                annotationList.add((Annotation)ann);
            }
            if ((ann = super.getAnnotation(PreUpdate.class)) != null) {
                annotationList.add((Annotation)ann);
            }
            if ((ann = super.getAnnotation(PostPersist.class)) != null) {
                annotationList.add((Annotation)ann);
            }
            if ((ann = super.getAnnotation(PostRemove.class)) != null) {
                annotationList.add((Annotation)ann);
            }
            if ((ann = super.getAnnotation(PostUpdate.class)) != null) {
                annotationList.add((Annotation)ann);
            }
            if ((ann = super.getAnnotation(PostLoad.class)) != null) {
                annotationList.add((Annotation)ann);
            }
        }
    }

    private EntityListeners getEntityListeners(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("entity-listeners") : null;
        if (element != null) {
            ArrayList<Class> entityListenerClasses = new ArrayList<Class>();
            for (Element subelement : element.elements("entity-listener")) {
                String className = subelement.attributeValue("class");
                try {
                    entityListenerClasses.add(ReflectHelper.classForName((String)XMLContext.buildSafeClassName(className, defaults), this.getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find " + element.getPath() + ".class: " + className, e);
                }
            }
            AnnotationDescriptor ad = new AnnotationDescriptor(EntityListeners.class);
            ad.setValue("value", entityListenerClasses.toArray(new Class[entityListenerClasses.size()]));
            return (EntityListeners)AnnotationFactory.create(ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(EntityListeners.class);
        }
        return null;
    }

    private JoinTable overridesDefaultsInJoinTable(XMLContext.Default defaults) {
        Class<JoinTable> annotationType = JoinTable.class;
        if (StringHelper.isNotEmpty((String)defaults.getCatalog()) || StringHelper.isNotEmpty((String)defaults.getSchema())) {
            JoinTable table;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            if (defaults.canUseJavaAnnotations() && (table = super.getAnnotation(annotationType)) != null) {
                ad.setValue("name", table.name());
                ad.setValue("schema", table.schema());
                ad.setValue("catalog", table.catalog());
                ad.setValue("uniqueConstraints", table.uniqueConstraints());
                ad.setValue("joinColumns", table.joinColumns());
                ad.setValue("inverseJoinColumns", table.inverseJoinColumns());
            }
            if (StringHelper.isEmpty((String)((String)ad.valueOf("schema"))) && StringHelper.isNotEmpty((String)defaults.getSchema())) {
                ad.setValue("schema", defaults.getSchema());
            }
            if (StringHelper.isEmpty((String)((String)ad.valueOf("catalog"))) && StringHelper.isNotEmpty((String)defaults.getCatalog())) {
                ad.setValue("catalog", defaults.getCatalog());
            }
            return (JoinTable)AnnotationFactory.create(ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(annotationType);
        }
        return null;
    }

    private void getJoinTable(List<Annotation> annotationList, Element tree, XMLContext.Default defaults) {
        Element subelement = tree == null ? null : tree.element("join-table");
        Class<JoinTable> annotationType = JoinTable.class;
        if (subelement != null) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(annotationType);
            EJB3OverridenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
            if (StringHelper.isNotEmpty((String)defaults.getCatalog()) && StringHelper.isEmpty((String)((String)annotation.valueOf("catalog")))) {
                annotation.setValue("catalog", defaults.getCatalog());
            }
            EJB3OverridenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
            if (StringHelper.isNotEmpty((String)defaults.getSchema()) && StringHelper.isEmpty((String)((String)annotation.valueOf("schema")))) {
                annotation.setValue("schema", defaults.getSchema());
            }
            EJB3OverridenAnnotationReader.buildUniqueConstraints(annotation, subelement);
            annotation.setValue("joinColumns", this.getJoinColumns(subelement, false));
            annotation.setValue("inverseJoinColumns", this.getJoinColumns(subelement, true));
            annotationList.add((Annotation)AnnotationFactory.create(annotation));
        }
    }

    private void getAssociation(Class<? extends Annotation> annotationType, List<Annotation> annotationList, XMLContext.Default defaults) {
        String xmlName = annotationToXml.get(annotationType);
        for (Element element : this.elementsForProperty) {
            if (!xmlName.equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(annotationType);
            String className = element.attributeValue("target-entity");
            if (className != null) {
                Class clazz = null;
                try {
                    clazz = ReflectHelper.classForName((String)XMLContext.buildSafeClassName(className, defaults), this.getClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find " + element.getPath() + "target-entity: " + className, e);
                }
                ad.setValue("targetEntity", clazz);
            }
            this.getFetchType(ad, element);
            this.getCascades(ad, element, defaults);
            this.getJoinTable(annotationList, element, defaults);
            this.buildJoinColumns(annotationList, element, defaults);
            PrimaryKeyJoinColumns annotation = this.getPrimaryKeyJoinColumns(element, defaults);
            if (annotation != null) {
                annotationList.add((Annotation)annotation);
            }
            EJB3OverridenAnnotationReader.copyBooleanAttribute(ad, element, "optional");
            EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "mapped-by", false);
            this.getOrderBy(annotationList, element, defaults);
            this.getMapKey(annotationList, element, defaults);
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            Annotation annotation = super.getAnnotation(annotationType);
            if (annotation != null) {
                annotationList.add(annotation);
                annotation = this.overridesDefaultsInJoinTable(defaults);
                if (annotation != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(JoinColumn.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(JoinColumns.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(PrimaryKeyJoinColumns.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(MapKey.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(OrderBy.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AttributeOverride.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AttributeOverrides.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AssociationOverride.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AssociationOverrides.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Lob.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Enumerated.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Temporal.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Column.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Columns.class)) != null) {
                    annotationList.add(annotation);
                }
            } else if (super.isAnnotationPresent(CollectionOfElements.class)) {
                annotation = this.overridesDefaultsInJoinTable(defaults);
                if (annotation != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(JoinColumn.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(JoinColumns.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(PrimaryKeyJoinColumns.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(MapKey.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(OrderBy.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AttributeOverride.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AttributeOverrides.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AssociationOverride.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(AssociationOverrides.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Lob.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Enumerated.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Temporal.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Column.class)) != null) {
                    annotationList.add(annotation);
                }
                if ((annotation = super.getAnnotation(Columns.class)) != null) {
                    annotationList.add(annotation);
                }
            }
        }
    }

    private void getOrderBy(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("order-by") : null;
        if (subelement != null) {
            String orderByString = subelement.getTextTrim();
            AnnotationDescriptor ad = new AnnotationDescriptor(OrderBy.class);
            if (StringHelper.isNotEmpty((String)orderByString)) {
                ad.setValue("value", orderByString);
            }
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
    }

    private void getMapKey(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element != null ? element.element("map-key") : null;
        if (subelement != null) {
            String mapKeyString = subelement.attributeValue("name");
            AnnotationDescriptor ad = new AnnotationDescriptor(MapKey.class);
            if (StringHelper.isNotEmpty((String)mapKeyString)) {
                ad.setValue("name", mapKeyString);
            }
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
    }

    private void buildJoinColumns(List<Annotation> annotationList, Element element, XMLContext.Default defaults) {
        JoinColumn[] joinColumns = this.getJoinColumns(element, false);
        if (joinColumns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(JoinColumns.class);
            ad.setValue("value", joinColumns);
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
    }

    private void getCascades(AnnotationDescriptor ad, Element element, XMLContext.Default defaults) {
        List elements = element != null ? element.elements("cascade") : new ArrayList(0);
        ArrayList<CascadeType> cascades = new ArrayList<CascadeType>();
        for (Element subelement : elements) {
            if (subelement.element("cascade-all") != null) {
                cascades.add(CascadeType.ALL);
            }
            if (subelement.element("cascade-persist") != null) {
                cascades.add(CascadeType.PERSIST);
            }
            if (subelement.element("cascade-merge") != null) {
                cascades.add(CascadeType.MERGE);
            }
            if (subelement.element("cascade-remove") != null) {
                cascades.add(CascadeType.REMOVE);
            }
            if (subelement.element("cascade-refresh") == null) continue;
            cascades.add(CascadeType.REFRESH);
        }
        if (Boolean.TRUE.equals(defaults.getCascadePersist()) && !cascades.contains(CascadeType.ALL) && !cascades.contains(CascadeType.PERSIST)) {
            cascades.add(CascadeType.PERSIST);
        }
        if (cascades.size() > 0) {
            ad.setValue("cascade", cascades.toArray(new CascadeType[cascades.size()]));
        }
    }

    private void getEmbedded(List<Annotation> annotationList, XMLContext.Default defaults) {
        Embedded annotation;
        for (Element element : this.elementsForProperty) {
            if (!"embedded".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(Embedded.class);
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = super.getAnnotation(Embedded.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = super.getAnnotation(AttributeOverride.class);
            if (annotation != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
        }
    }

    private Transient getTransient(XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"transient".equals(element.getName())) continue;
            AnnotationDescriptor ad = new AnnotationDescriptor(Transient.class);
            return (Transient)AnnotationFactory.create(ad);
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(Transient.class);
        }
        return null;
    }

    private void getVersion(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"version".equals(element.getName())) continue;
            Columns annotation2 = this.buildColumns(element);
            if (annotation2 != null) {
                annotationList.add(annotation2);
            }
            this.getTemporal(annotationList, element);
            AnnotationDescriptor basic = new AnnotationDescriptor(Version.class);
            annotationList.add((Annotation)AnnotationFactory.create(basic));
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = super.getAnnotation(Version.class)) != null) {
            if (annotation != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Column.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Columns.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Temporal.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
        }
    }

    private void getBasic(List<Annotation> annotationList, XMLContext.Default defaults) {
        for (Element element : this.elementsForProperty) {
            if (!"basic".equals(element.getName())) continue;
            Columns annotation = this.buildColumns(element);
            if (annotation != null) {
                annotationList.add(annotation);
            }
            this.getTemporal(annotationList, element);
            this.getLob(annotationList, element);
            this.getEnumerated(annotationList, element);
            AnnotationDescriptor basic = new AnnotationDescriptor(Basic.class);
            this.getFetchType(basic, element);
            EJB3OverridenAnnotationReader.copyBooleanAttribute(basic, element, "optional");
            annotationList.add((Annotation)AnnotationFactory.create(basic));
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations()) {
            Object annotation = super.getAnnotation(Basic.class);
            if (annotation != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Lob.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Enumerated.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Temporal.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Column.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Columns.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
        }
    }

    private void getEnumerated(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("enumerated") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Enumerated.class);
            String enumerated = subElement.getTextTrim();
            if ("ORDINAL".equalsIgnoreCase(enumerated)) {
                ad.setValue("value", EnumType.ORDINAL);
            } else if ("STRING".equalsIgnoreCase(enumerated)) {
                ad.setValue("value", EnumType.STRING);
            } else if (StringHelper.isNotEmpty((String)enumerated)) {
                throw new AnnotationException("Unknown EnumType: " + enumerated + ". " + SCHEMA_VALIDATION);
            }
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
    }

    private void getLob(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("lob") : null;
        if (subElement != null) {
            annotationList.add((Annotation)AnnotationFactory.create(new AnnotationDescriptor(Lob.class)));
        }
    }

    private void getFetchType(AnnotationDescriptor descriptor, Element element) {
        String fetchString;
        String string = fetchString = element != null ? element.attributeValue("fetch") : null;
        if (fetchString != null) {
            if ("eager".equalsIgnoreCase(fetchString)) {
                descriptor.setValue("fetch", FetchType.EAGER);
            } else if ("lazy".equalsIgnoreCase(fetchString)) {
                descriptor.setValue("fetch", FetchType.LAZY);
            }
        }
    }

    private void getEmbeddedId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"embedded-id".equals(element.getName())) continue;
            boolean properAccessOnMetadataComplete = this.computeProperAccessOnMetadataComplete(defaults);
            boolean properOverridingOnMetadataNonComplete = this.computeProperOverridingOnMetadataComplete(defaults);
            if (properAccessOnMetadataComplete || properOverridingOnMetadataNonComplete) {
                AttributeOverrides annotation2 = this.getAttributeOverrides(element, defaults);
                if (annotation2 != null) {
                    annotationList.add((Annotation)annotation2);
                }
                if ((annotation2 = this.getAssociationOverrides(element, defaults)) != null) {
                    annotationList.add((Annotation)annotation2);
                }
                AnnotationDescriptor ad = new AnnotationDescriptor(EmbeddedId.class);
                annotationList.add((Annotation)AnnotationFactory.create(ad));
                continue;
            }
            if (!defaults.canUseJavaAnnotations() || properOverridingOnMetadataNonComplete || this.mirroredAttribute != null && this.mirroredAttribute.isAnnotationPresent(EmbeddedId.class)) continue;
            throw new AnnotationException("Cannot override an property with <embedded-id> not having an @EmbeddedId already");
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = super.getAnnotation(EmbeddedId.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = super.getAnnotation(Column.class);
            if (annotation != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Columns.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(GeneratedValue.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Temporal.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(TableGenerator.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(SequenceGenerator.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
        }
    }

    private void preCalculateElementsForProperty(Element tree) {
        Element element;
        this.elementsForProperty = new ArrayList<Element>();
        Element element2 = element = tree != null ? tree.element("attributes") : null;
        if (element != null) {
            for (Element subelement : element.elements()) {
                if (!this.propertyName.equals(subelement.attributeValue("name"))) continue;
                this.elementsForProperty.add(subelement);
            }
        }
        if (tree != null) {
            for (Element subelement : tree.elements()) {
                if (!this.propertyName.equals(subelement.attributeValue("method-name"))) continue;
                this.elementsForProperty.add(subelement);
            }
        }
    }

    private void getId(List<Annotation> annotationList, XMLContext.Default defaults) {
        Object annotation;
        for (Element element : this.elementsForProperty) {
            if (!"id".equals(element.getName())) continue;
            boolean properAccessOnMetadataComplete = this.computeProperAccessOnMetadataComplete(defaults);
            boolean properOverridingOnMetadataNonComplete = this.computeProperOverridingOnMetadataComplete(defaults);
            if (properAccessOnMetadataComplete || properOverridingOnMetadataNonComplete) {
                Columns annotation2 = this.buildColumns(element);
                if (annotation2 != null) {
                    annotationList.add(annotation2);
                }
                if ((annotation2 = this.buildGeneratedValue(element)) != null) {
                    annotationList.add(annotation2);
                }
                this.getTemporal(annotationList, element);
                annotation2 = this.getTableGenerator(element, defaults);
                if (annotation2 != null) {
                    annotationList.add(annotation2);
                }
                if ((annotation2 = this.getSequenceGenerator(element, defaults)) != null) {
                    annotationList.add(annotation2);
                }
                AnnotationDescriptor id = new AnnotationDescriptor(Id.class);
                annotationList.add((Annotation)AnnotationFactory.create(id));
                continue;
            }
            if (!defaults.canUseJavaAnnotations() || properOverridingOnMetadataNonComplete || this.mirroredAttribute != null && this.mirroredAttribute.isAnnotationPresent(Id.class)) continue;
            throw new AnnotationException("Cannot override an property with <id> it does not have an @Id already");
        }
        if (this.elementsForProperty.size() == 0 && defaults.canUseJavaAnnotations() && (annotation = super.getAnnotation(Id.class)) != null) {
            annotationList.add((Annotation)annotation);
            annotation = super.getAnnotation(Column.class);
            if (annotation != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Columns.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(GeneratedValue.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(Temporal.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(TableGenerator.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(SequenceGenerator.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AttributeOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverride.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
            if ((annotation = super.getAnnotation(AssociationOverrides.class)) != null) {
                annotationList.add((Annotation)annotation);
            }
        }
    }

    private boolean computeProperOverridingOnMetadataComplete(XMLContext.Default defaults) {
        return defaults.canUseJavaAnnotations() && super.isAnnotationPresent(Id.class);
    }

    private boolean computeProperAccessOnMetadataComplete(XMLContext.Default defaults) {
        return !defaults.canUseJavaAnnotations() && (!"field".equalsIgnoreCase(defaults.getAccess()) && !PropertyType.FIELD.equals((Object)this.propertyType) || "field".equalsIgnoreCase(defaults.getAccess()) && PropertyType.FIELD.equals((Object)this.propertyType));
    }

    private Columns buildColumns(Element element) {
        List subelements = element.elements("column");
        ArrayList<Column> columns = new ArrayList<Column>(subelements.size());
        for (Element subelement : subelements) {
            columns.add(this.getColumn(subelement, false));
        }
        if (columns.size() > 0) {
            AnnotationDescriptor columnsDescr = new AnnotationDescriptor(Columns.class);
            columnsDescr.setValue("columns", columns.toArray(new Column[columns.size()]));
            return (Columns)AnnotationFactory.create(columnsDescr);
        }
        return null;
    }

    private GeneratedValue buildGeneratedValue(Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("generated-value") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(GeneratedValue.class);
            String strategy = subElement.attributeValue("strategy");
            if ("TABLE".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", GenerationType.TABLE);
            } else if ("SEQUENCE".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", GenerationType.SEQUENCE);
            } else if ("IDENTITY".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", GenerationType.IDENTITY);
            } else if ("AUTO".equalsIgnoreCase(strategy)) {
                ad.setValue("strategy", GenerationType.AUTO);
            } else if (StringHelper.isNotEmpty((String)strategy)) {
                throw new AnnotationException("Unknown GenerationType: " + strategy + ". " + SCHEMA_VALIDATION);
            }
            EJB3OverridenAnnotationReader.copyStringAttribute(ad, subElement, "generator", false);
            return (GeneratedValue)AnnotationFactory.create(ad);
        }
        return null;
    }

    private void getTemporal(List<Annotation> annotationList, Element element) {
        Element subElement;
        Element element2 = subElement = element != null ? element.element("temporal") : null;
        if (subElement != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Temporal.class);
            String temporal = subElement.getTextTrim();
            if ("DATE".equalsIgnoreCase(temporal)) {
                ad.setValue("value", TemporalType.DATE);
            } else if ("TIME".equalsIgnoreCase(temporal)) {
                ad.setValue("value", TemporalType.TIME);
            } else if ("TIMESTAMP".equalsIgnoreCase(temporal)) {
                ad.setValue("value", TemporalType.TIMESTAMP);
            } else if (StringHelper.isNotEmpty((String)temporal)) {
                throw new AnnotationException("Unknown TemporalType: " + temporal + ". " + SCHEMA_VALIDATION);
            }
            annotationList.add((Annotation)AnnotationFactory.create(ad));
        }
    }

    private AssociationOverrides getAssociationOverrides(Element tree, XMLContext.Default defaults) {
        List<AssociationOverride> attributes = this.buildAssociationOverrides(tree);
        if (defaults.canUseJavaAnnotations()) {
            AssociationOverride annotation = super.getAnnotation(AssociationOverride.class);
            this.addAssociationOverrideIfNeeded(annotation, attributes);
            AssociationOverrides annotations = super.getAnnotation(AssociationOverrides.class);
            if (annotations != null) {
                for (AssociationOverride current : annotations.value()) {
                    this.addAssociationOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AssociationOverrides.class);
            ad.setValue("value", attributes.toArray(new AssociationOverride[attributes.size()]));
            return (AssociationOverrides)AnnotationFactory.create(ad);
        }
        return null;
    }

    private List<AssociationOverride> buildAssociationOverrides(Element element) {
        List subelements = element == null ? null : element.elements("association-override");
        ArrayList<AssociationOverride> overrides = new ArrayList<AssociationOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (Element current : subelements) {
                AnnotationDescriptor override = new AnnotationDescriptor(AssociationOverride.class);
                EJB3OverridenAnnotationReader.copyStringAttribute(override, current, "name", true);
                override.setValue("joinColumns", this.getJoinColumns(current, false));
                overrides.add((AssociationOverride)AnnotationFactory.create(override));
            }
        }
        return overrides;
    }

    private JoinColumn[] getJoinColumns(Element element, boolean isInverse) {
        List subelements = element != null ? element.elements(isInverse ? "inverse-join-column" : "join-column") : null;
        ArrayList<JoinColumn> joinColumns = new ArrayList<JoinColumn>();
        if (subelements != null) {
            for (Element subelement : subelements) {
                AnnotationDescriptor column = new AnnotationDescriptor(JoinColumn.class);
                EJB3OverridenAnnotationReader.copyStringAttribute(column, subelement, "name", false);
                EJB3OverridenAnnotationReader.copyStringAttribute(column, subelement, "referenced-column-name", false);
                EJB3OverridenAnnotationReader.copyBooleanAttribute(column, subelement, "unique");
                EJB3OverridenAnnotationReader.copyBooleanAttribute(column, subelement, "nullable");
                EJB3OverridenAnnotationReader.copyBooleanAttribute(column, subelement, "insertable");
                EJB3OverridenAnnotationReader.copyBooleanAttribute(column, subelement, "updatable");
                EJB3OverridenAnnotationReader.copyStringAttribute(column, subelement, "column-definition", false);
                EJB3OverridenAnnotationReader.copyStringAttribute(column, subelement, "table", false);
                joinColumns.add((JoinColumn)AnnotationFactory.create(column));
            }
        }
        return joinColumns.toArray(new JoinColumn[joinColumns.size()]);
    }

    private void addAssociationOverrideIfNeeded(AssociationOverride annotation, List<AssociationOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AssociationOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private AttributeOverrides getAttributeOverrides(Element tree, XMLContext.Default defaults) {
        List<AttributeOverride> attributes = this.buildAttributeOverrides(tree);
        if (defaults.canUseJavaAnnotations()) {
            AttributeOverride annotation = super.getAnnotation(AttributeOverride.class);
            this.addAttributeOverrideIfNeeded(annotation, attributes);
            AttributeOverrides annotations = super.getAnnotation(AttributeOverrides.class);
            if (annotations != null) {
                for (AttributeOverride current : annotations.value()) {
                    this.addAttributeOverrideIfNeeded(current, attributes);
                }
            }
        }
        if (attributes.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AttributeOverrides.class);
            ad.setValue("value", attributes.toArray(new AttributeOverride[attributes.size()]));
            return (AttributeOverrides)AnnotationFactory.create(ad);
        }
        return null;
    }

    private List<AttributeOverride> buildAttributeOverrides(Element element) {
        List subelements = element == null ? null : element.elements("attribute-override");
        ArrayList<AttributeOverride> overrides = new ArrayList<AttributeOverride>();
        if (subelements != null && subelements.size() > 0) {
            for (Element current : subelements) {
                AnnotationDescriptor override = new AnnotationDescriptor(AttributeOverride.class);
                EJB3OverridenAnnotationReader.copyStringAttribute(override, current, "name", true);
                Element column = current != null ? current.element("column") : null;
                override.setValue("column", this.getColumn(column, true));
                overrides.add((AttributeOverride)AnnotationFactory.create(override));
            }
        }
        return overrides;
    }

    private Column getColumn(Element element, boolean isMandatory) {
        if (element != null) {
            AnnotationDescriptor column = new AnnotationDescriptor(Column.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(column, element, "name", false);
            EJB3OverridenAnnotationReader.copyBooleanAttribute(column, element, "unique");
            EJB3OverridenAnnotationReader.copyBooleanAttribute(column, element, "nullable");
            EJB3OverridenAnnotationReader.copyBooleanAttribute(column, element, "insertable");
            EJB3OverridenAnnotationReader.copyBooleanAttribute(column, element, "updatable");
            EJB3OverridenAnnotationReader.copyStringAttribute(column, element, "column-definition", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(column, element, "table", false);
            EJB3OverridenAnnotationReader.copyIntegerAttribute(column, element, "length");
            EJB3OverridenAnnotationReader.copyIntegerAttribute(column, element, "precision");
            EJB3OverridenAnnotationReader.copyIntegerAttribute(column, element, "scale");
            return (Column)AnnotationFactory.create(column);
        }
        if (isMandatory) {
            throw new AnnotationException(element.getPath() + " is mandatory. " + SCHEMA_VALIDATION);
        }
        return null;
    }

    private void addAttributeOverrideIfNeeded(AttributeOverride annotation, List<AttributeOverride> overrides) {
        if (annotation != null) {
            String overrideName = annotation.name();
            boolean present = false;
            for (AttributeOverride current : overrides) {
                if (!current.name().equals(overrideName)) continue;
                present = true;
                break;
            }
            if (!present) {
                overrides.add(annotation);
            }
        }
    }

    private AccessType getAccessType(Element tree, XMLContext.Default defaults) {
        String access;
        String string = access = tree == null ? null : tree.attributeValue("access");
        if ("FIELD".equals(access) || "PROPERTY".equals(access)) {
            access = access.toLowerCase();
        }
        if (access != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AccessType.class);
            ad.setValue("value", access);
            this.isFieldAccess = "field".equalsIgnoreCase(access);
            return (AccessType)AnnotationFactory.create(ad);
        }
        if (defaults.canUseJavaAnnotations() && super.isAnnotationPresent(AccessType.class)) {
            AccessType annotation = super.getAnnotation(AccessType.class);
            this.isFieldAccess = "field".equalsIgnoreCase(annotation != null ? annotation.value() : null);
            return annotation;
        }
        if (defaults.getAccess() != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(AccessType.class);
            ad.setValue("value", defaults.getAccess());
            this.isFieldAccess = "field".equalsIgnoreCase(defaults.getAccess());
            return (AccessType)AnnotationFactory.create(ad);
        }
        this.isFieldAccess = false;
        return null;
    }

    private ExcludeSuperclassListeners getExcludeSuperclassListeners(Element tree, XMLContext.Default defaults) {
        return (ExcludeSuperclassListeners)this.getMarkerAnnotation(ExcludeSuperclassListeners.class, tree, defaults);
    }

    private ExcludeDefaultListeners getExcludeDefaultListeners(Element tree, XMLContext.Default defaults) {
        return (ExcludeDefaultListeners)this.getMarkerAnnotation(ExcludeDefaultListeners.class, tree, defaults);
    }

    private Annotation getMarkerAnnotation(Class<? extends Annotation> clazz, Element element, XMLContext.Default defaults) {
        Element subelement;
        Element element2 = subelement = element == null ? null : element.element(annotationToXml.get(clazz));
        if (subelement != null) {
            return AnnotationFactory.create(new AnnotationDescriptor(clazz));
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(clazz);
        }
        return null;
    }

    private SqlResultSetMappings getSqlResultSetMappings(Element tree, XMLContext.Default defaults) {
        List<SqlResultSetMapping> results = EJB3OverridenAnnotationReader.buildSqlResultsetMappings(tree, defaults);
        if (defaults.canUseJavaAnnotations()) {
            SqlResultSetMapping annotation = super.getAnnotation(SqlResultSetMapping.class);
            this.addSqlResultsetMappingIfNeeded(annotation, results);
            SqlResultSetMappings annotations = super.getAnnotation(SqlResultSetMappings.class);
            if (annotations != null) {
                for (SqlResultSetMapping current : annotations.value()) {
                    this.addSqlResultsetMappingIfNeeded(current, results);
                }
            }
        }
        if (results.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SqlResultSetMappings.class);
            ad.setValue("value", results.toArray(new SqlResultSetMapping[results.size()]));
            return (SqlResultSetMappings)AnnotationFactory.create(ad);
        }
        return null;
    }

    public static List<SqlResultSetMapping> buildSqlResultsetMappings(Element element, XMLContext.Default defaults) {
        if (element == null) {
            return new ArrayList<SqlResultSetMapping>();
        }
        List resultsetElementList = element.elements("sql-result-set-mapping");
        ArrayList<SqlResultSetMapping> resultsets = new ArrayList<SqlResultSetMapping>();
        ListIterator it = resultsetElementList.listIterator();
        while (it.hasNext()) {
            Element subelement = (Element)it.next();
            AnnotationDescriptor ann = new AnnotationDescriptor(SqlResultSetMapping.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(ann, subelement, "name", true);
            List elements = subelement.elements("entity-result");
            ArrayList<EntityResult> entityResults = new ArrayList<EntityResult>(elements.size());
            for (Element entityResult : elements) {
                AnnotationDescriptor entityResultDescriptor = new AnnotationDescriptor(EntityResult.class);
                String clazzName = entityResult.attributeValue("entity-class");
                if (clazzName == null) {
                    throw new AnnotationException("<entity-result> without entity-class. Activate schema validation for more informations");
                }
                Class clazz = null;
                try {
                    clazz = ReflectHelper.classForName((String)XMLContext.buildSafeClassName(clazzName, defaults), EJB3OverridenAnnotationReader.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find entity-class: " + clazzName, e);
                }
                entityResultDescriptor.setValue("entityClass", clazz);
                EJB3OverridenAnnotationReader.copyStringAttribute(entityResultDescriptor, entityResult, "discriminator-column", false);
                ArrayList<FieldResult> fieldResults = new ArrayList<FieldResult>();
                for (Element fieldResult : entityResult.elements("field-result")) {
                    AnnotationDescriptor fieldResultDescriptor = new AnnotationDescriptor(FieldResult.class);
                    EJB3OverridenAnnotationReader.copyStringAttribute(fieldResultDescriptor, fieldResult, "name", true);
                    EJB3OverridenAnnotationReader.copyStringAttribute(fieldResultDescriptor, fieldResult, "column", true);
                    fieldResults.add((FieldResult)AnnotationFactory.create(fieldResultDescriptor));
                }
                entityResultDescriptor.setValue("fields", fieldResults.toArray(new FieldResult[fieldResults.size()]));
                entityResults.add((EntityResult)AnnotationFactory.create(entityResultDescriptor));
            }
            ann.setValue("entities", entityResults.toArray(new EntityResult[entityResults.size()]));
            elements = subelement.elements("column-result");
            ArrayList<ColumnResult> columnResults = new ArrayList<ColumnResult>(elements.size());
            for (Element columnResult : elements) {
                AnnotationDescriptor columnResultDescriptor = new AnnotationDescriptor(ColumnResult.class);
                EJB3OverridenAnnotationReader.copyStringAttribute(columnResultDescriptor, columnResult, "name", true);
                columnResults.add((ColumnResult)AnnotationFactory.create(columnResultDescriptor));
            }
            ann.setValue("columns", columnResults.toArray(new ColumnResult[columnResults.size()]));
            EJB3OverridenAnnotationReader.copyStringAttribute(ann, subelement, "result-class", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(ann, subelement, "result-set-mapping", false);
            resultsets.add((SqlResultSetMapping)AnnotationFactory.create(ann));
        }
        return resultsets;
    }

    private void addSqlResultsetMappingIfNeeded(SqlResultSetMapping annotation, List<SqlResultSetMapping> resultsets) {
        if (annotation != null) {
            String resultsetName = annotation.name();
            boolean present = false;
            for (SqlResultSetMapping current : resultsets) {
                if (!current.name().equals(resultsetName)) continue;
                present = true;
                break;
            }
            if (!present) {
                resultsets.add(annotation);
            }
        }
    }

    private NamedQueries getNamedQueries(Element tree, XMLContext.Default defaults) {
        List queries = EJB3OverridenAnnotationReader.buildNamedQueries(tree, false);
        if (defaults.canUseJavaAnnotations()) {
            NamedQuery annotation = super.getAnnotation(NamedQuery.class);
            this.addNamedQueryIfNeeded(annotation, queries);
            NamedQueries annotations = super.getAnnotation(NamedQueries.class);
            if (annotations != null) {
                for (NamedQuery current : annotations.value()) {
                    this.addNamedQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedQueries.class);
            ad.setValue("value", queries.toArray(new NamedQuery[queries.size()]));
            return (NamedQueries)AnnotationFactory.create(ad);
        }
        return null;
    }

    private void addNamedQueryIfNeeded(NamedQuery annotation, List<NamedQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    private NamedNativeQueries getNamedNativeQueries(Element tree, XMLContext.Default defaults) {
        List queries = EJB3OverridenAnnotationReader.buildNamedQueries(tree, true);
        if (defaults.canUseJavaAnnotations()) {
            NamedNativeQuery annotation = super.getAnnotation(NamedNativeQuery.class);
            this.addNamedNativeQueryIfNeeded(annotation, queries);
            NamedNativeQueries annotations = super.getAnnotation(NamedNativeQueries.class);
            if (annotations != null) {
                for (NamedNativeQuery current : annotations.value()) {
                    this.addNamedNativeQueryIfNeeded(current, queries);
                }
            }
        }
        if (queries.size() > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(NamedNativeQueries.class);
            ad.setValue("value", queries.toArray(new NamedNativeQuery[queries.size()]));
            return (NamedNativeQueries)AnnotationFactory.create(ad);
        }
        return null;
    }

    private void addNamedNativeQueryIfNeeded(NamedNativeQuery annotation, List<NamedNativeQuery> queries) {
        if (annotation != null) {
            String queryName = annotation.name();
            boolean present = false;
            for (NamedNativeQuery current : queries) {
                if (!current.name().equals(queryName)) continue;
                present = true;
                break;
            }
            if (!present) {
                queries.add(annotation);
            }
        }
    }

    public static List buildNamedQueries(Element element, boolean isNative) {
        if (element == null) {
            return new ArrayList();
        }
        List namedQueryElementList = isNative ? element.elements("named-native-query") : element.elements("named-query");
        ArrayList namedQueries = new ArrayList();
        boolean index = false;
        ListIterator it = namedQueryElementList.listIterator();
        while (it.hasNext()) {
            Element subelement = (Element)it.next();
            AnnotationDescriptor ann = new AnnotationDescriptor(isNative ? NamedNativeQuery.class : NamedQuery.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(ann, subelement, "name", false);
            Element queryElt = subelement.element("query");
            if (queryElt == null) {
                throw new AnnotationException("No <query> element found.Activate schema validation for more informations");
            }
            ann.setValue("query", queryElt.getTextTrim());
            List elements = subelement.elements("hint");
            ArrayList<QueryHint> queryHints = new ArrayList<QueryHint>(elements.size());
            for (Element hint : elements) {
                AnnotationDescriptor hintDescriptor = new AnnotationDescriptor(QueryHint.class);
                String value = hint.attributeValue("name");
                if (value == null) {
                    throw new AnnotationException("<hint> without name. Activate schema validation for more informations");
                }
                hintDescriptor.setValue("name", value);
                value = hint.attributeValue("value");
                if (value == null) {
                    throw new AnnotationException("<hint> without value. Activate schema validation for more informations");
                }
                hintDescriptor.setValue("value", value);
                queryHints.add((QueryHint)AnnotationFactory.create(hintDescriptor));
            }
            ann.setValue("hints", queryHints.toArray(new QueryHint[queryHints.size()]));
            EJB3OverridenAnnotationReader.copyStringAttribute(ann, subelement, "result-class", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(ann, subelement, "result-set-mapping", false);
            namedQueries.add(AnnotationFactory.create(ann));
        }
        return namedQueries;
    }

    private TableGenerator getTableGenerator(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element(annotationToXml.get(TableGenerator.class)) : null;
        if (element != null) {
            return EJB3OverridenAnnotationReader.buildTableGeneratorAnnotation(element, defaults);
        }
        if (defaults.canUseJavaAnnotations() && super.isAnnotationPresent(TableGenerator.class)) {
            TableGenerator tableAnn = super.getAnnotation(TableGenerator.class);
            if (StringHelper.isNotEmpty((String)defaults.getSchema()) || StringHelper.isNotEmpty((String)defaults.getCatalog())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(TableGenerator.class);
                annotation.setValue("name", tableAnn.name());
                annotation.setValue("table", tableAnn.table());
                annotation.setValue("catalog", tableAnn.table());
                if (StringHelper.isEmpty((String)((String)annotation.valueOf("catalog"))) && StringHelper.isNotEmpty((String)defaults.getCatalog())) {
                    annotation.setValue("catalog", defaults.getCatalog());
                }
                annotation.setValue("schema", tableAnn.table());
                if (StringHelper.isEmpty((String)((String)annotation.valueOf("schema"))) && StringHelper.isNotEmpty((String)defaults.getSchema())) {
                    annotation.setValue("catalog", defaults.getSchema());
                }
                annotation.setValue("pkColumnName", tableAnn.pkColumnName());
                annotation.setValue("valueColumnName", tableAnn.valueColumnName());
                annotation.setValue("pkColumnValue", tableAnn.pkColumnValue());
                annotation.setValue("initialValue", tableAnn.initialValue());
                annotation.setValue("allocationSize", tableAnn.allocationSize());
                annotation.setValue("uniqueConstraints", tableAnn.uniqueConstraints());
                return (TableGenerator)AnnotationFactory.create(annotation);
            }
            return tableAnn;
        }
        return null;
    }

    public static TableGenerator buildTableGeneratorAnnotation(Element element, XMLContext.Default defaults) {
        AnnotationDescriptor ad = new AnnotationDescriptor(TableGenerator.class);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "name", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "table", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "catalog", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "schema", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "pk-column-name", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "value-column-name", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "pk-column-value", false);
        EJB3OverridenAnnotationReader.copyIntegerAttribute(ad, element, "initial-value");
        EJB3OverridenAnnotationReader.copyIntegerAttribute(ad, element, "allocation-size");
        EJB3OverridenAnnotationReader.buildUniqueConstraints(ad, element);
        if (StringHelper.isEmpty((String)((String)ad.valueOf("schema"))) && StringHelper.isNotEmpty((String)defaults.getSchema())) {
            ad.setValue("schema", defaults.getSchema());
        }
        if (StringHelper.isEmpty((String)((String)ad.valueOf("catalog"))) && StringHelper.isNotEmpty((String)defaults.getCatalog())) {
            ad.setValue("catalog", defaults.getCatalog());
        }
        return (TableGenerator)AnnotationFactory.create(ad);
    }

    private SequenceGenerator getSequenceGenerator(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element(annotationToXml.get(SequenceGenerator.class)) : null;
        if (element != null) {
            return EJB3OverridenAnnotationReader.buildSequenceGeneratorAnnotation(element);
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(SequenceGenerator.class);
        }
        return null;
    }

    public static SequenceGenerator buildSequenceGeneratorAnnotation(Element element) {
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(SequenceGenerator.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "name", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "sequence-name", false);
            EJB3OverridenAnnotationReader.copyIntegerAttribute(ad, element, "initial-value");
            EJB3OverridenAnnotationReader.copyIntegerAttribute(ad, element, "allocation-size");
            return (SequenceGenerator)AnnotationFactory.create(ad);
        }
        return null;
    }

    private DiscriminatorColumn getDiscriminatorColumn(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("discriminator-column") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorColumn.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "name", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(ad, element, "column-definition", false);
            String value = element.attributeValue("discriminator-type");
            DiscriminatorType type = DiscriminatorType.STRING;
            if (value != null) {
                if ("STRING".equals(value)) {
                    type = DiscriminatorType.STRING;
                } else if ("CHAR".equals(value)) {
                    type = DiscriminatorType.CHAR;
                } else if ("INTEGER".equals(value)) {
                    type = DiscriminatorType.INTEGER;
                } else {
                    throw new AnnotationException("Unknown DiscrimiatorType in XML: " + value + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            ad.setValue("discriminatorType", type);
            EJB3OverridenAnnotationReader.copyIntegerAttribute(ad, element, "length");
            return (DiscriminatorColumn)AnnotationFactory.create(ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(DiscriminatorColumn.class);
        }
        return null;
    }

    private DiscriminatorValue getDiscriminatorValue(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("discriminator-value") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(DiscriminatorValue.class);
            EJB3OverridenAnnotationReader.copyStringElement(element, ad, "value");
            return (DiscriminatorValue)AnnotationFactory.create(ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(DiscriminatorValue.class);
        }
        return null;
    }

    private Inheritance getInheritance(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree != null ? tree.element("inheritance") : null;
        if (element != null) {
            AnnotationDescriptor ad = new AnnotationDescriptor(Inheritance.class);
            Attribute attr = element.attribute("strategy");
            InheritanceType strategy = InheritanceType.SINGLE_TABLE;
            if (attr != null) {
                String value = attr.getValue();
                if ("SINGLE_TABLE".equals(value)) {
                    strategy = InheritanceType.SINGLE_TABLE;
                } else if ("JOINED".equals(value)) {
                    strategy = InheritanceType.JOINED;
                } else if ("TABLE_PER_CLASS".equals(value)) {
                    strategy = InheritanceType.TABLE_PER_CLASS;
                } else {
                    throw new AnnotationException("Unknown InheritanceType in XML: " + value + " (" + SCHEMA_VALIDATION + ")");
                }
            }
            ad.setValue("strategy", strategy);
            return (Inheritance)AnnotationFactory.create(ad);
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(Inheritance.class);
        }
        return null;
    }

    private IdClass getIdClass(Element tree, XMLContext.Default defaults) {
        Element element;
        Element element2 = element = tree == null ? null : tree.element("id-class");
        if (element != null) {
            Attribute attr = element.attribute("class");
            if (attr != null) {
                AnnotationDescriptor ad = new AnnotationDescriptor(IdClass.class);
                Class clazz = null;
                try {
                    clazz = ReflectHelper.classForName((String)XMLContext.buildSafeClassName(attr.getValue(), defaults), this.getClass());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find id-class: " + attr.getValue(), e);
                }
                ad.setValue("value", clazz);
                return (IdClass)AnnotationFactory.create(ad);
            }
            throw new AnnotationException("id-class without class. Activate schema validation for more informations");
        }
        if (defaults.canUseJavaAnnotations()) {
            return super.getAnnotation(IdClass.class);
        }
        return null;
    }

    private PrimaryKeyJoinColumns getPrimaryKeyJoinColumns(Element element, XMLContext.Default defaults) {
        PrimaryKeyJoinColumn[] columns = this.buildPrimaryKeyJoinColumns(element);
        if (columns.length == 0 && defaults.canUseJavaAnnotations()) {
            PrimaryKeyJoinColumn annotation = super.getAnnotation(PrimaryKeyJoinColumn.class);
            if (annotation != null) {
                columns = new PrimaryKeyJoinColumn[]{annotation};
            } else {
                PrimaryKeyJoinColumns annotations = super.getAnnotation(PrimaryKeyJoinColumns.class);
                PrimaryKeyJoinColumn[] primaryKeyJoinColumnArray = columns = annotations != null ? annotations.value() : columns;
            }
        }
        if (columns.length > 0) {
            AnnotationDescriptor ad = new AnnotationDescriptor(PrimaryKeyJoinColumns.class);
            ad.setValue("value", columns);
            return (PrimaryKeyJoinColumns)AnnotationFactory.create(ad);
        }
        return null;
    }

    private Entity getEntity(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? super.getAnnotation(Entity.class) : null;
        }
        if ("entity".equals(tree.getName())) {
            Entity javaAnn;
            AnnotationDescriptor entity = new AnnotationDescriptor(Entity.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(entity, tree, "name", false);
            if (defaults.canUseJavaAnnotations() && StringHelper.isEmpty((String)((String)entity.valueOf("name"))) && (javaAnn = super.getAnnotation(Entity.class)) != null) {
                entity.setValue("name", javaAnn.name());
            }
            return (Entity)AnnotationFactory.create(entity);
        }
        return null;
    }

    private MappedSuperclass getMappedSuperclass(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? super.getAnnotation(MappedSuperclass.class) : null;
        }
        if ("mapped-superclass".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(Entity.class);
            return (MappedSuperclass)AnnotationFactory.create(entity);
        }
        return null;
    }

    private Embeddable getEmbeddable(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return defaults.canUseJavaAnnotations() ? super.getAnnotation(Embeddable.class) : null;
        }
        if ("embeddable".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(Embeddable.class);
            return (Embeddable)AnnotationFactory.create(entity);
        }
        return null;
    }

    private Table getTable(Element tree, XMLContext.Default defaults) {
        Element subelement;
        Element element = subelement = tree == null ? null : tree.element("table");
        if (subelement == null) {
            if (StringHelper.isNotEmpty((String)defaults.getCatalog()) || StringHelper.isNotEmpty((String)defaults.getSchema())) {
                Table table;
                AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
                if (defaults.canUseJavaAnnotations() && (table = super.getAnnotation(Table.class)) != null) {
                    annotation.setValue("name", table.name());
                    annotation.setValue("schema", table.schema());
                    annotation.setValue("catalog", table.catalog());
                    annotation.setValue("uniqueConstraints", table.uniqueConstraints());
                }
                if (StringHelper.isEmpty((String)((String)annotation.valueOf("schema"))) && StringHelper.isNotEmpty((String)defaults.getSchema())) {
                    annotation.setValue("schema", defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)((String)annotation.valueOf("catalog"))) && StringHelper.isNotEmpty((String)defaults.getCatalog())) {
                    annotation.setValue("catalog", defaults.getCatalog());
                }
                return (Table)AnnotationFactory.create(annotation);
            }
            if (defaults.canUseJavaAnnotations()) {
                return super.getAnnotation(Table.class);
            }
            return null;
        }
        AnnotationDescriptor annotation = new AnnotationDescriptor(Table.class);
        EJB3OverridenAnnotationReader.copyStringAttribute(annotation, subelement, "name", false);
        EJB3OverridenAnnotationReader.copyStringAttribute(annotation, subelement, "catalog", false);
        if (StringHelper.isNotEmpty((String)defaults.getCatalog()) && StringHelper.isEmpty((String)((String)annotation.valueOf("catalog")))) {
            annotation.setValue("catalog", defaults.getCatalog());
        }
        EJB3OverridenAnnotationReader.copyStringAttribute(annotation, subelement, "schema", false);
        if (StringHelper.isNotEmpty((String)defaults.getSchema()) && StringHelper.isEmpty((String)((String)annotation.valueOf("schema")))) {
            annotation.setValue("schema", defaults.getSchema());
        }
        EJB3OverridenAnnotationReader.buildUniqueConstraints(annotation, subelement);
        return (Table)AnnotationFactory.create(annotation);
    }

    private SecondaryTables getSecondaryTables(Element tree, XMLContext.Default defaults) {
        List elements = tree == null ? new ArrayList() : tree.elements("secondary-table");
        ArrayList<SecondaryTable> secondaryTables = new ArrayList<SecondaryTable>(3);
        for (Element element : elements) {
            AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(annotation, element, "name", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(annotation, element, "catalog", false);
            if (StringHelper.isNotEmpty((String)defaults.getCatalog()) && StringHelper.isEmpty((String)((String)annotation.valueOf("catalog")))) {
                annotation.setValue("catalog", defaults.getCatalog());
            }
            EJB3OverridenAnnotationReader.copyStringAttribute(annotation, element, "schema", false);
            if (StringHelper.isNotEmpty((String)defaults.getSchema()) && StringHelper.isEmpty((String)((String)annotation.valueOf("schema")))) {
                annotation.setValue("schema", defaults.getSchema());
            }
            EJB3OverridenAnnotationReader.buildUniqueConstraints(annotation, element);
            annotation.setValue("pkJoinColumns", this.buildPrimaryKeyJoinColumns(element));
            secondaryTables.add((SecondaryTable)AnnotationFactory.create(annotation));
        }
        if (secondaryTables.size() == 0 && defaults.canUseJavaAnnotations()) {
            SecondaryTable secTableAnn = super.getAnnotation(SecondaryTable.class);
            this.overridesDefaultInSecondaryTable(secTableAnn, defaults, secondaryTables);
            SecondaryTables secTablesAnn = super.getAnnotation(SecondaryTables.class);
            if (secTablesAnn != null) {
                for (SecondaryTable table : secTablesAnn.value()) {
                    this.overridesDefaultInSecondaryTable(table, defaults, secondaryTables);
                }
            }
        }
        if (secondaryTables.size() > 0) {
            AnnotationDescriptor descriptor = new AnnotationDescriptor(SecondaryTables.class);
            descriptor.setValue("value", secondaryTables.toArray(new SecondaryTable[secondaryTables.size()]));
            return (SecondaryTables)AnnotationFactory.create(descriptor);
        }
        return null;
    }

    private void overridesDefaultInSecondaryTable(SecondaryTable secTableAnn, XMLContext.Default defaults, List<SecondaryTable> secondaryTables) {
        if (secTableAnn != null) {
            if (StringHelper.isNotEmpty((String)defaults.getCatalog()) || StringHelper.isNotEmpty((String)defaults.getSchema())) {
                AnnotationDescriptor annotation = new AnnotationDescriptor(SecondaryTable.class);
                annotation.setValue("name", secTableAnn.name());
                annotation.setValue("schema", secTableAnn.schema());
                annotation.setValue("catalog", secTableAnn.catalog());
                annotation.setValue("uniqueConstraints", secTableAnn.uniqueConstraints());
                annotation.setValue("pkJoinColumns", secTableAnn.pkJoinColumns());
                if (StringHelper.isEmpty((String)((String)annotation.valueOf("schema"))) && StringHelper.isNotEmpty((String)defaults.getSchema())) {
                    annotation.setValue("schema", defaults.getSchema());
                }
                if (StringHelper.isEmpty((String)((String)annotation.valueOf("catalog"))) && StringHelper.isNotEmpty((String)defaults.getCatalog())) {
                    annotation.setValue("catalog", defaults.getCatalog());
                }
                secondaryTables.add((SecondaryTable)AnnotationFactory.create(annotation));
            } else {
                secondaryTables.add(secTableAnn);
            }
        }
    }

    private static void buildUniqueConstraints(AnnotationDescriptor annotation, Element element) {
        List uniqueConstraintElementList = element.elements("unique-constraint");
        UniqueConstraint[] uniqueConstraints = new UniqueConstraint[uniqueConstraintElementList.size()];
        int ucIndex = 0;
        ListIterator ucIt = uniqueConstraintElementList.listIterator();
        while (ucIt.hasNext()) {
            Element subelement = (Element)ucIt.next();
            List columnNamesElements = subelement.elements("column-name");
            String[] columnNames = new String[columnNamesElements.size()];
            int columnNameIndex = 0;
            ListIterator it = columnNamesElements.listIterator();
            while (it.hasNext()) {
                Element columnNameElt = (Element)it.next();
                columnNames[columnNameIndex++] = columnNameElt.getTextTrim();
            }
            AnnotationDescriptor ucAnn = new AnnotationDescriptor(UniqueConstraint.class);
            ucAnn.setValue("columnNames", columnNames);
            uniqueConstraints[ucIndex++] = (UniqueConstraint)AnnotationFactory.create(ucAnn);
        }
        annotation.setValue("uniqueConstraints", uniqueConstraints);
    }

    private PrimaryKeyJoinColumn[] buildPrimaryKeyJoinColumns(Element element) {
        if (element == null) {
            return new PrimaryKeyJoinColumn[0];
        }
        List pkJoinColumnElementList = element.elements("primary-key-join-column");
        PrimaryKeyJoinColumn[] pkJoinColumns = new PrimaryKeyJoinColumn[pkJoinColumnElementList.size()];
        int index = 0;
        ListIterator pkIt = pkJoinColumnElementList.listIterator();
        while (pkIt.hasNext()) {
            Element subelement = (Element)pkIt.next();
            AnnotationDescriptor pkAnn = new AnnotationDescriptor(PrimaryKeyJoinColumn.class);
            EJB3OverridenAnnotationReader.copyStringAttribute(pkAnn, subelement, "name", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(pkAnn, subelement, "referenced-column-name", false);
            EJB3OverridenAnnotationReader.copyStringAttribute(pkAnn, subelement, "column-definition", false);
            pkJoinColumns[index++] = (PrimaryKeyJoinColumn)AnnotationFactory.create(pkAnn);
        }
        return pkJoinColumns;
    }

    private static void copyStringAttribute(AnnotationDescriptor annotation, Element element, String attributeName, boolean mandatory) {
        String attribute = element.attributeValue(attributeName);
        if (attribute != null) {
            String annotationAttributeName = EJB3OverridenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName);
            annotation.setValue(annotationAttributeName, attribute);
        } else if (mandatory) {
            throw new AnnotationException(element.getName() + "." + attributeName + " is mandatory in XML overring. " + SCHEMA_VALIDATION);
        }
    }

    private static void copyIntegerAttribute(AnnotationDescriptor annotation, Element element, String attributeName) {
        String attribute = element.attributeValue(attributeName);
        if (attribute != null) {
            String annotationAttributeName = EJB3OverridenAnnotationReader.getJavaAttributeNameFromXMLOne(attributeName);
            annotation.setValue(annotationAttributeName, attribute);
            try {
                int length = Integer.parseInt(attribute);
                annotation.setValue(annotationAttributeName, length);
            }
            catch (NumberFormatException e) {
                throw new AnnotationException(element.getPath() + attributeName + " not parseable: " + attribute + " (" + SCHEMA_VALIDATION + ")");
            }
        }
    }

    private static String getJavaAttributeNameFromXMLOne(String attributeName) {
        StringBuilder annotationAttributeName = new StringBuilder(attributeName);
        int index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        while (index != -1) {
            annotationAttributeName.deleteCharAt(index);
            annotationAttributeName.setCharAt(index, Character.toUpperCase(annotationAttributeName.charAt(index)));
            index = annotationAttributeName.indexOf(WORD_SEPARATOR);
        }
        return annotationAttributeName.toString();
    }

    private static void copyStringElement(Element element, AnnotationDescriptor ad, String annotationAttribute) {
        String discr = element.getTextTrim();
        ad.setValue(annotationAttribute, discr);
    }

    private static void copyBooleanAttribute(AnnotationDescriptor descriptor, Element element, String attribute) {
        String attributeValue = element.attributeValue(attribute);
        if (StringHelper.isNotEmpty((String)attributeValue)) {
            String javaAttribute = EJB3OverridenAnnotationReader.getJavaAttributeNameFromXMLOne(attribute);
            descriptor.setValue(javaAttribute, Boolean.parseBoolean(attributeValue));
        }
    }

    static {
        FILTER = new Filter(){

            public boolean returnStatic() {
                return false;
            }

            public boolean returnTransient() {
                return false;
            }
        };
        annotationToXml = new HashMap<Class, String>();
        annotationToXml.put(Entity.class, "entity");
        annotationToXml.put(MappedSuperclass.class, "mapped-superclass");
        annotationToXml.put(Embeddable.class, "embeddable");
        annotationToXml.put(Table.class, "table");
        annotationToXml.put(SecondaryTable.class, "secondary-table");
        annotationToXml.put(SecondaryTables.class, "secondary-table");
        annotationToXml.put(PrimaryKeyJoinColumn.class, "primary-key-join-column");
        annotationToXml.put(PrimaryKeyJoinColumns.class, "primary-key-join-column");
        annotationToXml.put(IdClass.class, "id-class");
        annotationToXml.put(Inheritance.class, "inheritance");
        annotationToXml.put(DiscriminatorValue.class, "discriminator-value");
        annotationToXml.put(DiscriminatorColumn.class, "discriminator-column");
        annotationToXml.put(SequenceGenerator.class, "sequence-generator");
        annotationToXml.put(TableGenerator.class, "table-generator");
        annotationToXml.put(NamedQuery.class, "named-query");
        annotationToXml.put(NamedQueries.class, "named-query");
        annotationToXml.put(NamedNativeQuery.class, "named-native-query");
        annotationToXml.put(NamedNativeQueries.class, "named-native-query");
        annotationToXml.put(SqlResultSetMapping.class, "sql-result-set-mapping");
        annotationToXml.put(SqlResultSetMappings.class, "sql-result-set-mapping");
        annotationToXml.put(ExcludeDefaultListeners.class, "exclude-default-listeners");
        annotationToXml.put(ExcludeSuperclassListeners.class, "exclude-superclass-listeners");
        annotationToXml.put(AccessType.class, "access");
        annotationToXml.put(AttributeOverride.class, "attribute-override");
        annotationToXml.put(AttributeOverrides.class, "attribute-override");
        annotationToXml.put(AttributeOverride.class, "association-override");
        annotationToXml.put(AttributeOverrides.class, "association-override");
        annotationToXml.put(Id.class, "id");
        annotationToXml.put(EmbeddedId.class, "embedded-id");
        annotationToXml.put(GeneratedValue.class, "generated-value");
        annotationToXml.put(Column.class, "column");
        annotationToXml.put(Columns.class, "column");
        annotationToXml.put(Temporal.class, "temporal");
        annotationToXml.put(Lob.class, "lob");
        annotationToXml.put(Enumerated.class, "enumerated");
        annotationToXml.put(Version.class, "version");
        annotationToXml.put(Transient.class, "transient");
        annotationToXml.put(Basic.class, "basic");
        annotationToXml.put(Embedded.class, "embedded");
        annotationToXml.put(ManyToOne.class, "many-to-one");
        annotationToXml.put(OneToOne.class, "one-to-one");
        annotationToXml.put(OneToMany.class, "one-to-many");
        annotationToXml.put(ManyToMany.class, "many-to-many");
        annotationToXml.put(JoinTable.class, "join-table");
        annotationToXml.put(JoinColumn.class, "join-column");
        annotationToXml.put(JoinColumns.class, "join-column");
        annotationToXml.put(MapKey.class, "map-key");
        annotationToXml.put(OrderBy.class, "order-by");
        annotationToXml.put(EntityListeners.class, "entity-listeners");
        annotationToXml.put(PrePersist.class, "pre-persist");
        annotationToXml.put(PreRemove.class, "pre-remove");
        annotationToXml.put(PreUpdate.class, "pre-update");
        annotationToXml.put(PostPersist.class, "post-persist");
        annotationToXml.put(PostRemove.class, "post-remove");
        annotationToXml.put(PostUpdate.class, "post-update");
        annotationToXml.put(PostLoad.class, "post-load");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum PropertyType {
        PROPERTY,
        FIELD,
        METHOD;

    }
}

