/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLContext {
    private static Log log = LogFactory.getLog(XMLContext.class);
    private Default globalDefaults;
    private Map<String, Element> classOverriding = new HashMap<String, Element>();
    private Map<String, Default> defaultsOverriding = new HashMap<String, Default>();

    public void addDocument(Document doc) {
        Element unitElement;
        Element root = doc.getRootElement();
        Element metadata = root.element("persistence-unit-metadata");
        if (metadata != null) {
            if (this.globalDefaults == null) {
                this.globalDefaults = new Default();
                this.globalDefaults.setMetadataComplete(metadata.element("xml-mapping-metadata-complete") != null ? Boolean.TRUE : null);
                Element defaultElement = metadata.element("persistence-unit-defaults");
                unitElement = defaultElement.element("schema");
                this.globalDefaults.setSchema(unitElement != null ? unitElement.getTextTrim() : null);
                unitElement = defaultElement.element("catalog");
                this.globalDefaults.setCatalog(unitElement != null ? unitElement.getTextTrim() : null);
                unitElement = defaultElement.element("access");
                this.globalDefaults.setAccess(unitElement != null ? unitElement.getTextTrim() : null);
                unitElement = defaultElement.element("cascade-persist");
                this.globalDefaults.setCascadePersist(unitElement != null ? Boolean.TRUE : null);
            } else {
                log.warn((Object)"Found more than one <persistence-unit-metadata>, ignored");
            }
        }
        Default entityMappingDefault = new Default();
        unitElement = root.element("package");
        String packageName = unitElement != null ? unitElement.getTextTrim() : "";
        entityMappingDefault.setPackageName(packageName);
        unitElement = root.element("schema");
        entityMappingDefault.setSchema(unitElement != null ? unitElement.getTextTrim() : null);
        unitElement = root.element("catalog");
        entityMappingDefault.setCatalog(unitElement != null ? unitElement.getTextTrim() : null);
        unitElement = root.element("access");
        entityMappingDefault.setAccess(unitElement != null ? unitElement.getTextTrim() : null);
        List entities = root.elements("entity");
        this.addClass(entities, packageName, entityMappingDefault);
        entities = root.elements("mapped-superclass");
        this.addClass(entities, packageName, entityMappingDefault);
        entities = root.elements("embeddable");
        this.addClass(entities, packageName, entityMappingDefault);
    }

    private void addClass(List<Element> entities, String packageName, Default defaults) {
        for (Element element : entities) {
            Attribute attribute = element.attribute("class");
            String className = XMLContext.buildSafeClassName(attribute.getText(), packageName);
            if (this.classOverriding.containsKey(className)) {
                throw new IllegalStateException("Duplicate XML entry for " + className);
            }
            this.classOverriding.put(className, element);
            Default localDefault = new Default();
            localDefault.override(defaults);
            attribute = element.attribute("metadata-complete");
            if (attribute != null) {
                localDefault.setMetadataComplete((Boolean)attribute.getData());
            }
            this.defaultsOverriding.put(className, localDefault);
            log.debug((Object)("Adding XML overriding information for " + className));
        }
    }

    private static String buildSafeClassName(String className, String defaultPackageName) {
        if (className.indexOf(46) < 0 && defaultPackageName != null) {
            className = StringHelper.qualify((String)defaultPackageName, (String)className);
        }
        return className;
    }

    public Default getDefault(String className) {
        Default xmlDefault = new Default();
        xmlDefault.override(this.globalDefaults);
        Default entityMappingOverriding = this.defaultsOverriding.get(className);
        xmlDefault.override(entityMappingOverriding);
        return xmlDefault;
    }

    public Element getXMLTree(String className, String methodName) {
        return this.classOverriding.get(className);
    }

    public static class Default {
        private String access;
        private String packageName;
        private String schema;
        private String catalog;
        private Boolean metadataComplete;
        private Boolean cascadePersist;

        public String getAccess() {
            return this.access;
        }

        protected void setAccess(String access) {
            this.access = access;
        }

        public String getCatalog() {
            return this.catalog;
        }

        protected void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        public String getPackageName() {
            return this.packageName;
        }

        protected void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        public String getSchema() {
            return this.schema;
        }

        protected void setSchema(String schema) {
            this.schema = schema;
        }

        public Boolean getMetadataComplete() {
            return this.metadataComplete;
        }

        protected void setMetadataComplete(Boolean metadataComplete) {
            this.metadataComplete = metadataComplete;
        }

        public Boolean getCascadePersist() {
            return this.cascadePersist;
        }

        void setCascadePersist(Boolean cascadePersist) {
            this.cascadePersist = cascadePersist;
        }

        public void override(Default globalDefault) {
            if (globalDefault != null) {
                if (globalDefault.getAccess() != null) {
                    this.access = globalDefault.getAccess();
                }
                if (globalDefault.getPackageName() != null) {
                    this.packageName = globalDefault.getPackageName();
                }
                if (globalDefault.getSchema() != null) {
                    this.schema = globalDefault.getSchema();
                }
                if (globalDefault.getCatalog() != null) {
                    this.catalog = globalDefault.getCatalog();
                }
                if (globalDefault.getMetadataComplete() != null) {
                    this.metadataComplete = globalDefault.getMetadataComplete();
                }
                if (globalDefault.getCascadePersist() != null) {
                    this.cascadePersist = globalDefault.getCascadePersist();
                }
            }
        }
    }
}

