/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XMethod;
import org.hibernate.reflection.XPackage;
import org.hibernate.reflection.XProperty;
import org.hibernate.reflection.java.JavaXArrayType;
import org.hibernate.reflection.java.JavaXClass;
import org.hibernate.reflection.java.JavaXCollectionType;
import org.hibernate.reflection.java.JavaXMethod;
import org.hibernate.reflection.java.JavaXPackage;
import org.hibernate.reflection.java.JavaXProperty;
import org.hibernate.reflection.java.JavaXSimpleType;
import org.hibernate.reflection.java.JavaXType;
import org.hibernate.reflection.java.Pair;
import org.hibernate.reflection.java.generics.IdentityTypeEnvironment;
import org.hibernate.reflection.java.generics.TypeEnvironment;
import org.hibernate.reflection.java.generics.TypeEnvironmentFactory;
import org.hibernate.reflection.java.generics.TypeSwitch;
import org.hibernate.reflection.java.generics.TypeUtils;
import org.hibernate.reflection.java.xml.XMLContext;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.XMLHelper;
import org.xml.sax.EntityResolver;

public class JavaXFactory
implements ReflectionManager {
    private static Log log = LogFactory.getLog(JavaXFactory.class);
    private transient XMLHelper xmlHelper;
    private EntityResolver entityResolver;
    private XMLContext xmlContext;
    private final Map<TypeKey, JavaXClass> xClasses = new HashMap<TypeKey, JavaXClass>();
    private final Map<Package, JavaXPackage> packagesToXPackages = new HashMap<Package, JavaXPackage>();
    private final Map<MemberKey, JavaXProperty> xProperties = new HashMap<MemberKey, JavaXProperty>();
    private final Map<MemberKey, JavaXMethod> xMethods = new HashMap<MemberKey, JavaXMethod>();
    private final TypeEnvironmentFactory typeEnvs = new TypeEnvironmentFactory();

    public JavaXFactory() {
        this.reset();
    }

    private void reset() {
        this.xmlHelper = new XMLHelper();
        this.entityResolver = XMLHelper.DEFAULT_DTD_RESOLVER;
        this.xmlContext = new XMLContext();
    }

    public XClass toXClass(Class clazz) {
        return this.toXClass(clazz, IdentityTypeEnvironment.INSTANCE);
    }

    public Class toClass(XClass xClazz) {
        if (!(xClazz instanceof JavaXClass)) {
            throw new IllegalArgumentException("XClass not coming from this ReflectionManager implementation");
        }
        return (Class)((JavaXClass)xClazz).toAnnotatedElement();
    }

    public XClass classForName(String name, Class caller) throws ClassNotFoundException {
        return this.toXClass(ReflectHelper.classForName((String)name, (Class)caller));
    }

    public XPackage packageForName(String packageName) throws ClassNotFoundException {
        return this.getXAnnotatedElement(ReflectHelper.classForName((String)(packageName + ".package-info")).getPackage());
    }

    XClass toXClass(Type t, final TypeEnvironment context) {
        return (XClass)new TypeSwitch<XClass>(){

            @Override
            public XClass caseClass(Class classType) {
                TypeKey key = new TypeKey(classType, context);
                JavaXClass result = (JavaXClass)JavaXFactory.this.xClasses.get(key);
                if (result == null) {
                    result = new JavaXClass(classType, context, JavaXFactory.this);
                    JavaXFactory.this.xClasses.put(key, result);
                }
                return result;
            }

            @Override
            public XClass caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaXFactory.this.toXClass(parameterizedType.getRawType(), context);
            }
        }.doSwitch(context.bind(t));
    }

    XPackage getXAnnotatedElement(Package pkg) {
        JavaXPackage xPackage = this.packagesToXPackages.get(pkg);
        if (xPackage == null) {
            xPackage = new JavaXPackage(pkg, this);
            this.packagesToXPackages.put(pkg, xPackage);
        }
        return xPackage;
    }

    XProperty getXProperty(Member member, JavaXClass owner) {
        MemberKey key = new MemberKey(member, owner.toClass(), owner.getTypeEnvironment());
        JavaXProperty xProperty = this.xProperties.get(key);
        if (!this.xProperties.containsKey(key)) {
            xProperty = JavaXProperty.create(member, owner.getTypeEnvironment(), this);
            this.xProperties.put(key, xProperty);
        }
        return xProperty;
    }

    XMethod getXMethod(Member member, JavaXClass owner) {
        MemberKey key = new MemberKey(member, owner.toClass(), owner.getTypeEnvironment());
        JavaXMethod xMethod = this.xMethods.get(key);
        if (!this.xMethods.containsKey(key)) {
            xMethod = JavaXMethod.create(member, owner.getTypeEnvironment(), this);
            this.xMethods.put(key, xMethod);
        }
        return xMethod;
    }

    TypeEnvironment getTypeEnvironment(Type t) {
        return (TypeEnvironment)new TypeSwitch<TypeEnvironment>(){

            @Override
            public TypeEnvironment caseClass(Class classType) {
                return JavaXFactory.this.typeEnvs.getEnvironment(classType);
            }

            @Override
            public TypeEnvironment caseParameterizedType(ParameterizedType parameterizedType) {
                return JavaXFactory.this.typeEnvs.getEnvironment(parameterizedType);
            }

            @Override
            public TypeEnvironment defaultCase(Type type) {
                return IdentityTypeEnvironment.INSTANCE;
            }
        }.doSwitch(t);
    }

    public JavaXType toXType(TypeEnvironment context, Type propType) {
        Type boundType = this.toApproximatingEnvironment(context).bind(propType);
        if (TypeUtils.isArray(boundType)) {
            return new JavaXArrayType(propType, context, this);
        }
        if (TypeUtils.isCollection(boundType)) {
            return new JavaXCollectionType(propType, context, this);
        }
        if (TypeUtils.isSimple(boundType)) {
            return new JavaXSimpleType(propType, context, this);
        }
        throw new IllegalArgumentException("No PropertyTypeExtractor available for type void ");
    }

    public boolean equals(XClass class1, Class class2) {
        if (class1 == null) {
            return class2 == null;
        }
        return ((JavaXClass)class1).toClass().equals(class2);
    }

    public TypeEnvironment toApproximatingEnvironment(TypeEnvironment context) {
        return this.typeEnvs.toApproximatingEnvironment(context);
    }

    XMLContext getXMLContext() {
        return this.xmlContext;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberKey
    extends Pair<Member, TypeKey> {
        MemberKey(Member member, Type owner, TypeEnvironment context) {
            super(member, new TypeKey(owner, context));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeKey
    extends Pair<Type, TypeEnvironment> {
        TypeKey(Type t, TypeEnvironment context) {
            super(t, context);
        }
    }
}

