/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XProperty;

public class PropertyBinder {
    private static Log log = LogFactory.getLog(PropertyBinder.class);
    private String name;
    private String returnedClassName;
    private boolean lazy;
    private String propertyAccessorName;
    private Ejb3Column[] columns;
    private PropertyHolder holder;
    private Mappings mappings;
    private Value value;
    private boolean insertable = true;
    private boolean updatable = true;
    private String cascade;
    private XProperty property;
    private XClass returnedClass;

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setPropertyAccessorName(String propertyAccessorName) {
        this.propertyAccessorName = propertyAccessorName;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.insertable = columns[0].isInsertable();
        this.updatable = columns[0].isUpdatable();
        this.columns = columns;
    }

    public void setHolder(PropertyHolder holder) {
        this.holder = holder;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public void setCascade(String cascadeStrategy) {
        this.cascade = cascadeStrategy;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    private void validateBind() {
    }

    private void validateMake() {
    }

    public Property bind() {
        this.validateBind();
        if (log.isDebugEnabled()) {
            log.debug((Object)("binding property " + this.name + " with lazy=" + this.lazy));
        }
        String containerClassName = this.holder == null ? null : this.holder.getClassName();
        SimpleValueBinder value = new SimpleValueBinder();
        value.setPropertyName(this.name);
        value.setReturnedClassName(this.returnedClassName);
        value.setColumns(this.columns);
        value.setPersistentClassName(containerClassName);
        value.setType(this.property, this.returnedClass);
        value.setMappings(this.mappings);
        SimpleValue propertyValue = value.make();
        this.setValue((Value)propertyValue);
        Property prop = this.make();
        this.holder.addProperty(prop, this.columns);
        return prop;
    }

    public Property make() {
        this.validateMake();
        log.debug((Object)("Building property " + this.name));
        Property prop = new Property();
        prop.setName(this.name);
        prop.setValue(this.value);
        prop.setInsertable(this.insertable);
        prop.setUpdateable(this.updatable);
        prop.setLazy(this.lazy);
        prop.setCascade(this.cascade);
        prop.setPropertyAccessorName(this.propertyAccessorName);
        log.debug((Object)("Cascading " + this.name + " with " + this.cascade));
        return prop;
    }

    public void setProperty(XProperty property) {
        this.property = property;
    }

    public void setReturnedClass(XClass returnedClass) {
        this.returnedClass = returnedClass;
    }
}

