/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class IndexSecondPass
implements SecondPass {
    private Table table;
    private final String indexName;
    private final String[] columns;
    private final ExtendedMappings mappings;
    private final Ejb3Column column;

    public IndexSecondPass(Table table, String indexName, String[] columns, ExtendedMappings mappings) {
        this.table = table;
        this.indexName = indexName;
        this.columns = columns;
        this.mappings = mappings;
        this.column = null;
    }

    public IndexSecondPass(String indexName, Ejb3Column column, ExtendedMappings mappings) {
        this.indexName = indexName;
        this.column = column;
        this.columns = null;
        this.mappings = mappings;
    }

    public void doSecondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        if (this.columns != null) {
            for (String columnName : this.columns) {
                this.addIndexToColumn(columnName);
            }
        }
        if (this.column != null) {
            this.table = this.column.getTable();
            this.addIndexToColumn(this.column.getName());
        }
    }

    private void addIndexToColumn(String columnName) {
        Column column = this.table.getColumn(new Column(this.mappings.getPhysicalColumnName(columnName, this.table)));
        if (column == null) {
            throw new AnnotationException("@Index references a unknown column: " + columnName);
        }
        this.table.getOrCreateIndex(this.indexName).addColumn(column);
    }
}

