/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import javax.persistence.AccessType;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.MapKey;
import javax.persistence.OrderBy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.ArrayBinder;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.ListBinder;
import org.hibernate.cfg.annotations.MapBinder;
import org.hibernate.cfg.annotations.PrimitiveArrayBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.SetBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public abstract class CollectionBinder {
    private static final Log log = LogFactory.getLog(CollectionBinder.class);
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    FetchMode fetchMode;
    PropertyHolder propertyHolder;
    int batchSize;
    String where;
    private String mappedBy;
    private Class collectionType;
    private String targetEntity;
    private ExtendedMappings mappings;
    private Ejb3JoinColumn[] inverseJoinColumns;
    private String cascadeStrategy;
    String cacheConcurrencyStrategy;
    Map<String, String> filters = new HashMap<String, String>();
    String cacheRegionName;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    private String orderBy;
    protected String hqlOrderBy;
    private boolean isSorted;
    private Class comparator;
    private boolean hasToBeSorted;
    protected boolean cascadeDeleteEnabled;
    protected String mapKeyPropertyName;
    private boolean insertable = true;
    private boolean updatable = true;
    private Ejb3JoinColumn[] fkJoinColumns;
    private boolean isExplicitAssociationTable;
    private Ejb3Column[] elementColumns;
    private boolean isEmbedded;
    private AnnotatedElement annotatedElt;
    private boolean ignoreNotFound;
    private TableBinder tableBinder;
    private String propertyAccessorName;
    private Ejb3JoinColumn[] joinColumns;

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public void setInsertable(boolean insertable) {
        this.insertable = insertable;
    }

    public void setCascadeStrategy(String cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
    }

    public void setPropertyAccessorName(String propertyAccessorName) {
        this.propertyAccessorName = propertyAccessorName;
    }

    public void setInverseJoinColumns(Ejb3JoinColumn[] inverseJoinColumns) {
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(Ejb3JoinColumn[] joinColumns) {
        this.joinColumns = joinColumns;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize == null ? -1 : batchSize.size();
    }

    public void setEjb3OrderBy(OrderBy orderByAnn) {
        if (orderByAnn != null) {
            this.hqlOrderBy = orderByAnn.value();
        }
    }

    public void setSqlOrderBy(org.hibernate.annotations.OrderBy orderByAnn) {
        if (orderByAnn != null && !AnnotationBinder.isDefault(orderByAnn.clause())) {
            this.orderBy = orderByAnn.clause();
        }
    }

    public void setSort(Sort sortAnn) {
        if (sortAnn != null) {
            boolean bl = this.isSorted = !SortType.UNSORTED.equals((Object)sortAnn.type());
            if (this.isSorted && SortType.COMPARATOR.equals((Object)sortAnn.type())) {
                this.comparator = sortAnn.comparator();
            }
        }
    }

    public static CollectionBinder getCollectionBinder(String entityName, PropertyInferredData inferredData, boolean isIndexed) {
        CollectionBinder binder = null;
        Class returnedClass = inferredData.getReturnedClassOrElement();
        if (inferredData.isArray()) {
            binder = inferredData.getReturnedClassOrElement().isPrimitive() ? new PrimitiveArrayBinder() : new ArrayBinder();
        } else if (Set.class.equals((Object)returnedClass)) {
            binder = new SetBinder();
        } else if (SortedSet.class.equals((Object)returnedClass)) {
            binder = new SetBinder(true);
        } else if (Map.class.equals((Object)returnedClass)) {
            binder = new MapBinder();
        } else if (Collection.class.equals((Object)returnedClass)) {
            binder = new BagBinder();
        } else if (List.class.equals((Object)returnedClass)) {
            binder = isIndexed ? new ListBinder() : new BagBinder();
        } else {
            throw new AnnotationException(returnedClass.getName() + " collection not yet supported: " + entityName + inferredData.getPropertyName());
        }
        return binder;
    }

    protected CollectionBinder() {
    }

    protected CollectionBinder(boolean sorted) {
        this.hasToBeSorted = sorted;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public void setTableBinder(TableBinder table) {
        this.tableBinder = table;
    }

    public void setCollectionType(Class collectionType) {
        this.collectionType = collectionType;
    }

    public void setTargetEntity(Class targetEntity) {
        this.targetEntity = AnnotationBinder.isDefault(targetEntity) ? "" : targetEntity.getName();
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void bind() {
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        log.debug((Object)("Collection role: " + StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName)));
        this.collection.setRole(StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName));
        this.collection.setFetchMode(this.fetchMode);
        this.collection.setLazy(this.fetchMode == FetchMode.SELECT);
        this.collection.setBatchSize(this.batchSize);
        if (this.orderBy != null && this.hqlOrderBy != null) {
            throw new AnnotationException("Cannot use sql order by clause in conjunction of EJB3 order by clause: " + this.safeCollectionRole());
        }
        if (this.orderBy != null) {
            this.collection.setOrderBy(this.orderBy);
        }
        if (this.isSorted) {
            this.collection.setSorted(true);
            if (this.comparator != null) {
                try {
                    this.collection.setComparator((Comparator)this.comparator.newInstance());
                }
                catch (Exception e) {
                    throw new AnnotationException("Could not instantiate comparator class: " + this.comparator.getName() + "(" + this.safeCollectionRole() + ")");
                }
            }
        } else if (this.hasToBeSorted) {
            throw new AnnotationException("A sorted collection has to define @Sort: " + this.safeCollectionRole());
        }
        if (StringHelper.isNotEmpty((String)this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        Iterator<Map.Entry<String, String>> iter = this.filters.entrySet().iterator();
        if (StringHelper.isNotEmpty((String)this.where)) {
            this.collection.setWhere(this.where);
        }
        while (iter.hasNext()) {
            Map.Entry<String, String> filter = iter.next();
            String name = filter.getKey();
            String cond = filter.getValue();
            if (AnnotationBinder.isDefault(cond) && StringHelper.isEmpty((String)(cond = this.mappings.getFilterDefinition(name).getDefaultFilterCondition()))) {
                throw new AnnotationException("no filter condition found for filter " + name + " in " + StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName));
            }
            this.collection.addFilter(name, cond);
        }
        boolean isMappedBy = !AnnotationBinder.isDefault(this.mappedBy);
        this.collection.setInverse(isMappedBy);
        String collType = this.getCollectionType();
        if (!this.oneToMany && isMappedBy) {
            this.mappings.addMappedBy(collType, this.mappedBy, this.propertyName);
        }
        this.mappings.addSecondPass(this.getSecondPass(this.fkJoinColumns, this.joinColumns, this.inverseJoinColumns, this.elementColumns, this.isEmbedded, this.annotatedElt, collType, this.fetchMode, this.ignoreNotFound, this.oneToMany, this.tableBinder, this.mappings), !isMappedBy);
        this.mappings.addCollection(this.collection);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(this.propertyName);
        binder.setValue((Value)this.collection);
        binder.setCascade(this.cascadeStrategy);
        if (this.cascadeStrategy != null && this.cascadeStrategy.indexOf("delete-orphan") >= 0) {
            this.collection.setOrphanDelete(true);
        }
        binder.setPropertyAccessorName(this.propertyAccessorName);
        binder.setInsertable(this.insertable);
        binder.setUpdatable(this.updatable);
        Property prop = binder.make();
        this.propertyHolder.addProperty(prop);
    }

    private String getCollectionType() {
        if (AnnotationBinder.isDefault(this.targetEntity)) {
            if (this.collectionType != null) {
                return this.collectionType.getName();
            }
            String errorMsg = "Collection has neither generic type or OneToMany.targetEntity() defined: " + this.safeCollectionRole();
            throw new AnnotationException(errorMsg);
        }
        return this.targetEntity;
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] fkJoinColumns, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final Ejb3Column[] elementColumns, final boolean isEmbedded, final AnnotatedElement annotatedElt, final String collType, final FetchMode fetchMode, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final ExtendedMappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                CollectionBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, annotatedElt, fetchMode, unique, assocTableBinder, ignoreNotFound, mappings);
            }
        };
    }

    protected boolean bindStarToManySecondPass(Map persistentClasses, String collType, Ejb3JoinColumn[] fkJoinColumns, Ejb3JoinColumn[] keyColumns, Ejb3JoinColumn[] inverseColumns, Ejb3Column[] elementColumns, boolean isEmbedded, AnnotatedElement annotatedElt, FetchMode fetchMode, boolean unique, TableBinder associationTableBinder, boolean ignoreNotFound, ExtendedMappings mappings) {
        boolean isEntity = persistentClasses.containsKey(collType);
        if (isEntity && this.oneToMany && !this.isExplicitAssociationTable && (this.joinColumns[0].isImplicit() && !AnnotationBinder.isDefault(this.mappedBy) || !fkJoinColumns[0].isImplicit())) {
            this.bindOneToManySecondPass(this.getCollection(), persistentClasses, fkJoinColumns, collType, this.cascadeDeleteEnabled, ignoreNotFound, this.hqlOrderBy, mappings);
            return true;
        }
        CollectionBinder.bindManyToManySecondPass(this.collection, persistentClasses, keyColumns, inverseColumns, elementColumns, isEmbedded, collType, fetchMode, ignoreNotFound, unique, this.cascadeDeleteEnabled, associationTableBinder, annotatedElt, mappings);
        return false;
    }

    protected void bindOneToManySecondPass(org.hibernate.mapping.Collection collection, Map persistentClasses, Ejb3JoinColumn[] fkJoinColumns, String collectionType, boolean cascadeDeleteEnabled, boolean ignoreNotFound, String hqlOrderBy, ExtendedMappings extendedMappings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding a OneToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName + " through a foreign key"));
        }
        OneToMany oneToMany = new OneToMany(collection.getOwner());
        collection.setElement((Value)oneToMany);
        oneToMany.setReferencedEntityName(collectionType);
        oneToMany.setIgnoreNotFound(ignoreNotFound);
        String assocClass = oneToMany.getReferencedEntityName();
        PersistentClass associatedClass = (PersistentClass)persistentClasses.get(assocClass);
        String orderBy = CollectionBinder.buildOrderByClauseFromHql(hqlOrderBy, associatedClass, collection.getRole());
        if (orderBy != null) {
            collection.setOrderBy(orderBy);
        }
        if (this.mappings == null) {
            throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
        }
        Map<String, Join> joins = this.mappings.getJoins(assocClass);
        if (associatedClass == null) {
            throw new MappingException("Association references unmapped class: " + assocClass);
        }
        oneToMany.setAssociatedClass(associatedClass);
        for (Ejb3JoinColumn column : fkJoinColumns) {
            column.setPersistentClass(associatedClass, joins);
            column.setJoins(joins);
            collection.setCollectionTable(column.getTable());
        }
        log.info((Object)("Mapping collection: " + collection.getRole() + " -> " + collection.getCollectionTable().getName()));
        CollectionBinder.bindCollectionSecondPass(collection, null, fkJoinColumns, cascadeDeleteEnabled, this.mappings);
        if (!collection.isInverse() && !collection.getKey().isNullable()) {
            String entityName = oneToMany.getReferencedEntityName();
            PersistentClass referenced = this.mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + fkJoinColumns[0].getPropertyName() + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collection.getRole());
            prop.setEntityName(collection.getOwner().getEntityName());
            prop.setValue((Value)collection.getKey());
            referenced.addProperty((Property)prop);
        }
    }

    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegionName = AnnotationBinder.isDefault(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setFetchType(FetchType fetch) {
        this.fetchMode = fetch == FetchType.EAGER ? FetchMode.JOIN : FetchMode.SELECT;
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    public void setMapKey(MapKey key) {
        if (key != null) {
            this.mapKeyPropertyName = key.name();
        }
    }

    private static String buildOrderByClauseFromHql(String hqlOrderBy, PersistentClass associatedClass, String role) {
        String orderByString = null;
        if (hqlOrderBy != null) {
            ArrayList<String> properties = new ArrayList<String>();
            ArrayList<String> ordering = new ArrayList<String>();
            StringBuilder orderByBuffer = new StringBuilder();
            if ("".equals(hqlOrderBy)) {
                Iterator it = associatedClass.getIdentifier().getColumnIterator();
                while (it.hasNext()) {
                    Column col = (Column)it.next();
                    orderByBuffer.append(col.getName()).append(" asc").append(", ");
                }
            } else {
                StringTokenizer st = new StringTokenizer(hqlOrderBy, " ,", false);
                String currentOrdering = null;
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (CollectionBinder.isNonPropertyToken(token)) {
                        if (currentOrdering != null) {
                            throw new AnnotationException("Error while parsing HQL orderBy clause: " + hqlOrderBy + " (" + role + ")");
                        }
                        currentOrdering = token;
                        continue;
                    }
                    if (currentOrdering == null) {
                        ordering.add("asc");
                    } else {
                        ordering.add(currentOrdering);
                        currentOrdering = null;
                    }
                    properties.add(token);
                }
                ordering.remove(0);
                if (currentOrdering == null) {
                    ordering.add("asc");
                } else {
                    ordering.add(currentOrdering);
                    currentOrdering = null;
                }
                int index = 0;
                for (String property : properties) {
                    Property p = BinderHelper.findPropertyByName(associatedClass, property);
                    if (p == null) {
                        throw new AnnotationException("property from @OrderBy clause not found: " + associatedClass.getEntityName() + "." + property);
                    }
                    Iterator propertyColumns = p.getColumnIterator();
                    while (propertyColumns.hasNext()) {
                        Column column = (Column)propertyColumns.next();
                        orderByBuffer.append(column.getName()).append(" ").append((String)ordering.get(index)).append(", ");
                    }
                    ++index;
                }
            }
            orderByString = orderByBuffer.substring(0, orderByBuffer.length() - 2);
        }
        return orderByString;
    }

    private static boolean isNonPropertyToken(String token) {
        if (" ".equals(token)) {
            return true;
        }
        if (",".equals(token)) {
            return true;
        }
        if (token.equalsIgnoreCase("desc")) {
            return true;
        }
        return token.equalsIgnoreCase("asc");
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collValue, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled, ExtendedMappings mappings) {
        String propRef;
        String entityName;
        String propRef2;
        if (joinColumns.length > 0 && StringHelper.isNotEmpty((String)joinColumns[0].getMappedBy()) && (propRef2 = mappings.getPropertyReferencedAssociation(entityName = joinColumns[0].getManyToManyOwnerSideEntityName() != null ? "inverse__" + joinColumns[0].getManyToManyOwnerSideEntityName() : joinColumns[0].getPropertyHolder().getEntityName(), joinColumns[0].getMappedBy())) != null) {
            collValue.setReferencedPropertyName(propRef2);
            mappings.addPropertyReference(collValue.getOwnerEntityName(), propRef2);
        }
        KeyValue keyVal = (propRef = collValue.getReferencedPropertyName()) == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        Ejb3JoinColumn.checkPropertyConsistency(joinColumns, collValue.getOwnerEntityName());
        key.setNullable(joinColumns.length == 0 || joinColumns[0].isNullable());
        key.setUpdateable(joinColumns.length == 0 || joinColumns[0].isUpdatable());
        key.setCascadeDeleteEnabled(cascadeDeleteEnabled);
        collValue.setKey((KeyValue)key);
        return key;
    }

    protected static void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, Ejb3Column[] elementColumns, boolean isEmbedded, String collType, FetchMode fetchMode, boolean ignoreNotFound, boolean unique, boolean cascadeDeleteEnabled, TableBinder associationTableBinder, AnnotatedElement annotatedElt, ExtendedMappings mappings) throws MappingException {
        boolean mappedBy;
        boolean isCollectionOfEntities;
        PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(collType);
        boolean bl = isCollectionOfEntities = collectionEntity != null;
        if (log.isDebugEnabled()) {
            String path = collValue.getOwnerEntityName() + "." + joinColumns[0].getPropertyName();
            if (isCollectionOfEntities && unique) {
                log.debug((Object)("Binding a OneToMany: " + path + " through an association table"));
            } else if (isCollectionOfEntities) {
                log.debug((Object)("Binding as ManyToMany: " + path));
            } else {
                log.debug((Object)("Binding a collection of element: " + path));
            }
        }
        boolean bl2 = mappedBy = !AnnotationBinder.isDefault(joinColumns[0].getMappedBy());
        if (mappedBy) {
            Property otherSideProperty;
            if (!isCollectionOfEntities) {
                StringBuilder error = new StringBuilder(80).append("Collection of elements must not have mappedBy or association reference an unmapped entity: ").append(collValue.getOwnerEntityName()).append(".").append(joinColumns[0].getPropertyName());
                throw new AnnotationException(error.toString());
            }
            try {
                otherSideProperty = collectionEntity.getProperty(joinColumns[0].getMappedBy());
            }
            catch (MappingException e) {
                StringBuilder error = new StringBuilder(80);
                error.append("mappedBy reference an unknown property: ").append(collType).append(".").append(joinColumns[0].getMappedBy()).append(" in ").append(collValue.getOwnerEntityName()).append(".").append(joinColumns[0].getPropertyName());
                throw new AnnotationException(error.toString());
            }
            Table table = ((org.hibernate.mapping.Collection)otherSideProperty.getValue()).getCollectionTable();
            collValue.setCollectionTable(table);
            String entityName = collectionEntity.getEntityName();
            for (Ejb3JoinColumn ejb3JoinColumn : joinColumns) {
                ejb3JoinColumn.setManyToManyOwnerSideEntityName(entityName);
            }
        } else {
            for (Ejb3JoinColumn column : joinColumns) {
                String mappedByProperty = mappings.getFromMappedBy(collValue.getOwnerEntityName(), column.getPropertyName());
                column.setMappedByPropertyName(mappedByProperty);
                Table ownerTable = collValue.getOwner().getTable();
                column.setMappedByTableName(mappings.getLogicalTableName(ownerTable));
            }
            if (StringHelper.isEmpty((String)associationTableBinder.getName())) {
                associationTableBinder.setDefaultName(mappings.getLogicalTableName(collValue.getOwner().getTable()), collectionEntity != null ? mappings.getLogicalTableName(collectionEntity.getTable()) : null, joinColumns[0].getPropertyName());
            }
            collValue.setCollectionTable(associationTableBinder.bind());
        }
        CollectionBinder.bindCollectionSecondPass(collValue, collectionEntity, joinColumns, cascadeDeleteEnabled, mappings);
        ManyToOne element = null;
        if (isCollectionOfEntities) {
            element = new ManyToOne(collValue.getCollectionTable());
            collValue.setElement((Value)element);
            element.setReferencedEntityName(collType);
            element.setFetchMode(FetchMode.JOIN);
            element.setLazy(false);
            element.setIgnoreNotFound(ignoreNotFound);
        } else {
            Class elementClass;
            AnnotatedClassType classType;
            PropertyHolder holder = PropertyHolderBuilder.buildPropertyHolder(collValue, collValue.getRole());
            Map<String, javax.persistence.Column[]> columnOverrides = PropertyHolderBuilder.buildColumnOverride(annotatedElt, StringHelper.qualify((String)holder.getPath(), (String)"element"));
            if (BinderHelper.PRIMITIVE_NAMES.contains(collType)) {
                classType = AnnotatedClassType.NONE;
                elementClass = null;
            } else {
                try {
                    elementClass = ReflectHelper.classForName((String)collType, CollectionBinder.class);
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Unable to find class: " + collType, e);
                }
                classType = mappings.getClassType(elementClass);
                if (isEmbedded || columnOverrides != null && !columnOverrides.isEmpty()) {
                    classType = AnnotatedClassType.EMBEDDABLE;
                }
            }
            if (AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
                EntityBinder entityBinder = new EntityBinder();
                Embeddable embeddable = elementClass.getAnnotation(Embeddable.class);
                boolean propertyAccess = embeddable == null || AccessType.PROPERTY.equals((Object)embeddable.access());
                PropertyInferredData inferredData = new PropertyInferredData("property", "element", elementClass);
                Component component = AnnotationBinder.fillComponent(holder, inferredData, propertyAccess, true, entityBinder, false, columnOverrides, mappings);
                collValue.setElement((Value)component);
            } else {
                SimpleValueBinder elementBinder = new SimpleValueBinder();
                elementBinder.setMappings(mappings);
                elementBinder.setReturnedClassName(collType);
                if (elementColumns == null || elementColumns.length == 0) {
                    elementColumns = new Ejb3Column[1];
                    Ejb3Column ejb3Column = new Ejb3Column();
                    ejb3Column.setImplicit(false);
                    ejb3Column.setNullable(true);
                    ejb3Column.setLength(255);
                    ejb3Column.setLogicalColumnName("elt");
                    ejb3Column.setJoins(new HashMap<String, Join>());
                    ejb3Column.setMappings(mappings);
                    ejb3Column.bind();
                    elementColumns[0] = ejb3Column;
                }
                for (Ejb3Column column : elementColumns) {
                    column.setTable(collValue.getCollectionTable());
                }
                elementBinder.setColumns(elementColumns);
                elementBinder.setType(annotatedElt, elementClass);
                collValue.setElement((Value)elementBinder.make());
            }
        }
        CollectionBinder.checkFilterConditions(collValue);
        if (isCollectionOfEntities) {
            CollectionBinder.bindManytoManyInverseFk(collectionEntity, inverseJoinColumns, (SimpleValue)element, unique, mappings);
        }
    }

    private static void checkFilterConditions(org.hibernate.mapping.Collection collValue) {
        if ((collValue.getFilterMap().size() != 0 || StringHelper.isNotEmpty((String)collValue.getWhere())) && collValue.getFetchMode() == FetchMode.JOIN && collValue.getElement().getFetchMode() != FetchMode.JOIN) {
            throw new MappingException("@ManyToMany defining filter or where without join fetching not valid within collection using join fetching[" + collValue.getRole() + "]");
        }
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, PersistentClass collectionEntity, Ejb3JoinColumn[] joinColumns, boolean cascadeDeleteEnabled, ExtendedMappings mappings) {
        BinderHelper.createSyntheticPropertyReference(joinColumns, collValue.getOwner(), collectionEntity, (Value)collValue, false, mappings);
        SimpleValue key = CollectionBinder.buildCollectionKey(collValue, joinColumns, cascadeDeleteEnabled, mappings);
        TableBinder.bindFk(collValue.getOwner(), collectionEntity, joinColumns, key, false, mappings);
    }

    public void setCascadeDeleteEnabled(boolean onDeleteCascade) {
        this.cascadeDeleteEnabled = onDeleteCascade;
    }

    private String safeCollectionRole() {
        if (this.propertyHolder != null) {
            return this.propertyHolder.getEntityName() + "." + this.propertyName;
        }
        return "";
    }

    public static void bindManytoManyInverseFk(PersistentClass referencedEntity, Ejb3JoinColumn[] columns, SimpleValue value, boolean unique, ExtendedMappings mappings) {
        String mappedBy = columns[0].getMappedBy();
        if (StringHelper.isNotEmpty((String)mappedBy)) {
            Property property = referencedEntity.getProperty(mappedBy);
            Iterator mappedByColumns = ((org.hibernate.mapping.Collection)property.getValue()).getKey().getColumnIterator();
            while (mappedByColumns.hasNext()) {
                Column column = (Column)mappedByColumns.next();
                columns[0].linkValueUsingAColumnCopy(column, value);
            }
            String referencedPropertyName = mappings.getPropertyReferencedAssociation("inverse__" + referencedEntity.getEntityName(), mappedBy);
            if (referencedPropertyName != null) {
                ((ManyToOne)value).setReferencedPropertyName(referencedPropertyName);
                mappings.addUniquePropertyReference(referencedEntity.getEntityName(), referencedPropertyName);
            }
            value.createForeignKey();
        } else {
            BinderHelper.createSyntheticPropertyReference(columns, referencedEntity, null, (Value)value, true, mappings);
            TableBinder.bindFk(referencedEntity, null, columns, value, unique, mappings);
        }
    }

    public void setFkJoinColumns(Ejb3JoinColumn[] ejb3JoinColumns) {
        this.fkJoinColumns = ejb3JoinColumns;
    }

    public void setExplicitAssociationTable(boolean explicitAssocTable) {
        this.isExplicitAssociationTable = explicitAssocTable;
    }

    public void setElementColumns(Ejb3Column[] elementColumns) {
        this.elementColumns = elementColumns;
    }

    public void setEmbedded(boolean annotationPresent) {
        this.isEmbedded = annotationPresent;
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElt) {
        this.annotatedElt = annotatedElt;
    }

    public void setIgnoreNotFound(boolean ignoreNotFound) {
        this.ignoreNotFound = ignoreNotFound;
    }
}

