/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.reflect.AnnotatedElement;
import javax.persistence.AccessType;
import javax.persistence.EmbeddableSuperclass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;

public class InheritanceState {
    public boolean hasSons = false;
    public boolean hasParents = false;
    public boolean hasEmbeddedSuperclass = false;
    public InheritanceType type;
    public boolean isEmbeddableSuperclass = false;
    public Class rootEntity;
    public AccessType accessType = null;

    public void setInheritanceType(AnnotatedElement clazz) {
        Inheritance inhAnn = clazz.getAnnotation(Inheritance.class);
        EmbeddableSuperclass superclassAnn = clazz.getAnnotation(EmbeddableSuperclass.class);
        if (superclassAnn != null) {
            this.isEmbeddableSuperclass = true;
            this.type = inhAnn == null ? null : inhAnn.strategy();
            this.accessType = superclassAnn.access();
        } else {
            this.type = inhAnn == null ? InheritanceType.SINGLE_TABLE : inhAnn.strategy();
        }
    }

    boolean hasTable() {
        return !this.hasParents || !InheritanceType.SINGLE_TABLE.equals((Object)this.type);
    }

    boolean hasDenormalizedTable() {
        return this.hasParents && InheritanceType.TABLE_PER_CLASS.equals((Object)this.type);
    }
}

