/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

public abstract class ArrayUtil {
    private static int SEED = 23;
    private static int PRIME_NUMER = 37;

    public static int hash(Object[] array) {
        int length = array.length;
        int seed = SEED;
        for (int index = 0; index < length; ++index) {
            seed = ArrayUtil.hash(seed, array[index] == null ? 0 : array[index].hashCode());
        }
        return seed;
    }

    public static int hash(char[] array) {
        int length = array.length;
        int seed = SEED;
        for (int index = 0; index < length; ++index) {
            seed = ArrayUtil.hash(seed, array[index]);
        }
        return seed;
    }

    private static int hash(int seed, int i) {
        return PRIME_NUMER * seed + i;
    }

    public static boolean isEquals(Object[] o1, Object[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        int length = o1.length;
        if (length != o2.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (o1[index].equals(o2[index])) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(char[] o1, char[] o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        int length = o1.length;
        if (length != o2.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (o1[index] == o2[index]) continue;
            return false;
        }
        return true;
    }

    public static boolean isEquals(byte[] b1, byte[] b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        int length = b1.length;
        if (length != b2.length) {
            return false;
        }
        for (int index = 0; index < length; ++index) {
            if (b1[index] == b2[index]) continue;
            return false;
        }
        return true;
    }

    public static int hash(byte[] bytes) {
        int length = bytes.length;
        int seed = SEED;
        for (int index = 0; index < length; ++index) {
            seed = ArrayUtil.hash(seed, bytes[index]);
        }
        return seed;
    }
}

