/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.engine.NamedQueryDefinition;

public abstract class QueryBinder {
    private static Log log = LogFactory.getLog(QueryBinder.class);

    public static void bindQuery(NamedQuery queryAnn, ExtendedMappings mappings) {
        if (queryAnn == null) {
            return;
        }
        NamedQueryDefinition query = new NamedQueryDefinition(queryAnn.queryString(), false, null, null, null, null);
        if (AnnotationBinder.isDefault(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        log.debug((Object)("Named query " + queryAnn.name() + " => " + query.getQueryString()));
        mappings.addQuery(queryAnn.name(), query);
    }

    public static void bindQueries(NamedQueries queriesAnn, ExtendedMappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, mappings);
        }
    }
}

