/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Join;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3DiscriminatorColumn
extends Ejb3Column {
    private static final String DEFAULT_DISCRIMINATOR_COLUMN_NAME = "TYPE";
    private String discriminatorTypeName;

    public Ejb3DiscriminatorColumn(boolean isImplicit, String sqlType, int length, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String secondaryTableName, Map<String, Join> joins, PropertyHolder propertyHolder, String discriminatorTypeName, Mappings mappings) {
        super(isImplicit, sqlType, length, 0, 0, name, nullable, unique, insertable, updatable, secondaryTableName, joins, propertyHolder, mappings);
        this.discriminatorTypeName = discriminatorTypeName;
    }

    public String getDiscriminatorTypeName() {
        return this.discriminatorTypeName;
    }

    public void setDiscriminatorTypeName(String discriminatorTypeName) {
        this.discriminatorTypeName = discriminatorTypeName;
    }

    public static Ejb3DiscriminatorColumn buildDiscriminatorColumn(DiscriminatorType type, DiscriminatorColumn discAnn, ExtendedMappings mappings) {
        boolean overrideDefaultValues;
        String discrSqlType = null;
        String discrColumnName = DEFAULT_DISCRIMINATOR_COLUMN_NAME;
        int discrLength = 255;
        boolean discrNullable = false;
        String discrTypeName = "string";
        boolean bl = overrideDefaultValues = discAnn != null;
        if (overrideDefaultValues) {
            discrSqlType = "".equals(discAnn.columnDefinition()) ? null : discAnn.columnDefinition();
            discrColumnName = "".equals(discAnn.name()) ? DEFAULT_DISCRIMINATOR_COLUMN_NAME : discAnn.name();
            discrNullable = discAnn.nullable();
            if (DiscriminatorType.CHAR.equals((Object)type)) {
                discrTypeName = "character";
            } else if (DiscriminatorType.INTEGER.equals((Object)type)) {
                discrTypeName = "integer";
            } else if (DiscriminatorType.STRING.equals((Object)type) || type == null) {
                discrLength = discAnn.length();
                discrTypeName = "string";
            } else {
                throw new AssertionFailure("Unknown discriminator type: " + type);
            }
        }
        Ejb3DiscriminatorColumn discriminatorColumn = new Ejb3DiscriminatorColumn(!overrideDefaultValues, discrSqlType, discrLength, discrColumnName, discrNullable, false, false, false, null, null, null, discrTypeName, mappings);
        return discriminatorColumn;
    }
}

