/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Collection;

public class CollectionSecondPass
extends SecondPass {
    Ejb3JoinColumn[] keyColumns;
    Ejb3JoinColumn[] inverseColumns;
    String collType;
    FetchMode fetchMode;
    boolean unique;

    public CollectionSecondPass(ExtendedMappings mappings, Collection coll, Ejb3JoinColumn[] keyColumns) {
        super(mappings, coll);
        this.keyColumns = keyColumns;
    }

    public CollectionSecondPass(ExtendedMappings mappings, Collection coll, Ejb3JoinColumn[] keyColumns, Ejb3JoinColumn[] inverseColumns, String collType, FetchMode fetchMode, boolean unique) {
        super(mappings, coll);
        this.keyColumns = keyColumns;
        this.inverseColumns = inverseColumns;
        this.collType = collType;
        this.fetchMode = fetchMode;
        this.unique = unique;
    }

    void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        if (this.hasAssociationTable()) {
            AnnotationBinder.bindManyToManySecondPass(this.collection, persistentClasses, this.keyColumns, this.inverseColumns, this.collType, this.fetchMode, this.unique, (ExtendedMappings)this.mappings);
        } else {
            AnnotationBinder.bindCollectionSecondPass(this.collection, persistentClasses, this.keyColumns, (ExtendedMappings)this.mappings);
        }
    }

    private boolean hasAssociationTable() {
        return this.inverseColumns != null;
    }
}

