/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.HbmBinder;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.UniqueKey;
import org.hibernate.util.ReflectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationConfiguration
extends Configuration {
    private static Log log = LogFactory.getLog(AnnotationConfiguration.class);
    private Map namedGenerators;
    private Map<String, Map<String, Join>> joins;
    private Map<Class, AnnotatedClassType> classTypes;
    private Map<String, Properties> generatorTables;
    private Map<Table, List<String[]>> tableUniqueConstraints;
    private Map<String, String> mappedByResolver;

    public AnnotationConfiguration addAnnotatedClasses(List<Class> classes) {
        ArrayList<Class> copy = new ArrayList<Class>(classes);
        ArrayList<Class> newList = new ArrayList<Class>();
        while (copy.size() > 0) {
            Class clazz = (Class)copy.get(0);
            this.orderHierarchy(copy, newList, classes, clazz);
        }
        for (Class clazz : newList) {
            this.addAnnotatedClass(clazz);
        }
        return this;
    }

    protected void orderHierarchy(List<Class> copy, List<Class> newList, List<Class> original, Class clazz) {
        if (clazz.equals(Object.class)) {
            return;
        }
        this.orderHierarchy(copy, newList, original, clazz.getSuperclass());
        if (original.contains(clazz)) {
            if (!newList.contains(clazz)) {
                newList.add(clazz);
            }
            copy.remove(clazz);
        }
    }

    public AnnotationConfiguration addAnnotatedClass(Class persistentClass) throws MappingException {
        log.info((Object)("Mapping class using metadata: " + persistentClass.getName()));
        try {
            AnnotationBinder.bindClass(persistentClass, this.createExtendedMappings());
            return this;
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public AnnotationConfiguration addPackage(String packageName) throws MappingException {
        log.info((Object)("Mapping package " + packageName));
        try {
            AnnotationBinder.bindPackage(packageName, this.createExtendedMappings());
            return this;
        }
        catch (MappingException me) {
            log.error((Object)"Could not compile the mapping annotations", (Throwable)me);
            throw me;
        }
    }

    public ExtendedMappings createExtendedMappings() {
        return new ExtendedMappings(this.classes, this.collections, this.tables, this.namedQueries, this.namedSqlQueries, this.imports, this.secondPasses, this.propertyReferences, this.namingStrategy, this.typeDefs, this.filterDefinitions, this.namedGenerators, this.joins, this.classTypes, this.extendsQueue, this.generatorTables, this.tableUniqueConstraints, this.mappedByResolver);
    }

    protected void reset() {
        super.reset();
        this.namedGenerators = new HashMap();
        this.joins = new HashMap<String, Map<String, Join>>();
        this.classTypes = new HashMap<Class, AnnotatedClassType>();
        this.generatorTables = new HashMap<String, Properties>();
        this.tableUniqueConstraints = new HashMap<Table, List<String[]>>();
        this.mappedByResolver = new HashMap<String, String>();
    }

    protected void secondPassCompile() throws MappingException {
        log.debug((Object)"processing manytoone fk mappings");
        Iterator iter = this.secondPasses.iterator();
        while (iter.hasNext()) {
            HbmBinder.SecondPass sp = (HbmBinder.SecondPass)iter.next();
            if (!(sp instanceof FkSecondPass)) continue;
            sp.doSecondPass(this.classes, Collections.EMPTY_MAP);
            iter.remove();
        }
        super.secondPassCompile();
        for (Map.Entry<Table, List<String[]>> entry : this.tableUniqueConstraints.entrySet()) {
            Table table = entry.getKey();
            List<String[]> uniqueConstraints = entry.getValue();
            int uniqueIndexPerTable = 0;
            for (String[] columnNames : uniqueConstraints) {
                String keyName = "key" + uniqueIndexPerTable++;
                this.buildUniqueKeyFromColumnNames(columnNames, table, keyName);
            }
        }
    }

    private void buildUniqueKeyFromColumnNames(String[] columnNames, Table table, String keyName) {
        HashSet<String> preparedColumnNames = new HashSet<String>();
        for (String columnName : columnNames) {
            preparedColumnNames.add(columnName);
        }
        Iterator columns = table.getColumnIterator();
        while (columns.hasNext()) {
            Column column = (Column)columns.next();
            if (!preparedColumnNames.contains(column.getName())) continue;
            UniqueKey uc = table.getOrCreateUniqueKey(keyName);
            uc.addColumn(column);
        }
    }

    protected void parseMappingElement(Element subelement, String name) {
        Attribute rsrc = subelement.attribute("resource");
        Attribute file = subelement.attribute("file");
        Attribute jar = subelement.attribute("jar");
        Attribute pckg = subelement.attribute("package");
        Attribute clazz = subelement.attribute("class");
        if (rsrc != null) {
            log.debug((Object)(name + "<-" + rsrc));
            this.addResource(rsrc.getValue());
        } else if (jar != null) {
            log.debug((Object)(name + "<-" + jar));
            this.addJar(new File(jar.getValue()));
        } else if (file != null) {
            log.debug((Object)(name + "<-" + file));
            this.addFile(file.getValue());
        } else if (pckg != null) {
            log.debug((Object)(name + "<-" + pckg));
            this.addPackage(pckg.getValue());
        } else if (clazz != null) {
            log.debug((Object)(name + "<-" + clazz));
            Class loadedClass = null;
            try {
                loadedClass = ReflectHelper.classForName((String)clazz.getValue());
            }
            catch (ClassNotFoundException cnf) {
                throw new MappingException("Unable to load class declared as <mapping class=\"" + clazz.getValue() + "\"/> in the configuration:", (Throwable)cnf);
            }
            this.addAnnotatedClass(loadedClass);
        } else {
            throw new MappingException("<mapping> element in configuration specifies no attributes");
        }
    }
}

