/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.persistence.AccessType;
import javax.persistence.AssociationTable;
import javax.persistence.AttributeOverride;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedIdTable;
import javax.persistence.GeneratorType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceJoinColumn;
import javax.persistence.InheritanceJoinColumns;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.Lob;
import javax.persistence.LobType;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.Serialized;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.TypeDef;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.ByteArrayBlobType;
import org.hibernate.type.CharacterArrayClobType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.PrimitiveByteArrayBlobType;
import org.hibernate.type.PrimitiveCharacterArrayClobType;
import org.hibernate.type.StringClobType;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final String GENERATOR_TABLE_NAME_PARAM = "generatorTableName";
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        SequenceGenerator ann;
        Package pckg = null;
        try {
            pckg = ReflectHelper.classForName((String)(packageName + ".package-info")).getPackage();
        }
        catch (ClassNotFoundException cnf) {
            log.warn((Object)("Package not found or wo package-info.java: " + packageName));
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add table generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(GeneratedIdTable.class)) {
            ann = pckg.getAnnotation(GeneratedIdTable.class);
            Properties params = AnnotationBinder.buildPropertiesFromGeneratorTable((GeneratedIdTable)ann);
            mappings.addGeneratorTable(ann.name(), params);
        }
        AnnotationBinder.bindQueries(pckg, mappings);
        AnnotationBinder.bindFilterDefs(pckg, mappings);
        AnnotationBinder.bindTypeDefs(pckg, mappings);
    }

    private static void bindQueries(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        NamedQuery ann = annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery(ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings);
    }

    private static Properties buildPropertiesFromGeneratorTable(GeneratedIdTable ann) {
        Properties params = new Properties();
        if (!AnnotationBinder.isDefault(ann.pkColumnName())) {
            params.setProperty("primary_key_column", ann.pkColumnName());
        }
        if (!AnnotationBinder.isDefault(ann.valueColumnName())) {
            params.setProperty("value_column", ann.valueColumnName());
        }
        if (ann.table().specified()) {
            Table table = ann.table();
            if (!AnnotationBinder.isDefault(table.name())) {
                params.setProperty("table", table.name());
            }
            if (!AnnotationBinder.isDefault(table.catalog())) {
                params.setProperty("catalog", table.catalog());
            }
            if (!AnnotationBinder.isDefault(table.schema())) {
                params.setProperty("schema", table.schema());
            }
        } else {
            params.setProperty("table", ann.name());
        }
        return params;
    }

    private static IdGenerator buildIdGenerator(Annotation ann) {
        IdGenerator idGen = new IdGenerator();
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!AnnotationBinder.isDefault(tabGen.tableName())) {
                idGen.addParam(GENERATOR_TABLE_NAME_PARAM, tabGen.tableName());
            }
            if (!AnnotationBinder.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize()));
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("sequence");
            if (!AnnotationBinder.isDefault(seqGen.sequenceName())) {
                idGen.addParam("sequence", seqGen.sequenceName());
            }
            if (seqGen.initialValue() != 0 || seqGen.allocationSize() != 50) {
                log.warn((Object)"Hibernate does not support SequenceGenerator.initialValue() nor SequenceGenerator.allocationSize()");
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(Class annotatedClass, ExtendedMappings mappings) throws MappingException {
        Filters filtersAnn;
        if (!mappings.getClassType(annotatedClass).equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have an @Entity annotation: " + annotatedClass.getName());
        }
        AnnotationBinder.bindQueries(annotatedClass, mappings);
        AnnotationBinder.bindFilterDefs(annotatedClass, mappings);
        AnnotationBinder.bindTypeDefs(annotatedClass, mappings);
        Class superClass = annotatedClass.getSuperclass();
        PersistentClass superEntity = mappings.getClass(superClass.getName());
        if (superEntity == null && mappings.getClassType(superClass).equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Subclass has to be binded after it's mother class: " + superClass.getName());
        }
        boolean isRootClass = superEntity == null;
        boolean isSubClass = false;
        boolean isJoinedSubclass = false;
        String schema = ANNOTATION_STRING_DEFAULT;
        String table = ANNOTATION_STRING_DEFAULT;
        String catalog = ANNOTATION_STRING_DEFAULT;
        String discrimValue = null;
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>();
        if (annotatedClass.isAnnotationPresent(Table.class)) {
            Table tabAnn = annotatedClass.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            if (tabAnn.uniqueConstraints().length != 0) {
                for (UniqueConstraint uc : tabAnn.uniqueConstraints()) {
                    if (!uc.primary()) {
                        uniqueConstraints.add(uc.columnNames());
                        continue;
                    }
                    log.warn((Object)"@UniqueConstraint(primaryKey=true) not yet supported");
                }
            }
        }
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        boolean singleTableStrategy = true;
        Ejb3JoinColumn[] joinedColumns = null;
        if (annotatedClass.isAnnotationPresent(Inheritance.class)) {
            Inheritance inhAnn = annotatedClass.getAnnotation(Inheritance.class);
            if (inhAnn.strategy().equals((Object)InheritanceType.TABLE_PER_CLASS)) {
                singleTableStrategy = false;
                if (!isRootClass) {
                    throw new AnnotationException("TABLE_PER_CLASS only allows hierarchy leaf mapping");
                }
            }
            if (inhAnn.strategy().equals((Object)InheritanceType.JOINED)) {
                singleTableStrategy = false;
                boolean bl = isJoinedSubclass = !isRootClass;
                if (isJoinedSubclass) {
                    boolean explicitInheritanceJoinedColumns;
                    InheritanceJoinColumns jcsAnn = annotatedClass.getAnnotation(InheritanceJoinColumns.class);
                    boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
                    if (explicitInheritanceJoinedColumns) {
                        int nbrOfInhJoinedColumns = jcsAnn.value().length;
                        joinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                        for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                            InheritanceJoinColumn jcAnn = jcsAnn.value()[colIndex];
                            joinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings);
                        }
                    } else {
                        InheritanceJoinColumn jcAnn = annotatedClass.getAnnotation(InheritanceJoinColumn.class);
                        joinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings)};
                    }
                    log.debug((Object)"Joined column(s) created");
                }
            }
            if (inhAnn.strategy().equals((Object)InheritanceType.SINGLE_TABLE)) {
                singleTableStrategy = true;
                if (annotatedClass.isAnnotationPresent(DiscriminatorColumn.class)) {
                    DiscriminatorColumn discAnn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
                    if (isRootClass) {
                        discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(inhAnn.discriminatorType(), discAnn, mappings);
                    } else {
                        log.warn((Object)"Discriminator should not be defined in a subclass, annotation ignored");
                    }
                }
                discrimValue = inhAnn.discriminatorValue();
            }
        }
        boolean bl = isSubClass = !isRootClass && singleTableStrategy;
        Object persistentClass = isRootClass ? new RootClass() : (isSubClass ? new Subclass(superEntity) : new JoinedSubclass(superEntity));
        Proxy proxyAnn = annotatedClass.getAnnotation(Proxy.class);
        BatchSize sizeAnn = annotatedClass.getAnnotation(BatchSize.class);
        Where whereAnn = annotatedClass.getAnnotation(Where.class);
        Entity entityAnn = annotatedClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
        Cache cacheAnn = annotatedClass.getAnnotation(Cache.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, annotatedClass, (PersistentClass)persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.setCache(cacheAnn);
        Filter filterAnn = annotatedClass.getAnnotation(Filter.class);
        if (filterAnn != null) {
            entityBinder.addFilter(filterAnn.name(), filterAnn.condition());
        }
        if ((filtersAnn = annotatedClass.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter.name(), filter.condition());
            }
        }
        entityBinder.bindEntity();
        if (!isSubClass) {
            Check checkAnn = annotatedClass.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints);
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder((PersistentClass)persistentClass);
        SecondaryTable secTabAnn = annotatedClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = annotatedClass.getAnnotation(SecondaryTables.class);
        JoinColumn joinColAnn = annotatedClass.getAnnotation(JoinColumn.class);
        JoinColumns joinColsAnn = annotatedClass.getAnnotation(JoinColumns.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn, joinColAnn, joinColsAnn);
        if (isJoinedSubclass) {
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey((KeyValue)key);
            key.setCascadeDeleteEnabled(false);
            TableBinder.bindFk((PersistentClass)jsc, null, joinedColumns, (SimpleValue)key, false);
            jsc.createPrimaryKey();
            jsc.createForeignKey();
        } else if (isSubClass) {
            boolean uninilializedDiscrim;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
            }
            boolean bl3 = uninilializedDiscrim = persistentClass.getRootClass().getDiscriminator() == null;
            if (uninilializedDiscrim) {
                AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass.getRootClass(), null, entityBinder.getSecondaryTables(), propertyHolder, mappings);
            }
        } else if (singleTableStrategy && isRootClass && discriminatorColumn != null) {
            AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder, mappings);
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(annotatedClass);
        HashMap<String, Properties> classGeneratorTables = AnnotationBinder.buildLocalGeneratorTable(annotatedClass);
        if (annotatedClass.isAnnotationPresent(IdClass.class)) {
            throw new NotYetImplementedException("@IdClass is not yet implemented");
        }
        Class currentClassInHierarchy = annotatedClass;
        do {
            AnnotationBinder.processElementsOfAClass(propertyHolder, entityBinder.isPropertyAccess(), true, currentClassInHierarchy, classGenerators, classGeneratorTables, entityBinder, mappings);
            currentClassInHierarchy = currentClassInHierarchy.getSuperclass();
        } while (isRootClass && !Object.class.equals(currentClassInHierarchy));
        if (isRootClass) {
            persistentClass.createPrimaryKey();
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass((PersistentClass)persistentClass);
        entityBinder.finalSecondaryTableBinding(propertyHolder);
    }

    private static void bindFilterDefs(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        FilterDef defAnn = annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, ExtendedMappings mappings) {
        FilterDefinition def = new FilterDefinition(defAnn.name());
        for (ParamDef param : defAnn.parameters()) {
            TypeFactory.heuristicType((String)param.type());
            def.addParameterType(param.name(), TypeFactory.heuristicType((String)param.type()));
        }
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(AnnotatedElement annotatedElement, ExtendedMappings mappings) {
        org.hibernate.annotations.TypeDef defAnn = annotatedElement.getAnnotation(org.hibernate.annotations.TypeDef.class);
        TypeDefs defsAnn = annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (org.hibernate.annotations.TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindTypeDef(org.hibernate.annotations.TypeDef defAnn, ExtendedMappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
    }

    private static HashMap<String, Properties> buildLocalGeneratorTable(AnnotatedElement annotatedClass) {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        GeneratedIdTable ann = annotatedClass.getAnnotation(GeneratedIdTable.class);
        if (ann != null) {
            result.put(ann.name(), AnnotationBinder.buildPropertiesFromGeneratorTable(ann));
        }
        return result;
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName((String)rootClass.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Root Class not found in classpath: " + rootClass.getClassName());
                }
                Inheritance inhAnn = clazz.getAnnotation(Inheritance.class);
                DiscriminatorType type = inhAnn == null ? null : inhAnn.discriminatorType();
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(type, null, mappings);
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator((Value)discrim);
            Column col = discriminatorColumn.getMappingColumn();
            col.setValue((Value)discrim);
            discrim.getTable().addColumn(col);
            discrim.addColumn(col);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug((Object)("Setting discriminator for entity " + rootClass.getEntityName()));
        }
    }

    private static void processElementsOfAClass(PropertyHolder propertyHolder, boolean propertyAccess, boolean isNullable, Class annotatedClass, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, EntityBinder entityBinder, ExtendedMappings mappings) {
        AccessibleObject currentElt;
        int index;
        ArrayList<AnnotatedElement> annElts = new ArrayList<AnnotatedElement>();
        ArrayList<AnnotedElementInferredData> inferredDatas = new ArrayList<AnnotedElementInferredData>();
        if (propertyAccess) {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per property access"));
            Method[] methods = annotatedClass.getDeclaredMethods();
            for (index = 0; index < methods.length; ++index) {
                currentElt = methods[index];
                AnnotationBinder.addAnnotatedElement(currentElt, annElts, inferredDatas);
            }
        } else {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per field access"));
            Field[] fields = annotatedClass.getDeclaredFields();
            for (index = 0; index < fields.length; ++index) {
                currentElt = fields[index];
                AnnotationBinder.addAnnotatedElement(currentElt, annElts, inferredDatas);
            }
        }
        int size = annElts.size();
        for (int index2 = 0; index2 < size; ++index2) {
            AnnotationBinder.processElementAnnotations(propertyHolder, isNullable, annElts.get(index2), mappings, inferredDatas.get(index2), classGenerators, classGeneratorTables, entityBinder);
        }
    }

    private static void addAnnotatedElement(AnnotatedElement elt, ArrayList<AnnotatedElement> annElts, ArrayList<AnnotedElementInferredData> inferredDatas) {
        AnnotedElementInferredData inferredData = new AnnotedElementInferredData(elt);
        if (inferredData.isAnnotable()) {
            if (elt.isAnnotationPresent(Id.class) || elt.isAnnotationPresent(EmbeddedId.class)) {
                annElts.add(0, elt);
                inferredDatas.add(0, inferredData);
            } else {
                annElts.add(elt);
                inferredDatas.add(inferredData);
            }
        }
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, boolean isNullable, AnnotatedElement annotedElt, ExtendedMappings mappings, AnnotedElementInferredData inferredData, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, EntityBinder entityBinder) throws MappingException {
        Cache cacheAnn;
        javax.persistence.Column ann;
        Ejb3Column[] columns = null;
        if (annotedElt.isAnnotationPresent(Transient.class)) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing annotations of " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName()));
        }
        if (annotedElt.isAnnotationPresent(javax.persistence.Column.class)) {
            ann = annotedElt.getAnnotation(javax.persistence.Column.class);
            columns = Ejb3Column.buildColumnFromAnnotation(ann, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        } else if (annotedElt.isAnnotationPresent(JoinColumn.class)) {
            ann = annotedElt.getAnnotation(JoinColumn.class);
            columns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)ann, null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings)};
        } else if (annotedElt.isAnnotationPresent(JoinColumns.class)) {
            ann = annotedElt.getAnnotation(JoinColumns.class);
            JoinColumn[] annColumns = ann.value();
            int length = annColumns.length;
            if (length == 0) {
                throw new AnnotationException("Cannot bind an empty @JoinColumns");
            }
            columns = new Ejb3JoinColumn[length];
            for (int index = 0; index < length; ++index) {
                columns[index] = Ejb3JoinColumn.buildJoinColumn(annColumns[index], null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
            }
        } else if (annotedElt.isAnnotationPresent(javax.persistence.ManyToOne.class) || annotedElt.isAnnotationPresent(OneToOne.class)) {
            columns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildImplicitJoinColumn(null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings)};
        } else if (annotedElt.isAnnotationPresent(OneToMany.class)) {
            columns = new Ejb3JoinColumn[1];
            String mappedBy = annotedElt.getAnnotation(OneToMany.class).mappedBy();
            columns[0] = Ejb3JoinColumn.buildImplicitJoinColumn(mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        } else {
            columns = Ejb3Column.buildColumnFromAnnotation(null, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        }
        if (!isNullable) {
            for (Ejb3Column col : columns) {
                col.forceNotNull();
            }
        }
        if (annotedElt.isAnnotationPresent(Id.class) || annotedElt.isAnnotationPresent(EmbeddedId.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is an id"));
            Id idAnn = annotedElt.getAnnotation(Id.class);
            EmbeddedId embeddedId = annotedElt.getAnnotation(EmbeddedId.class);
            HashMap localGenerators = (HashMap)classGenerators.clone();
            HashMap localGeneratorTables = (HashMap)classGeneratorTables.clone();
            localGenerators.putAll(AnnotationBinder.buildLocalGenerators(annotedElt));
            localGeneratorTables.putAll(AnnotationBinder.buildLocalGeneratorTable(annotedElt));
            Embeddable embeddableAnn = inferredData.getReturnedClass().getAnnotation(Embeddable.class);
            Embedded overrideAnn = annotedElt.getAnnotation(Embedded.class);
            HashMap<String, javax.persistence.Column[]> columnOverride = new HashMap<String, javax.persistence.Column[]>();
            AttributeOverride[] overrides = null;
            overrides = overrideAnn != null ? overrideAnn.value() : null;
            AttributeOverride[] attributeOverrideArray = overrides = embeddedId != null ? embeddedId.value() : null;
            if (overrides != null) {
                for (AttributeOverride depAttr : overrides) {
                    columnOverride.put(depAttr.name(), depAttr.column());
                }
            }
            boolean isComponent = embeddableAnn != null || overrideAnn != null || embeddedId != null;
            boolean propertyAccess = true;
            if (isComponent && embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                propertyAccess = false;
            }
            String generatorType = idAnn != null ? AnnotationBinder.generatorType(idAnn.generate()) : "assigned";
            String generator = idAnn != null ? idAnn.generator() : ANNOTATION_STRING_DEFAULT;
            AnnotationBinder.bindId(generatorType, generator, inferredData, columns[0], (RootClass)propertyHolder.getPersistentClass(), localGenerators, localGeneratorTables, isComponent, columnOverride, propertyAccess, entityBinder, mappings);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bind " + (isComponent ? "@Id" : "@EmbeddedId") + " on " + inferredData.getPropertyName()));
            }
        } else if (annotedElt.isAnnotationPresent(Version.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is a version property"));
            RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
            boolean lazy = false;
            Property prop = AnnotationBinder.bindProperty(inferredData.getPropertyName(), inferredData.getReturnedClassName(), lazy, inferredData.getDefaultAccess(), columns[0], PropertyHolderBuilder.buildPropertyHolder((PersistentClass)rootClass), ANNOTATION_STRING_DEFAULT, new Properties(), mappings);
            rootClass.setVersion(prop);
            SimpleValue simpleValue = (SimpleValue)prop.getValue();
            if (!simpleValue.isTypeSpecified()) {
                simpleValue.setTypeName("integer");
            }
            simpleValue.setNullValue("undefined");
            rootClass.setOptimisticLockMode(0);
            log.debug((Object)("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue()));
        } else if (annotedElt.isAnnotationPresent(javax.persistence.ManyToOne.class)) {
            ann = annotedElt.getAnnotation(javax.persistence.ManyToOne.class);
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann.cascade()), (Ejb3JoinColumn[])columns, ann.optional(), AnnotationBinder.getFetchMode(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, false, mappings);
        } else if (annotedElt.isAnnotationPresent(OneToOne.class)) {
            ann = annotedElt.getAnnotation(OneToOne.class);
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann.cascade()), (Ejb3JoinColumn[])columns, ann.optional(), AnnotationBinder.getFetchMode(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, ann.mappedBy(), ann.usePKasFK(), mappings);
        } else if (annotedElt.isAnnotationPresent(OneToMany.class)) {
            boolean isForeignKey;
            ann = annotedElt.getAnnotation(OneToMany.class);
            cacheAnn = annotedElt.getAnnotation(Cache.class);
            String cacheConcurrencyStrategy = null;
            String cacheRegionName = null;
            if (cacheAnn != null) {
                cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
                cacheRegionName = cacheAnn.region();
            }
            Ejb3JoinColumn.checkIfJoinColumn(columns, propertyHolder, inferredData);
            AssociationTable assocTable = annotedElt.getAnnotation(AssociationTable.class);
            boolean bl = isForeignKey = assocTable == null && (columns[0].isImplicit() && !AnnotationBinder.isDefault(ann.mappedBy()) || !columns[0].isImplicit());
            if (isForeignKey) {
                AnnotationBinder.bindOneToMany(inferredData.getCollectionType(), ann.targetEntity(), inferredData.getPropertyName(), inferredData.getReturnedClass(), AnnotationBinder.getFetchMode(ann.fetch()), (Ejb3JoinColumn[])columns, AnnotationBinder.getCascadeStrategy(ann.cascade()), inferredData.getDefaultAccess(), propertyHolder, AnnotationBinder.bindBatchSize(annotedElt), AnnotationBinder.bindWhere(annotedElt), !AnnotationBinder.isDefault(ann.mappedBy()), cacheConcurrencyStrategy, cacheRegionName, AnnotationBinder.bindFilters(annotedElt), mappings);
            } else {
                AnnotationBinder.bindJoinedTableAssociation(assocTable, mappings, entityBinder, propertyHolder, inferredData, ann.mappedBy(), ann.targetEntity(), ann.fetch(), ann.cascade(), annotedElt, true, cacheConcurrencyStrategy, cacheRegionName);
            }
        } else if (annotedElt.isAnnotationPresent(ManyToMany.class)) {
            ManyToMany manyToManyAnn = annotedElt.getAnnotation(ManyToMany.class);
            cacheAnn = annotedElt.getAnnotation(Cache.class);
            String cacheConcurrencyStrategy = null;
            String cacheRegionName = null;
            if (cacheAnn != null) {
                cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
                cacheRegionName = cacheAnn.region();
            }
            AssociationTable associationTableAnn = annotedElt.getAnnotation(AssociationTable.class);
            String mappedBy = manyToManyAnn.mappedBy();
            String targetEntity = manyToManyAnn.targetEntity();
            FetchType fetch = manyToManyAnn.fetch();
            CascadeType[] cascade = manyToManyAnn.cascade();
            AnnotationBinder.bindJoinedTableAssociation(associationTableAnn, mappings, entityBinder, propertyHolder, inferredData, mappedBy, targetEntity, fetch, cascade, annotedElt, false, cacheConcurrencyStrategy, cacheRegionName);
        } else {
            boolean isComponent = false;
            Embeddable embeddableAnn = inferredData.getReturnedClass().getAnnotation(Embeddable.class);
            Embedded embeddedAnn = annotedElt.getAnnotation(Embedded.class);
            if (embeddedAnn != null || embeddableAnn != null) {
                isComponent = true;
            }
            if (isComponent) {
                boolean propertyAccess = true;
                if (embeddableAnn != null && embeddableAnn.access() == AccessType.FIELD) {
                    propertyAccess = false;
                }
                HashMap<String, javax.persistence.Column[]> columnOverride = new HashMap<String, javax.persistence.Column[]>();
                if (embeddedAnn != null) {
                    for (AttributeOverride depAttr : embeddedAnn.value()) {
                        columnOverride.put(depAttr.name(), depAttr.column());
                    }
                }
                AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAccess, entityBinder, columnOverride, mappings);
            } else {
                boolean lazy = false;
                String type = ANNOTATION_STRING_DEFAULT;
                if (annotedElt.isAnnotationPresent(Basic.class)) {
                    Basic ann2 = annotedElt.getAnnotation(Basic.class);
                    lazy = ann2.fetch() == FetchType.LAZY;
                } else if (annotedElt.isAnnotationPresent(Lob.class)) {
                    Lob lob = annotedElt.getAnnotation(Lob.class);
                    lazy = lob.fetch() == FetchType.LAZY;
                    LobType lobType = lob.type();
                    if (LobType.CLOB.equals((Object)lobType)) {
                        type = String.class.equals((Object)inferredData.getReturnedClass()) ? StringClobType.class.getName() : (Character.class.equals((Object)inferredData.getReturnedClass()) && inferredData.isArray() ? CharacterArrayClobType.class.getName() : (Character.TYPE.equals(inferredData.getReturnedClass()) && inferredData.isArray() ? PrimitiveCharacterArrayClobType.class.getName() : "clob"));
                    }
                    if (LobType.BLOB.equals((Object)lobType)) {
                        type = Byte.class.equals((Object)inferredData.getReturnedClass()) && inferredData.isArray() ? ByteArrayBlobType.class.getName() : (Byte.TYPE.equals(inferredData.getReturnedClass()) && inferredData.isArray() ? PrimitiveByteArrayBlobType.class.getName() : "blob");
                    }
                } else if (annotedElt.isAnnotationPresent(Serialized.class)) {
                    Serialized serialized = annotedElt.getAnnotation(Serialized.class);
                    lazy = serialized.fetch() == FetchType.LAZY;
                    type = "serializable";
                } else if (Clob.class.equals((Object)inferredData.getReturnedClass())) {
                    type = "clob";
                } else if (Blob.class.equals((Object)inferredData.getReturnedClass())) {
                    type = "blob";
                }
                Type annType = annotedElt.getAnnotation(Type.class);
                Properties typeParameters = new Properties();
                if (annType != null) {
                    type = annType.type();
                    for (Parameter param : annType.parameters()) {
                        typeParameters.setProperty(param.name(), param.value());
                    }
                }
                AnnotationBinder.bindProperty(inferredData.getPropertyName(), inferredData.getReturnedClassName(), lazy, inferredData.getDefaultAccess(), columns[0], propertyHolder, type, typeParameters, mappings);
            }
        }
    }

    private static void bindJoinedTableAssociation(AssociationTable associationTableAnn, ExtendedMappings mappings, EntityBinder entityBinder, PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, String mappedBy, String targetEntity, FetchType fetch, CascadeType[] cascade, AnnotatedElement annotedElt, boolean unique, String cacheConcurrencyStrategy, String cacheRegionName) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        org.hibernate.mapping.Table assocTable;
        if (associationTableAnn != null) {
            assocTable = !associationTableAnn.table().specified() ? null : TableBinder.fillTable(associationTableAnn.table().schema(), associationTableAnn.table().catalog(), mappings.getNamingStrategy().tableName(associationTableAnn.table().name()), false, new ArrayList(), null, mappings);
            JoinColumn[] joins = associationTableAnn.joinColumns();
            annJoins = joins.length == 0 ? null : joins;
            JoinColumn[] inverseJoins = associationTableAnn.inverseJoinColumns();
            annInverseJoins = inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            assocTable = null;
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = AnnotationBinder.buildArrayOfEjb3JoinColumn(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = AnnotationBinder.buildArrayOfEjb3JoinColumn(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        AnnotationBinder.bindManyToMany(inferredData.getCollectionType(), targetEntity, inferredData.getPropertyName(), inferredData.getReturnedClass(), AnnotationBinder.getFetchMode(fetch), assocTable, AnnotationBinder.getCascadeStrategy(cascade), inferredData.getDefaultAccess(), propertyHolder, mappedBy, joinColumns, inverseJoinColumns, AnnotationBinder.bindBatchSize(annotedElt), AnnotationBinder.bindWhere(annotedElt), unique, cacheConcurrencyStrategy, cacheRegionName, AnnotationBinder.bindFilters(annotedElt), mappings);
    }

    private static String bindWhere(AnnotatedElement annotedElt) {
        Where ann = annotedElt.getAnnotation(Where.class);
        return ann == null ? null : ann.clause();
    }

    private static int bindBatchSize(AnnotatedElement annotedElt) {
        BatchSize batchAnn = annotedElt.getAnnotation(BatchSize.class);
        return batchAnn == null ? -1 : batchAnn.size();
    }

    private static Map<String, String> bindFilters(AnnotatedElement annotedElt) {
        Filter filterAnn = annotedElt.getAnnotation(Filter.class);
        Filters filtersAnn = annotedElt.getAnnotation(Filters.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        if (filterAnn != null) {
            filters.put(filterAnn.name(), filterAnn.condition());
        }
        if (filtersAnn != null) {
            for (Filter filter : filtersAnn.value()) {
                filters.put(filter.name(), filter.condition());
            }
        }
        return filters;
    }

    private static Ejb3JoinColumn[] buildArrayOfEjb3JoinColumn(JoinColumn[] annJoins, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, String propertyName, String mappedBy, ExtendedMappings mappings) {
        Ejb3JoinColumn[] joinColumns;
        if (annJoins == null) {
            joinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildImplicitJoinColumn(mappedBy, secondaryTables, propertyHolder, propertyName, mappings)};
        } else {
            joinColumns = new Ejb3JoinColumn[annJoins.length];
            for (JoinColumn annJoin : annJoins) {
                joinColumns[index] = Ejb3JoinColumn.buildJoinColumn(annJoin, propertyName, secondaryTables, propertyHolder, propertyName, mappings);
            }
        }
        return joinColumns;
    }

    private static void bindComponent(AnnotedElementInferredData inferredData, PropertyHolder propertyHolder, boolean propertyAccess, EntityBinder entityBinder, Map<String, javax.persistence.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccess, true, entityBinder, columnOverride, mappings);
        Property prop = AnnotationBinder.makeProperty(inferredData.getPropertyName(), (Value)comp, true, true, false, null, inferredData.getDefaultAccess());
        propertyHolder.addProperty(prop);
    }

    private static Component fillComponent(PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, boolean propertyAccess, boolean isNullable, EntityBinder entityBinder, Map<String, javax.persistence.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = new Component(propertyHolder.getPersistentClass());
        comp.setComponentClassName(inferredData.getReturnedClassName());
        String subpath = StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName());
        log.debug((Object)("Binding component with path: " + subpath));
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, columnOverride);
        AnnotationBinder.processElementsOfAClass(subHolder, propertyAccess, isNullable, inferredData.getReturnedClass(), new HashMap<String, IdGenerator>(), new HashMap<String, Properties>(), entityBinder, mappings);
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, AnnotedElementInferredData inferredData, Ejb3Column column, RootClass rootClass, Map<String, IdGenerator> localGenerators, HashMap<String, Properties> localGeneratorTables, boolean isComposite, Map<String, javax.persistence.Column[]> columnOverride, boolean isPropertyAccess, EntityBinder entityBinder, ExtendedMappings mappings) {
        Component id;
        String persistentClassName;
        String string = persistentClassName = rootClass == null ? null : rootClass.getClassName();
        if (isComposite) {
            id = AnnotationBinder.fillComponent(PropertyHolderBuilder.buildPropertyHolder((PersistentClass)rootClass), inferredData, isPropertyAccess, false, entityBinder, columnOverride, mappings);
        } else {
            column.forceNotNull();
            id = AnnotationBinder.makeSimpleValue(inferredData.getPropertyName(), inferredData.getReturnedClassName(), column, persistentClassName, ANNOTATION_STRING_DEFAULT, new Properties(), mappings);
        }
        rootClass.setIdentifier((KeyValue)id);
        org.hibernate.mapping.Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generatorType);
        if (generatorType == "assigned") {
            id.setNullValue("undefined");
        }
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        if (!AnnotationBinder.isDefault(generatorName)) {
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            AnnotationBinder.checkIfMatchingGenerator(gen, generatorType, generatorName);
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
            if (MultipleHiLoPerTableGenerator.class.getName().equals(generatorType)) {
                AnnotationBinder.fillGeneratorWithGeneratorTableParams(params, localGeneratorTables, generatorName, mappings);
            }
        }
        id.setIdentifierGeneratorProperties(params);
        Property prop = AnnotationBinder.makeProperty(inferredData.getPropertyName(), (Value)id, true, true, false, null, inferredData.getDefaultAccess());
        rootClass.setIdentifierProperty(prop);
    }

    private static void checkIfMatchingGenerator(IdGenerator gen, String generatorType, String generatorName) {
        boolean matchingGenerator = gen.getIdentifierGeneratorStrategy().equals(generatorType);
        boolean defaultGenerator = AnnotationBinder.generatorType(GeneratorType.AUTO).equals(generatorType);
        if (!matchingGenerator && !defaultGenerator) {
            throw new AnnotationException("Incompatible generator between Id.generate and its named generator: " + generatorType + "!=" + generatorName);
        }
    }

    private static void fillGeneratorWithGeneratorTableParams(Properties params, HashMap<String, Properties> localGeneratorTables, String generatorName, ExtendedMappings mappings) {
        String generatorTableName = params.getProperty(GENERATOR_TABLE_NAME_PARAM);
        Properties props = mappings.getGeneratorTableProperties(generatorTableName, localGeneratorTables);
        if (props == null) {
            if ("hibernate_sequences".equals(generatorTableName)) {
                return;
            }
            throw new AnnotationException("Unable to find a @GeneratedIdTable for table name in " + generatorName + ": " + generatorTableName);
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            params.setProperty((String)property.getKey(), (String)property.getValue());
        }
    }

    private static SimpleValue makeSimpleValue(String propertyName, String returnedClassName, Ejb3Column column, String persistentClassName, String explicitType, Properties typeParameters, Mappings mappings) {
        log.debug((Object)("making simplevalue for " + propertyName));
        org.hibernate.mapping.Table table = column.getTable();
        SimpleValue simpleValue = new SimpleValue(table);
        return AnnotationBinder.fillSimpleValue(simpleValue, propertyName, returnedClassName, column, persistentClassName, explicitType, typeParameters, mappings);
    }

    private static SimpleValue fillSimpleValue(SimpleValue simpleValue, String propertyName, String returnedClassName, Ejb3Column column, String persistentClassName, String explicitType, Properties typeParameters, Mappings mappings) {
        String type = AnnotationBinder.isDefault(explicitType) ? returnedClassName : explicitType;
        TypeDef typeDef = mappings.getTypeDef(type);
        if (typeDef != null) {
            type = typeDef.getTypeClass();
            simpleValue.setTypeParameters(typeDef.getParameters());
        }
        if (typeParameters != null && typeParameters.size() != 0) {
            simpleValue.setTypeParameters(typeParameters);
        }
        simpleValue.setTypeName(type);
        if (persistentClassName != null) {
            simpleValue.setTypeUsingReflection(persistentClassName, propertyName);
        }
        column.linkWithValue(simpleValue);
        return simpleValue;
    }

    private static Property bindProperty(String name, String returnedClassName, boolean lazy, String propertyAccessorName, Ejb3Column column, PropertyHolder propertyHolder, String explicitType, Properties typeParameters, Mappings mappings) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("binding property " + name + " with lazy=" + lazy));
        }
        String containerClassName = propertyHolder == null ? null : propertyHolder.getClassName();
        SimpleValue propertyValue = AnnotationBinder.makeSimpleValue(name, returnedClassName, column, containerClassName, explicitType, typeParameters, mappings);
        Property prop = AnnotationBinder.makeProperty(name, (Value)propertyValue, column.isInsertable(), column.isUpdatable(), lazy, null, propertyAccessorName);
        column.addPropertyToMappingContainer(prop);
        return prop;
    }

    private static Property makeProperty(String propertyName, Value value, boolean insertable, boolean updatable, boolean lazy, String cascade, String propertyAccessorName) {
        log.debug((Object)("Building property " + propertyName));
        Property prop = new Property();
        prop.setName(propertyName);
        prop.setValue(value);
        prop.setInsertable(insertable);
        prop.setUpdateable(updatable);
        prop.setLazy(lazy);
        prop.setCascade(cascade);
        prop.setPropertyAccessorName(propertyAccessorName);
        log.debug((Object)("Cascading " + propertyName + " with " + cascade));
        return prop;
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, String targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, boolean unique, ExtendedMappings mappings) {
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity)) {
            value.setReferencedEntityName(returnedClassName);
        } else {
            value.setReferencedEntityName(targetEntity);
        }
        value.setFetchMode(fetchMode);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        value.setTypeName(returnedClassName);
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String propertyRef = value.getReferencedPropertyName();
        if (propertyRef != null) {
            mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
        }
        mappings.addSecondPass(new FkSecondPass((Value)value, columns, unique, mappings));
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)value, columns[0].isInsertable(), columns[0].isUpdatable(), false, cascadeStrategy, propertyAccessorName);
        prop.setCascade(cascadeStrategy);
        columns[0].addPropertyToMappingContainer(prop);
    }

    public static void bindFkSecondPass(ManyToOne manyToOne, Ejb3JoinColumn[] columns, Map persistentClasses, boolean unique) {
        PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
        if (ref == null) {
            throw new AnnotationException("Unable to find entity " + manyToOne.getReferencedEntityName());
        }
        TableBinder.bindFk(ref, null, columns, (SimpleValue)manyToOne, unique);
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, String targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, String mappedBy, boolean trueOneToOne, ExtendedMappings mappings) {
        log.debug((Object)("Fetching " + propertyName + " with " + fetchMode));
        boolean mapToPK = true;
        if (!trueOneToOne) {
            Iterator idColumns = propertyHolder.getIdentifier().getColumnIterator();
            ArrayList<String> idColumnNames = new ArrayList<String>();
            while (idColumns.hasNext()) {
                Column currentColumn = (Column)idColumns.next();
                idColumnNames.add(currentColumn.getName());
            }
            for (Ejb3JoinColumn col : columns) {
                if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                mapToPK = false;
                break;
            }
        }
        if (trueOneToOne || mapToPK || !AnnotationBinder.isDefault(mappedBy)) {
            String propertyRef;
            org.hibernate.mapping.OneToOne value = new org.hibernate.mapping.OneToOne(propertyHolder.getTable(), propertyHolder.getIdentifier());
            if (AnnotationBinder.isDefault(targetEntity)) {
                value.setReferencedEntityName(returnedClassName);
            } else {
                value.setReferencedEntityName(targetEntity);
            }
            value.setFetchMode(fetchMode);
            if (!optional) {
                value.setConstrained(true);
            }
            value.setForeignKeyType(value.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
            if (!AnnotationBinder.isDefault(mappedBy)) {
                value.setReferencedPropertyName(mappedBy);
            }
            if ((propertyRef = value.getReferencedPropertyName()) != null) {
                mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
            }
            Property prop = AnnotationBinder.makeProperty(propertyName, (Value)value, true, true, false, cascadeStrategy, propertyAccessorName);
            prop.setCascade(cascadeStrategy);
            propertyHolder.addProperty(prop);
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, columns, optional, fetchMode, propertyName, returnedClassName, targetEntity, propertyAccessorName, propertyHolder, true, mappings);
        }
    }

    private static void bindOneToMany(Class collectionType, String targetEntity, String propertyName, Class returnedClass, FetchMode fetchMode, Ejb3JoinColumn[] columns, String cascadeStrategy, String propertyAccessorName, PropertyHolder propertyHolder, int batchSize, String where, boolean isInverse, String cacheConcurrencyStrategy, String cacheRegionName, Map<String, String> filters, ExtendedMappings mappings) {
        for (Ejb3JoinColumn column : columns) {
            if (!column.isSecondary()) continue;
            throw new NotYetImplementedException("Collections having FK in secondary table");
        }
        org.hibernate.mapping.Collection collection = AnnotationBinder.fillCollection(propertyName, returnedClass, fetchMode, propertyHolder, batchSize, where, cacheConcurrencyStrategy, filters, cacheRegionName);
        collection.setInverse(isInverse);
        org.hibernate.mapping.OneToMany oneToMany = new org.hibernate.mapping.OneToMany(collection.getOwner());
        collection.setElement((Value)oneToMany);
        oneToMany.setReferencedEntityName(AnnotationBinder.getCollectionType(collectionType, targetEntity));
        mappings.addSecondPass(new CollectionSecondPass(mappings, collection, columns));
        mappings.addCollection(collection);
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)collection, true, true, false, cascadeStrategy, propertyAccessorName);
        propertyHolder.addProperty(prop);
    }

    private static void bindManyToMany(Class collectionType, String targetEntity, String propertyName, Class returnedClass, FetchMode fetchMode, org.hibernate.mapping.Table table, String cascadeStrategy, String propertyAccessorName, PropertyHolder propertyHolder, String mappedBy, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, int batchSize, String where, boolean unique, String cacheConcurrencyStrategy, String cacheRegionName, Map<String, String> filters, ExtendedMappings mappings) {
        boolean isMappedBy;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Binding as ManyToMany: " + propertyHolder.getEntityName() + "." + propertyName));
        }
        org.hibernate.mapping.Collection collection = AnnotationBinder.fillCollection(propertyName, returnedClass, fetchMode, propertyHolder, batchSize, where, cacheConcurrencyStrategy, filters, cacheRegionName);
        collection.setInverse(!StringHelper.isEmpty((String)mappedBy));
        collection.setCollectionTable(table);
        String collType = AnnotationBinder.getCollectionType(collectionType, targetEntity);
        boolean bl = isMappedBy = !AnnotationBinder.isDefault(mappedBy);
        if (isMappedBy) {
            mappings.addMappedBy(collType, mappedBy, propertyName);
        }
        mappings.addSecondPass(new CollectionSecondPass(mappings, collection, joinColumns, inverseJoinColumns, collType, fetchMode, unique), !isMappedBy);
        mappings.addCollection(collection);
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)collection, true, true, false, cascadeStrategy, propertyAccessorName);
        propertyHolder.addProperty(prop);
    }

    private static org.hibernate.mapping.Collection fillCollection(String propertyName, Class returnedClass, FetchMode fetchMode, PropertyHolder propertyHolder, int batchSize, String where, String cacheConcurrencyStrategy, Map<String, String> filters, String cacheRegionName) {
        Set collection;
        if (returnedClass.equals(java.util.Set.class)) {
            collection = new Set(propertyHolder.getPersistentClass());
        } else if (returnedClass.equals(Collection.class)) {
            collection = new Bag(propertyHolder.getPersistentClass());
        } else {
            throw new AnnotationException(returnedClass.getName() + " collection not yet supported");
        }
        log.debug((Object)("Collection role: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)propertyName)));
        collection.setRole(StringHelper.qualify((String)propertyHolder.getPath(), (String)propertyName));
        collection.setFetchMode(fetchMode);
        collection.setLazy(fetchMode == FetchMode.SELECT);
        collection.setBatchSize(batchSize);
        if (StringHelper.isNotEmpty((String)where)) {
            collection.setWhere(where);
        }
        if (cacheConcurrencyStrategy != null) {
            collection.setCacheConcurrencyStrategy(cacheConcurrencyStrategy);
            collection.setCacheRegionName(cacheRegionName);
        }
        for (Map.Entry<String, String> filter : filters.entrySet()) {
            collection.addFilter(filter.getKey(), filter.getValue());
        }
        return collection;
    }

    private static String getCollectionType(Class collectionType, String targetEntity) {
        if (AnnotationBinder.isDefault(targetEntity)) {
            if (collectionType != null) {
                return collectionType.getName();
            }
            throw new AnnotationException("Collection has neither generic type or OneToMany.targetEntity() defined");
        }
        return targetEntity;
    }

    public static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] columns, ExtendedMappings mappings) throws MappingException {
        if (collValue.isOneToMany()) {
            org.hibernate.mapping.OneToMany oneToMany = (org.hibernate.mapping.OneToMany)collValue.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass associatedClass = (PersistentClass)persistentClasses.get(assocClass);
            if (mappings == null) {
                throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
            }
            Map<String, Join> joins = mappings.getJoins(assocClass);
            if (associatedClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(associatedClass);
            for (Ejb3JoinColumn column : columns) {
                column.setPersistentClass(associatedClass);
                column.setJoins(joins);
                collValue.setCollectionTable(column.getTable());
            }
            log.info((Object)("Mapping collection: " + collValue.getRole() + " -> " + collValue.getCollectionTable().getName()));
        }
        AnnotationBinder.bindCollectionSecondPass(collValue, null, columns);
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collValue, Ejb3JoinColumn[] joinColumns) {
        String propRef = collValue.getReferencedPropertyName();
        KeyValue keyVal = propRef == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        Ejb3JoinColumn.checkPropertyConsistency(joinColumns, collValue.getOwnerEntityName());
        key.setUpdateable(joinColumns.length == 0 ? true : joinColumns[0].isUpdatable());
        collValue.setKey((KeyValue)key);
        return key;
    }

    public static void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, String collType, FetchMode fetchMode, boolean unique, ExtendedMappings mappings) throws MappingException {
        boolean mappedBy;
        PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(collType);
        if (collectionEntity == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        boolean bl = mappedBy = !AnnotationBinder.isDefault(joinColumns[0].getMappedBy());
        if (mappedBy) {
            Property otherSideProperty;
            try {
                otherSideProperty = collectionEntity.getProperty(joinColumns[0].getMappedBy());
            }
            catch (MappingException e) {
                throw new AnnotationException("mappedBy reference an unknown property: " + collType + "." + joinColumns[0].getMappedBy());
            }
            org.hibernate.mapping.Table table = ((org.hibernate.mapping.Collection)otherSideProperty.getValue()).getCollectionTable();
            collValue.setCollectionTable(table);
            for (Ejb3JoinColumn column : joinColumns) {
                column.setDefaultColumnHeader(joinColumns[0].getMappedBy());
            }
        } else {
            for (Ejb3JoinColumn column : joinColumns) {
                String header = mappings.getFromMappedBy(collValue.getOwnerEntityName(), column.getPropertyName());
                header = header == null ? collValue.getOwner().getTable().getName() : header;
                column.setDefaultColumnHeader(header);
            }
            if (collValue.getCollectionTable() == null) {
                String tableName = collValue.getOwner().getTable().getName() + "_" + collectionEntity.getTable().getName();
                org.hibernate.mapping.Table table = TableBinder.fillTable(ANNOTATION_STRING_DEFAULT, ANNOTATION_STRING_DEFAULT, tableName, false, new ArrayList(), null, mappings);
                collValue.setCollectionTable(table);
            }
        }
        AnnotationBinder.bindCollectionSecondPass(collValue, collectionEntity, joinColumns);
        ManyToOne element = new ManyToOne(collValue.getCollectionTable());
        collValue.setElement((Value)element);
        element.setReferencedEntityName(collType);
        element.setFetchMode(fetchMode);
        if (collectionEntity == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        TableBinder.bindManytoManyInverseFk(collectionEntity, inverseJoinColumns, (SimpleValue)element, unique);
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, PersistentClass collectionEntity, Ejb3JoinColumn[] joinColumns) {
        SimpleValue key = AnnotationBinder.buildCollectionKey(collValue, joinColumns);
        TableBinder.bindFk(collValue.getOwner(), collectionEntity, joinColumns, key, false);
    }

    private static String generatorType(GeneratorType generatorEnum) {
        switch (generatorEnum) {
            case NONE: {
                return "assigned";
            }
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "sequence";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static String getCascadeStrategy(CascadeType[] cascades) {
        if (cascades.length == 0) {
            return "none";
        }
        boolean all = false;
        boolean persist = false;
        boolean merge = false;
        boolean remove = false;
        boolean refresh = false;
        block7: for (CascadeType cascade : cascades) {
            switch (cascade) {
                case ALL: {
                    all = true;
                    refresh = true;
                    continue block7;
                }
                case PERSIST: {
                    persist = true;
                    continue block7;
                }
                case MERGE: {
                    merge = true;
                    continue block7;
                }
                case REMOVE: {
                    remove = true;
                    continue block7;
                }
                case REFRESH: {
                    refresh = true;
                }
            }
        }
        StringBuffer cascade = new StringBuffer();
        if (refresh) {
            cascade.append("refresh,");
        }
        if (all) {
            cascade.append("all,");
            cascade.deleteCharAt(cascade.length() - 1);
            return cascade.toString();
        }
        if (persist || merge) {
            cascade.append("save-update,");
        }
        if (persist) {
            cascade.append("persist,");
        }
        if (merge) {
            cascade.append("merge,");
        }
        if (remove) {
            cascade.append("remove,");
        }
        if (cascade.length() == 0) {
            throw new AssertionFailure("Error in cascade strategies mapper");
        }
        cascade.deleteCharAt(cascade.length() - 1);
        return cascade.toString();
    }

    private static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(AnnotatedElement annElt) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(String annotationString) {
        return ANNOTATION_STRING_DEFAULT.equals(annotationString);
    }
}

