/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hector.testutils;

import com.google.common.base.Charsets;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.ColumnFamilyType;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.AsciiType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DynamicCompositeType;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LexicalUUIDType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.TimeUUIDType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.db.marshal.UUIDType;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.locator.SimpleStrategy;
import org.apache.cassandra.thrift.IndexType;

public class EmbeddedSchemaLoader {
    private static final Map<Byte, AbstractType<?>> alias = new HashMap();

    public static void loadSchema() {
        try {
            Schema.instance.load(EmbeddedSchemaLoader.schemaDefinition());
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<KSMetaData> schemaDefinition() throws ConfigurationException {
        ArrayList<KSMetaData> schema = new ArrayList<KSMetaData>();
        String ks1 = "Keyspace1";
        String ks2 = "Keyspace2";
        Class<SimpleStrategy> simple = SimpleStrategy.class;
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("replication_factor", Integer.toString(1));
        ColumnFamilyType st = ColumnFamilyType.Standard;
        ColumnFamilyType su = ColumnFamilyType.Super;
        BytesType bytes = BytesType.instance;
        ArrayList<Object> subComparators = new ArrayList<Object>();
        subComparators.add(BytesType.instance);
        subComparators.add(TimeUUIDType.instance);
        subComparators.add(IntegerType.instance);
        schema.add(KSMetaData.testMetadata((String)ks1, simple, opts, (CFMetaData[])new CFMetaData[]{EmbeddedSchemaLoader.standardCFMD(ks1, "Standard1"), EmbeddedSchemaLoader.standardCFMD(ks1, "Standard2"), EmbeddedSchemaLoader.standardCFMD(ks1, "Standard3"), EmbeddedSchemaLoader.standardCFMD(ks1, "Standard4"), EmbeddedSchemaLoader.dynamicCompositeCFMD(ks1, "DynamicComposite1"), EmbeddedSchemaLoader.cqlTestCf(ks1, "StandardLong1", (AbstractType)UTF8Type.instance), EmbeddedSchemaLoader.standardCFMD(ks1, "StandardLong2").keyValidator((AbstractType)UTF8Type.instance), EmbeddedSchemaLoader.superCFMD(ks1, "Super1", (AbstractType)BytesType.instance), EmbeddedSchemaLoader.superCFMD(ks1, "Super2", (AbstractType)LongType.instance), EmbeddedSchemaLoader.superCFMD(ks1, "Super3", (AbstractType)LongType.instance), EmbeddedSchemaLoader.superCFMD(ks1, "Super4", (AbstractType)UTF8Type.instance), EmbeddedSchemaLoader.superCFMD(ks1, "Super5", (AbstractType)bytes), EmbeddedSchemaLoader.indexCFMD(ks1, "Indexed1", true), EmbeddedSchemaLoader.indexCFMD(ks1, "Indexed2", false), new CFMetaData(ks1, "Counter1", st, (AbstractType)bytes, null).replicateOnWrite(true).defaultValidator((AbstractType)CounterColumnType.instance).rebuild(), new CFMetaData(ks1, "Counter2", st, (AbstractType)bytes, null).replicateOnWrite(true).defaultValidator((AbstractType)CounterColumnType.instance).rebuild(), new CFMetaData(ks1, "SuperCounter1", su, (AbstractType)bytes, (AbstractType)bytes).replicateOnWrite(true).defaultValidator((AbstractType)CounterColumnType.instance).rebuild(), EmbeddedSchemaLoader.jdbcCFMD(ks1, "JdbcInteger", (AbstractType)IntegerType.instance), EmbeddedSchemaLoader.jdbcCFMD(ks1, "JdbcUtf8", (AbstractType)UTF8Type.instance), EmbeddedSchemaLoader.jdbcCFMD(ks1, "JdbcLong", (AbstractType)LongType.instance), EmbeddedSchemaLoader.jdbcCFMD(ks1, "JdbcBytes", (AbstractType)bytes), EmbeddedSchemaLoader.jdbcCFMD(ks1, "JdbcAscii", (AbstractType)AsciiType.instance)}));
        return schema;
    }

    private static CFMetaData compositeCFMD(String ksName, String cfName, AbstractType<?> ... types) {
        return new CFMetaData(ksName, cfName, ColumnFamilyType.Standard, (AbstractType)CompositeType.getInstance(Arrays.asList(types)), null).rebuild();
    }

    private static CFMetaData dynamicCompositeCFMD(String ksName, String cfName) {
        return new CFMetaData(ksName, cfName, ColumnFamilyType.Standard, (AbstractType)DynamicCompositeType.getInstance(alias), null).rebuild();
    }

    private static CFMetaData standardCFMD(String ksName, String cfName) {
        return new CFMetaData(ksName, cfName, ColumnFamilyType.Standard, (AbstractType)BytesType.instance, null).rebuild();
    }

    private static CFMetaData superCFMD(String ksName, String cfName, AbstractType subcc) {
        return new CFMetaData(ksName, cfName, ColumnFamilyType.Super, (AbstractType)BytesType.instance, subcc).rebuild();
    }

    private static CFMetaData indexCFMD(String ksName, String cfName, final Boolean withIdxType) throws ConfigurationException {
        return EmbeddedSchemaLoader.standardCFMD(ksName, cfName).columnMetadata((Map)new HashMap<ByteBuffer, ColumnDefinition>(){
            {
                ByteBuffer cName = ByteBuffer.wrap("birthyear".getBytes(Charsets.UTF_8));
                IndexType keys = withIdxType != false ? IndexType.KEYS : null;
                ColumnDefinition def = new ColumnDefinition(cName, (AbstractType)LongType.instance, IndexType.KEYS, null, "birthyear_index", null, ColumnDefinition.Type.REGULAR);
                this.put(cName, def);
            }
        }).rebuild();
    }

    private static CFMetaData jdbcCFMD(String ksName, String cfName, AbstractType comp) {
        return new CFMetaData(ksName, cfName, ColumnFamilyType.Standard, comp, null).defaultValidator(comp).rebuild();
    }

    private static CFMetaData cqlTestCf(String ksName, String cfName, AbstractType comp) throws ConfigurationException {
        return new CFMetaData(ksName, cfName, ColumnFamilyType.Standard, comp, null).keyValidator((AbstractType)UTF8Type.instance).columnMetadata((Map)new HashMap<ByteBuffer, ColumnDefinition>(){
            {
                ByteBuffer cName = ByteBuffer.wrap("birthyear".getBytes(Charsets.UTF_8));
                this.put(cName, new ColumnDefinition(cName, (AbstractType)LongType.instance, null, null, null, null, ColumnDefinition.Type.REGULAR));
            }
        }).rebuild();
    }

    static {
        alias.put((byte)97, (AbstractType<?>)AsciiType.instance);
        alias.put((byte)105, (AbstractType<?>)IntegerType.instance);
        alias.put((byte)120, (AbstractType<?>)LexicalUUIDType.instance);
        alias.put((byte)108, (AbstractType<?>)LongType.instance);
        alias.put((byte)116, (AbstractType<?>)TimeUUIDType.instance);
        alias.put((byte)115, (AbstractType<?>)UTF8Type.instance);
        alias.put((byte)117, (AbstractType<?>)UUIDType.instance);
    }
}

