/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import me.prettyprint.hom.KeyConcatenationStrategy;

public class KeyConcatenationDelimiterStrategyImpl
implements KeyConcatenationStrategy {
    private byte[] delimiter = "||".getBytes();

    @Override
    public byte[] concat(List<byte[]> segmentList) {
        int totalSegmentSize = 0;
        for (byte[] ba : segmentList) {
            totalSegmentSize += ba.length;
        }
        ByteBuffer colFamKey = ByteBuffer.allocate(totalSegmentSize + (segmentList.size() - 1) * this.delimiter.length);
        int segNum = 1;
        for (byte[] ba : segmentList) {
            colFamKey.put(ba);
            if (segNum++ >= segmentList.size()) continue;
            colFamKey.put(this.delimiter);
        }
        return colFamKey.array();
    }

    @Override
    public List<byte[]> split(byte[] colFamKey) {
        ByteBuffer bb = ByteBuffer.wrap(colFamKey);
        LinkedList<byte[]> segmentList = new LinkedList<byte[]>();
        int segStart = 0;
        bb.mark();
        while (bb.remaining() >= this.delimiter.length) {
            boolean delimiterFound = true;
            for (byte b : this.delimiter) {
                if (bb.get() == b) continue;
                delimiterFound = false;
                break;
            }
            if (!delimiterFound) continue;
            int segSize = bb.position() - segStart - this.delimiter.length;
            segmentList.add(this.copyFromMark(bb, segStart, segSize));
            bb.position(bb.position() + this.delimiter.length);
            segStart = bb.position();
            bb.mark();
        }
        segmentList.add(this.copyFromMark(bb, segStart, bb.capacity() - segStart));
        return segmentList;
    }

    private byte[] copyFromMark(ByteBuffer bb, int segStart, int segSize) {
        byte[] newSeg = new byte[segSize];
        bb.reset();
        bb.get(newSeg, 0, segSize);
        return newSeg;
    }

    public byte[] getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(byte[] delimiter) {
        this.delimiter = delimiter;
    }
}

