/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom.cache;

import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.annotations.Column;
import me.prettyprint.hom.cache.ColumnParserValidator;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import me.prettyprint.hom.converters.DefaultConverter;

public class ColumnParser
implements ColumnParserValidator {
    @Override
    public <T> void parse(Field f, Annotation anno, PropertyDescriptor pd, CFMappingDef<T> cfMapDef) {
        block5: {
            try {
                if (anno instanceof javax.persistence.Column) {
                    this.processColumnAnnotation(f, (javax.persistence.Column)anno, pd, cfMapDef);
                    break block5;
                }
                if (anno instanceof Column) {
                    this.processColumnCustomAnnotation(f, (Column)anno, pd, cfMapDef);
                    break block5;
                }
                throw new HectorObjectMapperException("This class cannot parse annotation, " + anno.getClass().getSimpleName());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private <T> void processColumnAnnotation(Field f, javax.persistence.Column anno, PropertyDescriptor pd, CFMappingDef<T> cfMapDef) throws InstantiationException, IllegalAccessException {
        PropertyMappingDefinition md = new PropertyMappingDefinition(pd, anno.name(), DefaultConverter.class);
        cfMapDef.addPropertyDefinition(md);
    }

    private void processColumnCustomAnnotation(Field f, Column anno, PropertyDescriptor pd, CFMappingDef<?> cfMapDef) throws InstantiationException, IllegalAccessException {
        PropertyMappingDefinition md = new PropertyMappingDefinition(pd, anno.name(), anno.converter());
        Class<?> type = pd.getPropertyType();
        if (Collection.class.isAssignableFrom(type) && md.isDefaultConverter()) {
            md.setCollectionType(type);
        }
        cfMapDef.addPropertyDefinition(md);
    }
}

