/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import java.util.Collection;
import java.util.Set;
import javax.persistence.Entity;
import me.prettyprint.hector.api.Keyspace;
import me.prettyprint.hector.api.beans.ColumnSlice;
import me.prettyprint.hector.api.mutation.Mutator;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.ClassCacheMgr;
import me.prettyprint.hom.HectorObjectMapper;
import me.prettyprint.hom.annotations.AnnotationScanner;
import me.prettyprint.hom.cache.HectorObjectMapperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityManagerImpl {
    private static Logger logger = LoggerFactory.getLogger(EntityManagerImpl.class);
    private Keyspace keyspace;
    private HectorObjectMapper objMapper;
    private ClassCacheMgr cacheMgr;

    public EntityManagerImpl(Keyspace keyspace, String classpathPrefix) {
        this(keyspace, new String[]{classpathPrefix}, null, null);
    }

    public EntityManagerImpl(Keyspace keyspace, String[] classpathPrefix) {
        this(keyspace, classpathPrefix, null, null);
    }

    public EntityManagerImpl(Keyspace keyspace, String[] classpathPrefix, ClassCacheMgr cacheMgr, HectorObjectMapper objMapper) {
        this.keyspace = keyspace;
        this.cacheMgr = null != cacheMgr ? cacheMgr : new ClassCacheMgr();
        this.objMapper = null != objMapper ? objMapper : new HectorObjectMapper(this.cacheMgr);
        this.initialize(classpathPrefix);
    }

    public void initialize(String[] classpathPrefixArr) {
        if (null != classpathPrefixArr && 0 < classpathPrefixArr.length) {
            for (String classpathPrefix : classpathPrefixArr) {
                this.initializeClasspath(classpathPrefix);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("classpath array has {} items : {}", null != classpathPrefixArr ? Integer.valueOf(classpathPrefixArr.length) : "0", (Object)classpathPrefixArr);
        }
    }

    private void initializeClasspath(String classpathPrefix) {
        AnnotationScanner scanner = new AnnotationScanner();
        Set<Class<?>> classSet = scanner.scan(classpathPrefix, Entity.class);
        for (Class<?> clazz : classSet) {
            this.cacheMgr.initializeCacheForClass(clazz);
        }
    }

    @Deprecated
    public <T, I> T load(Class<T> clazz, I id) {
        return this.find(clazz, id);
    }

    @Deprecated
    public <T> T load(Class<T> clazz, Object id, ColumnSlice<String, byte[]> colSlice) {
        return this.find(clazz, id, colSlice);
    }

    @Deprecated
    public <T> T save(T obj) {
        return this.persist(obj);
    }

    public <T, I> T find(Class<T> clazz, I id) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        CFMappingDef<T> cfMapDef = this.cacheMgr.getCfMapDef(clazz, false);
        if (null == cfMapDef) {
            throw new HectorObjectMapperException("No class annotated with @" + Entity.class.getSimpleName() + " for type, " + clazz.getName());
        }
        return this.objMapper.getObject(this.keyspace, cfMapDef.getEffectiveColFamName(), id);
    }

    public <T> T find(Class<T> clazz, Object id, ColumnSlice<String, byte[]> colSlice) {
        if (null == clazz) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        if (null == id) {
            throw new IllegalArgumentException("id cannot be null");
        }
        CFMappingDef<T> cfMapDef = this.cacheMgr.getCfMapDef(clazz, false);
        if (null == cfMapDef) {
            throw new HectorObjectMapperException("No class annotated with @" + Entity.class.getSimpleName() + " for type, " + clazz.getName());
        }
        T obj = this.objMapper.createObject(cfMapDef, id, colSlice);
        return obj;
    }

    public <T> T persist(T obj) {
        if (null == obj) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        return this.objMapper.saveObj(this.keyspace, obj);
    }

    public Collection<Object> persist(Collection<Object> objColl) {
        if (null == objColl) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        this.objMapper.saveObjCollection(this.keyspace, objColl);
        return objColl;
    }

    public Collection<?> persist(Collection<?> objColl, Mutator<byte[]> m) {
        if (null == objColl) {
            throw new IllegalArgumentException("object to save cannot be null");
        }
        this.objMapper.saveObjCollection(this.keyspace, objColl, m);
        return objColl;
    }
}

