/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.web.multipart;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.hdiv.config.multipart.exception.HdivMultipartException;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.web.multipart.MultipartHttpServletRequestWrapper;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.util.WebUtils;

public class HdivCommonsMultipartResolver
extends CommonsMultipartResolver {
    public MultipartHttpServletRequest resolveMultipart(HttpServletRequest request) throws MultipartException {
        HdivMultipartException multipartException = (HdivMultipartException)request.getAttribute("org.hdiv.exception.HDIVMultipartException");
        if (multipartException != null) {
            Exception orig = multipartException.getOriginal();
            if (orig instanceof MultipartException) {
                throw (MultipartException)((Object)orig);
            }
            throw new MultipartException("Could not parse multipart servlet request", (Throwable)orig);
        }
        MultipartHttpServletRequest original = (MultipartHttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartHttpServletRequest.class);
        if (original != null) {
            RequestWrapper requestWrapper = (RequestWrapper)WebUtils.getNativeRequest((ServletRequest)request, RequestWrapper.class);
            return new MultipartHttpServletRequestWrapper(request, requestWrapper, original);
        }
        return super.resolveMultipart(request);
    }
}

