/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.util;

import java.util.Locale;
import java.util.Random;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.application.IApplication;
import org.hdiv.config.HDIVConfig;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.exception.HDIVException;
import org.hdiv.urlProcessor.FormUrlProcessor;
import org.hdiv.urlProcessor.LinkUrlProcessor;
import org.springframework.context.MessageSource;

public class HDIVUtil {
    private static Log log = LogFactory.getLog(HDIVUtil.class);
    public static final String APPLICATION_SERVLETCONTEXT_KEY = "APPLICATION_SERVLETCONTEXT_KEY";
    public static final String MESSAGESOURCE_SERVLETCONTEXT_KEY = "MESSAGESOURCE_SERVLETCONTEXT_KEY";
    public static final String HDIVCONFIG_SERVLETCONTEXT_KEY = "HDIVCONFIG_SERVLETCONTEXT_KEY";
    public static final String DATACOMPOSER_REQUEST_KEY = "DATACOMPOSER_REQUEST_KEY";
    public static final String REQUESTURI_REQUEST_KEY = "REQUESTURI_REQUEST_KEY";
    public static final String BASEURL_REQUEST_KEY = "BASEURL_REQUEST_KEY";
    public static final String LINKURLPROCESSOR_SERVLETCONTEXT_KEY = "LINKURLPROCESSOR_SERVLETCONTEXT_KEY";
    public static final String FORMURLPROCESSOR_SERVLETCONTEXT_KEY = "FORMURLPROCESSOR_SERVLETCONTEXT_KEY";
    public static Pattern intPattern = Pattern.compile("[0-9]+");
    private static ThreadLocal<HttpServletRequest> httpRequest = new ThreadLocal();

    public static void resetLocalData() {
        httpRequest.set(null);
    }

    public static IDataComposer getDataComposer(HttpServletRequest request) {
        IDataComposer requestDataComposer = (IDataComposer)request.getAttribute(DATACOMPOSER_REQUEST_KEY);
        return requestDataComposer;
    }

    public static IDataComposer getDataComposer() {
        HttpServletRequest request = HDIVUtil.getHttpServletRequest();
        IDataComposer newDataComposer = HDIVUtil.getDataComposer(request);
        return newDataComposer;
    }

    public static boolean isDataComposer(HttpServletRequest request) {
        IDataComposer requestDataComposer = (IDataComposer)request.getAttribute(DATACOMPOSER_REQUEST_KEY);
        return requestDataComposer != null;
    }

    public static void setDataComposer(IDataComposer newDataComposer, HttpServletRequest request) {
        request.setAttribute(DATACOMPOSER_REQUEST_KEY, (Object)newDataComposer);
    }

    public static void removeDataComposer(HttpServletRequest request) {
        request.removeAttribute(DATACOMPOSER_REQUEST_KEY);
    }

    public static String getRequestURI(HttpServletRequest request) {
        String requestURI = (String)request.getAttribute(REQUESTURI_REQUEST_KEY);
        if (requestURI == null) {
            throw new HDIVException("RequestURI has not been initialized in request.");
        }
        return requestURI;
    }

    public static void setRequestURI(String requestURI, HttpServletRequest request) {
        request.setAttribute(REQUESTURI_REQUEST_KEY, (Object)requestURI);
    }

    public static String getBaseURL(HttpServletRequest request) {
        String baseURL = (String)request.getAttribute(BASEURL_REQUEST_KEY);
        return baseURL;
    }

    public static void setBaseURL(String baseURL, HttpServletRequest request) {
        request.setAttribute(BASEURL_REQUEST_KEY, (Object)baseURL);
    }

    public static IApplication getApplication() {
        ServletContext servletContext = HDIVUtil.getHttpServletRequest().getSession().getServletContext();
        return HDIVUtil.getApplication(servletContext);
    }

    public static IApplication getApplication(ServletContext servletContext) {
        IApplication app = (IApplication)servletContext.getAttribute(APPLICATION_SERVLETCONTEXT_KEY);
        if (app == null) {
            throw new HDIVException("IApplication has not been initialized in servlet context");
        }
        return app;
    }

    public static void setApplication(IApplication newApplication, ServletContext servletContext) {
        servletContext.setAttribute(APPLICATION_SERVLETCONTEXT_KEY, (Object)newApplication);
    }

    public static HDIVConfig getHDIVConfig() {
        ServletContext servletContext = HDIVUtil.getHttpServletRequest().getSession().getServletContext();
        return HDIVUtil.getHDIVConfig(servletContext);
    }

    public static HDIVConfig getHDIVConfig(ServletContext servletContext) {
        HDIVConfig hdivConfig = (HDIVConfig)servletContext.getAttribute(HDIVCONFIG_SERVLETCONTEXT_KEY);
        if (hdivConfig == null) {
            throw new HDIVException("HDIVConfig has not been initialized in servlet context");
        }
        return hdivConfig;
    }

    public static void setHDIVConfig(HDIVConfig hdivConfig, ServletContext servletContext) {
        servletContext.setAttribute(HDIVCONFIG_SERVLETCONTEXT_KEY, (Object)hdivConfig);
    }

    public static LinkUrlProcessor getLinkUrlProcessor(ServletContext servletContext) {
        LinkUrlProcessor urlProcessor = (LinkUrlProcessor)servletContext.getAttribute(LINKURLPROCESSOR_SERVLETCONTEXT_KEY);
        if (urlProcessor == null) {
            throw new HDIVException("LinkUrlProcessor has not been initialized in servlet context");
        }
        return urlProcessor;
    }

    public static void setLinkUrlProcessor(LinkUrlProcessor urlProcessor, ServletContext servletContext) {
        servletContext.setAttribute(LINKURLPROCESSOR_SERVLETCONTEXT_KEY, (Object)urlProcessor);
    }

    public static FormUrlProcessor getFormUrlProcessor(ServletContext servletContext) {
        FormUrlProcessor urlProcessor = (FormUrlProcessor)servletContext.getAttribute(FORMURLPROCESSOR_SERVLETCONTEXT_KEY);
        if (urlProcessor == null) {
            throw new HDIVException("FormUrlProcessor has not been initialized in servlet context");
        }
        return urlProcessor;
    }

    public static void setFormUrlProcessor(FormUrlProcessor urlProcessor, ServletContext servletContext) {
        servletContext.setAttribute(FORMURLPROCESSOR_SERVLETCONTEXT_KEY, (Object)urlProcessor);
    }

    public static HttpSession getHttpSession() {
        HttpServletRequest request = HDIVUtil.getHttpServletRequest();
        return request.getSession();
    }

    public static HttpServletRequest getHttpServletRequest() {
        HttpServletRequest request = httpRequest.get();
        if (request == null) {
            throw new HDIVException("Request has not been initialized in threadlocal");
        }
        return request;
    }

    public static HttpServletRequest getNonRequiredHttpServletRequest() {
        HttpServletRequest request = httpRequest.get();
        return request;
    }

    public static void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        httpRequest.set(httpServletRequest);
    }

    public static MessageSource getMessageSource() {
        ServletContext servletContext = HDIVUtil.getHttpServletRequest().getSession().getServletContext();
        return HDIVUtil.getMessageSource(servletContext);
    }

    public static MessageSource getMessageSource(ServletContext servletContext) {
        MessageSource msgSource = (MessageSource)servletContext.getAttribute(MESSAGESOURCE_SERVLETCONTEXT_KEY);
        if (msgSource == null) {
            throw new HDIVException("MessageSource has not been initialized in servlet context");
        }
        return msgSource;
    }

    public static void setMessageSource(MessageSource msgSource, ServletContext servletContext) {
        servletContext.setAttribute(MESSAGESOURCE_SERVLETCONTEXT_KEY, (Object)msgSource);
    }

    public static String getMessage(String key) {
        return HDIVUtil.getMessage(key, null);
    }

    public static String getMessage(String key, String o) {
        return HDIVUtil.getMessage(key, o, Locale.getDefault());
    }

    public static String getMessage(String key, String o, Locale userLocale) {
        String resolvedMessage = HDIVUtil.getMessageSource().getMessage(key, (Object[])new String[]{o}, userLocale);
        if (log.isDebugEnabled()) {
            log.debug((Object)resolvedMessage);
        }
        return resolvedMessage;
    }

    public static String createRandomToken(int n) {
        Random r = new Random();
        int i = r.nextInt(n);
        if (i == 0) {
            i = 1;
        }
        return String.valueOf(i);
    }

    public static String stripSession(String url) {
        int sessionStart;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Stripping jsessionid from url " + url));
        }
        StringBuffer u = new StringBuffer(url);
        while ((sessionStart = u.toString().indexOf(";jsessionid=")) != -1 || (sessionStart = u.toString().indexOf(";JSESSIONID=")) != -1) {
            int sessionEnd = u.toString().indexOf(";", sessionStart + 1);
            if (sessionEnd == -1) {
                sessionEnd = u.toString().indexOf("?", sessionStart + 1);
            }
            if (sessionEnd == -1) {
                sessionEnd = u.length();
            }
            u.delete(sessionStart, sessionEnd);
        }
        return u.toString();
    }
}

