/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.urlProcessor.AbstractUrlProcessor;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.util.HDIVUtil;

public class LinkUrlProcessor
extends AbstractUrlProcessor {
    private static Log log = LogFactory.getLog(LinkUrlProcessor.class);

    public String processUrl(HttpServletRequest request, String url) {
        return this.processUrl(request, url, "UTF-8");
    }

    public String processUrl(HttpServletRequest request, String url, String encoding) {
        IDataComposer dataComposer = HDIVUtil.getDataComposer(request);
        if (dataComposer == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IDataComposer not initialized on request, request is out of filter");
            }
            return url;
        }
        UrlData urlData = super.createUrlData(url, "GET", request);
        if (super.isHdivStateNecessary(urlData)) {
            dataComposer.beginRequest("GET", urlData.getUrlWithoutContextPath());
            String processedParams = dataComposer.composeParams(urlData.getUrlParams(), "GET", encoding);
            urlData.setUrlParams(processedParams);
            String stateParam = dataComposer.endRequest();
            url = super.getProcessedUrlWithHdivState(request, urlData, stateParam);
        }
        return url;
    }
}

