/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.urlProcessor.AbstractUrlProcessor;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.util.HDIVUtil;

public class FormUrlProcessor
extends AbstractUrlProcessor {
    public static final String FORM_STATE_ID = "hdivFormStateId";
    private static Log log = LogFactory.getLog(FormUrlProcessor.class);

    public UrlData createUrlData(String url, String method, HttpServletRequest request) {
        UrlData urlData = super.createUrlData(url, method, request);
        String params = this.removeStateParameter(request, urlData.getUrlParams());
        urlData.setUrlParams(params);
        return urlData;
    }

    protected String removeStateParameter(HttpServletRequest request, String params) {
        String hdivParameter = (String)request.getSession().getAttribute("HDIVParameter");
        if (params == null || !params.contains(hdivParameter)) {
            return params;
        }
        int start = params.indexOf(hdivParameter);
        int end = params.indexOf("&", start);
        if (end < 0) {
            end = params.indexOf("#", start);
        }
        if (end < 0) {
            end = params.length();
        }
        String result = params.substring(0, start);
        if ((result = result + params.substring(end, params.length())).endsWith("&")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    public String processUrl(HttpServletRequest request, String url) {
        return this.processUrl(request, url, "POST");
    }

    public String processUrl(HttpServletRequest request, String url, String method) {
        IDataComposer dataComposer;
        if (method == null) {
            method = "POST";
        }
        if ((dataComposer = HDIVUtil.getDataComposer(request)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"IDataComposer not initialized on request, request is out of filter");
            }
            return url;
        }
        UrlData urlData = this.createUrlData(url, method, request);
        if (this.isHdivStateNecessary(urlData)) {
            String stateId = dataComposer.beginRequest(method, urlData.getUrlWithoutContextPath());
            request.setAttribute(FORM_STATE_ID, (Object)stateId);
            String processedParams = dataComposer.composeParams(urlData.getUrlParams(), method, "UTF-8");
            urlData.setUrlParams(processedParams);
            url = this.getProcessedUrl(urlData);
        }
        return url;
    }
}

