/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.urlProcessor;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.regex.PatternMatcher;
import org.hdiv.urlProcessor.UrlData;
import org.hdiv.util.Constants;
import org.hdiv.util.HDIVUtil;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUrlProcessor {
    private static Log log = LogFactory.getLog(AbstractUrlProcessor.class);
    protected HDIVConfig config;

    public UrlData createUrlData(String url, String method, HttpServletRequest request) {
        String serverUrl;
        int paramInit;
        Assert.notNull((Object)this.config);
        UrlData urlData = new UrlData(url, method);
        if (url.indexOf(35) >= 0) {
            String anchor = url.substring(url.indexOf(35) + 1);
            urlData.setAnchor(anchor);
            url = url.substring(0, url.indexOf(35));
        }
        if ((paramInit = url.indexOf("?")) > -1) {
            String urlParams = url.substring(paramInit + 1);
            urlData.setUrlParams(urlParams);
            url = url.substring(0, paramInit);
        }
        if ((serverUrl = this.getServerFromUrl(url)) != null && serverUrl.length() > 0) {
            urlData.setServer(serverUrl);
            url = url.replaceFirst(serverUrl, "");
        }
        boolean internal = this.isInternalUrl(request, url, urlData);
        urlData.setInternal(internal);
        url = this.stripSession(url, urlData);
        String contextPathRelativeUrl = this.getContextPathRelative(request, url);
        urlData.setContextPathRelativeUrl(contextPathRelativeUrl);
        String contextPath = request.getContextPath();
        if (contextPathRelativeUrl.startsWith(contextPath)) {
            String urlWithoutContextPath = contextPathRelativeUrl.substring(contextPath.length());
            urlData.setUrlWithoutContextPath(urlWithoutContextPath);
        } else {
            urlData.setInternal(false);
        }
        return urlData;
    }

    protected Map<String, String[]> getUrlParamsAsMap(HttpServletRequest request, String urlParams) {
        LinkedHashMap<String, String[]> params = new LinkedHashMap<String, String[]>();
        if (urlParams == null) {
            return params;
        }
        String value = urlParams.replaceAll("&amp;", "&");
        String hdivParameter = (String)request.getSession().getAttribute("HDIVParameter");
        StringTokenizer st = new StringTokenizer(value, "&");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int index = token.indexOf("=");
            String param = "";
            String val = "";
            if (index > -1) {
                param = token.substring(0, index);
                val = token.substring(index + 1);
            } else {
                param = token;
            }
            if (param.equals(hdivParameter)) continue;
            String[] values = (String[])params.get(param);
            if (values == null) {
                values = new String[]{val};
            } else {
                int l = values.length;
                values = Arrays.copyOf(values, l + 1);
                values[l] = val;
            }
            params.put(param, values);
        }
        return params;
    }

    protected boolean isStartPage(UrlData urlData) {
        return this.config.isStartPage(urlData.getUrlWithoutContextPath(), urlData.getMethod());
    }

    public String getProcessedUrlWithHdivState(HttpServletRequest request, UrlData urlData, String stateParam) {
        String url = this.getParamProcessedUrl(urlData);
        if (stateParam == null || stateParam.length() <= 0) {
            return url;
        }
        String separator = urlData.containsParams() ? "&" : "?";
        String hdivParameter = (String)request.getSession().getAttribute("HDIVParameter");
        StringBuffer sb = new StringBuffer();
        sb.append(url).append(separator).append(hdivParameter).append("=").append(stateParam);
        url = this.appendAnchor(sb.toString(), urlData.getAnchor());
        return url;
    }

    protected String getParamsQueryString(UrlData urlData) {
        UrlData eeUrlData = urlData;
        String queryString = "";
        if (eeUrlData.getUrlParams() != null) {
            queryString = "?" + eeUrlData.getUrlParams();
        }
        return queryString;
    }

    public String getParamProcessedUrl(UrlData urlData) {
        StringBuffer sb = new StringBuffer();
        if (urlData.getServer() != null) {
            sb.append(urlData.getServer());
        }
        sb.append(urlData.getContextPathRelativeUrl());
        if (urlData.getjSessionId() != null) {
            sb.append(";");
            sb.append(urlData.getjSessionId());
        }
        String queryString = this.getParamsQueryString(urlData);
        sb.append(queryString);
        return sb.toString();
    }

    public String getProcessedUrl(UrlData urlData) {
        String url = this.getParamProcessedUrl(urlData);
        url = this.appendAnchor(url, urlData.getAnchor());
        return url;
    }

    protected String appendAnchor(String url, String anchor) {
        if (anchor != null) {
            StringBuffer sb = new StringBuffer(url);
            sb.append("#").append(anchor);
            url = sb.toString();
        }
        return url;
    }

    public boolean isHdivStateNecessary(UrlData urlData) {
        if (urlData.getOriginalUrl().startsWith("javascript:")) {
            return false;
        }
        if (!urlData.isInternal()) {
            return false;
        }
        boolean startPage = this.isStartPage(urlData);
        if (startPage) {
            return false;
        }
        if (this.hasExtensionToExclude(urlData)) {
            return false;
        }
        boolean validateParamLessUrls = this.config.isValidationInUrlsWithoutParamsActivated();
        return !urlData.isGetMethod() || validateParamLessUrls || urlData.containsParams();
    }

    protected boolean isInternalUrl(HttpServletRequest request, String url, UrlData urlData) {
        if (urlData.getServer() != null) {
            String serverName = request.getServerName();
            if (!urlData.getServer().contains(serverName)) {
                return false;
            }
            String contextPath = request.getContextPath();
            return url.startsWith(contextPath + "/") || url.equals(contextPath);
        }
        String contextPath = request.getContextPath();
        if (url.startsWith(contextPath + "/") || url.equals(contextPath)) {
            return true;
        }
        return !url.startsWith("/");
    }

    protected String getServerFromUrl(String url) {
        int pos = url.indexOf("://");
        if (pos > 0) {
            int posicion = url.indexOf("/", pos + 3);
            if (posicion > 0) {
                url = url.substring(0, posicion);
                return url;
            }
            return url;
        }
        return null;
    }

    protected boolean hasExtensionToExclude(UrlData urlData) {
        String contextPathRelativeUrl = urlData.getContextPathRelativeUrl();
        if (contextPathRelativeUrl.charAt(contextPathRelativeUrl.length() - 1) == '/') {
            return false;
        }
        List<String> excludedExtensions = this.config.getExcludedURLExtensions();
        if (excludedExtensions != null) {
            for (String extension : excludedExtensions) {
                if (!contextPathRelativeUrl.endsWith(extension)) continue;
                return true;
            }
        }
        List<PatternMatcher> protectedExtension = this.config.getProtectedURLPatterns();
        if (contextPathRelativeUrl.endsWith(".jsp")) {
            return false;
        }
        if (protectedExtension != null) {
            for (PatternMatcher extensionPattern : protectedExtension) {
                if (!extensionPattern.matches(contextPathRelativeUrl)) continue;
                return false;
            }
        }
        return !contextPathRelativeUrl.startsWith("/") && contextPathRelativeUrl.indexOf(".") == -1;
    }

    protected String getContextPathRelative(HttpServletRequest request, String url) {
        String returnValue = null;
        String baseUrl = HDIVUtil.getBaseURL(request);
        if (baseUrl != null) {
            String serverUrl = this.getServerFromUrl(baseUrl);
            if (serverUrl != null && serverUrl.length() > 0) {
                baseUrl = baseUrl.replaceFirst(serverUrl, "");
            }
        } else {
            baseUrl = HDIVUtil.getRequestURI(request);
        }
        if (url.equals("")) {
            return baseUrl;
        }
        if (url.startsWith("/")) {
            returnValue = url;
        } else if (url.startsWith("..")) {
            returnValue = url;
        } else {
            String uri = baseUrl;
            uri = uri.substring(uri.indexOf("/"), uri.lastIndexOf("/"));
            returnValue = uri + "/" + url;
        }
        return this.removeRelativePaths(returnValue, baseUrl);
    }

    protected String removeRelativePaths(String url, String originalRequestUri) {
        String urlWithoutRelativePath = url;
        if (url.startsWith("..")) {
            Stack<String> stack = new Stack<String>();
            String localUri = originalRequestUri.substring(originalRequestUri.indexOf("/"), originalRequestUri.lastIndexOf("/"));
            StringTokenizer localUriParts = new StringTokenizer(localUri.replace('\\', '/'), "/");
            while (localUriParts.hasMoreTokens()) {
                String part = localUriParts.nextToken();
                stack.push(part);
            }
            StringTokenizer pathParts = new StringTokenizer(url.replace('\\', '/'), "/");
            while (pathParts.hasMoreTokens()) {
                String part = pathParts.nextToken();
                if (part.equals(".")) continue;
                if (part.equals("..")) {
                    stack.pop();
                    continue;
                }
                stack.push(part);
            }
            StringBuffer flatPathBuffer = new StringBuffer();
            for (int i = 0; i < stack.size(); ++i) {
                flatPathBuffer.append("/").append((String)stack.elementAt(i));
            }
            urlWithoutRelativePath = flatPathBuffer.toString();
        }
        return urlWithoutRelativePath;
    }

    protected String stripSession(String url, UrlData urlData) {
        if (url.contains("JSESSIONID") || url.contains(Constants.JSESSIONID_LC)) {
            int last = url.length();
            if (url.contains("?")) {
                last = url.indexOf("?");
            }
            String jSessionId = url.substring(url.indexOf(";") + 1, last);
            urlData.setjSessionId(jSessionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("jSessionId value: " + jSessionId));
            }
            return HDIVUtil.stripSession(url);
        }
        return url;
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }
}

