/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state.scope;

import org.hdiv.state.IState;
import org.hdiv.state.scope.ScopedStateCache;
import org.hdiv.state.scope.StateScope;

public abstract class AbstractStateScope
implements StateScope {
    public String addState(IState state, String token) {
        ScopedStateCache cache = this.getStateCache();
        if (cache == null) {
            cache = new ScopedStateCache();
        }
        String stateId = cache.addState(state, token);
        this.setStateCache(cache);
        return this.getScopePrefix() + "-" + stateId;
    }

    public IState restoreState(int stateId) {
        ScopedStateCache cache = this.getStateCache();
        return cache == null ? null : cache.getState(stateId);
    }

    public String getStateToken(int stateId) {
        ScopedStateCache cache = this.getStateCache();
        return cache == null ? null : cache.getStateToken(stateId);
    }

    public boolean isScopeState(String stateId) {
        return stateId.startsWith(this.getScopePrefix());
    }

    protected abstract String getScopePrefix();

    protected abstract ScopedStateCache getStateCache();

    protected abstract void setStateCache(ScopedStateCache var1);
}

