/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hdiv.exception.HDIVException;
import org.hdiv.state.IParameter;
import org.hdiv.state.IState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class State
implements IState,
Serializable {
    private static final long serialVersionUID = -5179573248448214135L;
    private static final int PARAMETERS_LIST_SIZE = 3;
    private String action;
    private byte[] params;
    private List<IParameter> parameters;
    private int id;
    private int pageId;
    private boolean parametersInitialized = false;
    private List<String> requiredParams;
    private String method;

    public State(int id) {
        this.id = id;
    }

    public List<IParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public void addParameter(IParameter parameter) {
        if (!this.parametersInitialized) {
            this.parametersInitialized = true;
            this.parameters = new ArrayList<IParameter>(3);
            this.requiredParams = new ArrayList<String>(3);
        }
        if (parameter.isActionParam()) {
            this.requiredParams.add(parameter.getName());
        }
        this.parameters.add(parameter);
    }

    @Override
    public IParameter getParameter(String key) {
        if (this.parameters != null) {
            for (IParameter parameter : this.parameters) {
                if (!parameter.getName().equalsIgnoreCase(key)) continue;
                return parameter;
            }
        }
        return null;
    }

    @Override
    public String getAction() {
        return this.action;
    }

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public String getParams() {
        if (this.params == null) {
            return null;
        }
        try {
            return new String(this.params, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("Error converting parameters to String", e);
        }
    }

    @Override
    public void setParams(String params) {
        try {
            this.params = (byte[])(params != null ? params.getBytes("UTF-8") : null);
        }
        catch (UnsupportedEncodingException e) {
            throw new HDIVException("Error converting action to byte array", e);
        }
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public List<String> getRequiredParams() {
        if (!this.parametersInitialized) {
            return Collections.EMPTY_LIST;
        }
        return this.requiredParams;
    }

    @Override
    public int getPageId() {
        return this.pageId;
    }

    @Override
    public void setPageId(int pageId) {
        this.pageId = pageId;
    }

    @Override
    public String getMethod() {
        if (this.method == null) {
            return "GET";
        }
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        if (method == null) {
            this.method = method;
        }
        if (method.equalsIgnoreCase("GET")) {
            this.method = null;
        }
        this.method = method.toUpperCase();
    }

    @Override
    public boolean existParameter(String key) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("id: ").append(this.id);
        sb.append("action: ").append(this.action);
        sb.append("parameters: ").append(this.parameters);
        sb.append("params: ").append(this.params);
        sb.append("requiredParams: ").append(this.requiredParams);
        sb.append("method: ").append(this.method == null ? "GET" : this.method);
        return super.toString();
    }
}

