/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.state;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hdiv.state.IPage;
import org.hdiv.state.IState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
implements IPage,
Serializable {
    private static final long serialVersionUID = -5701140762067196143L;
    protected List<IState> states = new ArrayList<IState>();
    protected Map<Integer, String> hashStates;
    private int id;
    private String flowId;
    private String randomToken;
    private String formRandomToken;
    private long size;

    @Override
    public void addState(IState state) {
        int id = state.getId();
        if (this.states.size() < id) {
            this.states.add(id - 1, null);
            this.states.add(id, state);
        } else if (this.states.size() > id) {
            this.states.set(id, state);
        } else {
            this.states.add(id, state);
        }
    }

    @Override
    public void addState(int id, String stateHash) {
        if (this.hashStates == null) {
            this.hashStates = new HashMap<Integer, String>();
        }
        this.hashStates.put(id, stateHash);
    }

    @Override
    public boolean existState(int id) {
        return this.states.get(id) != null;
    }

    @Override
    public IState getState(int id) {
        return this.states.get(id);
    }

    @Override
    public String getStateHash(int key) {
        if (this.hashStates == null) {
            return null;
        }
        return this.hashStates.get(key);
    }

    @Override
    public String getName() {
        return this.id + "";
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Collection<? extends Object> getStates() {
        return this.states;
    }

    @Override
    public int getStatesCount() {
        int count = this.states.size();
        if (this.hashStates != null) {
            count += this.hashStates.size();
        }
        return count;
    }

    @Override
    public String getFlowId() {
        return this.flowId;
    }

    @Override
    public void setFlowId(String flowId) {
        this.flowId = flowId;
    }

    @Override
    public String getRandomToken(String method) {
        if (this.isFormMethod(method)) {
            return this.formRandomToken;
        }
        return this.randomToken;
    }

    @Override
    public void setRandomToken(String randomToken, String method) {
        if (this.isFormMethod(method)) {
            this.formRandomToken = randomToken;
        } else {
            this.randomToken = randomToken;
        }
    }

    protected boolean isFormMethod(String method) {
        if (method == null) {
            return false;
        }
        if ((method = method.toUpperCase()).equals("GET")) {
            return false;
        }
        return method.equals("POST") || method.equals("PATCH") || method.equals("PUT") || method.equals("DELETE");
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("Page:" + this.id + " ");
        for (IState state : this.states) {
            result.append(" " + state.toString());
        }
        return result.toString();
    }
}

