/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.config.multipart.IMultipartConfig;
import org.hdiv.config.multipart.exception.HdivMultipartException;
import org.hdiv.filter.IValidationHelper;
import org.hdiv.filter.RequestInitializer;
import org.hdiv.filter.RequestWrapper;
import org.hdiv.filter.ResponseWrapper;
import org.hdiv.filter.ValidatorErrorHandler;
import org.hdiv.filter.ValidatorHelperResult;
import org.springframework.beans.BeansException;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.filter.OncePerRequestFilter;

public class ValidatorFilter
extends OncePerRequestFilter {
    private static Log log = LogFactory.getLog(ValidatorFilter.class);
    private HDIVConfig hdivConfig;
    private IValidationHelper validationHelper;
    private IMultipartConfig multipartConfig;
    private ValidatorErrorHandler errorHandler;
    private RequestInitializer requestInitializer;

    protected void initDependencies() {
        if (this.hdivConfig == null) {
            ServletContext servletContext = this.getServletContext();
            WebApplicationContext context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)servletContext);
            this.hdivConfig = (HDIVConfig)context.getBean(HDIVConfig.class);
            this.validationHelper = (IValidationHelper)context.getBean(IValidationHelper.class);
            try {
                this.multipartConfig = (IMultipartConfig)context.getBean(IMultipartConfig.class);
            }
            catch (BeansException ex) {
                this.multipartConfig = null;
            }
            this.errorHandler = (ValidatorErrorHandler)context.getBean(ValidatorErrorHandler.class);
            this.requestInitializer = (RequestInitializer)context.getBean(RequestInitializer.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        this.initDependencies();
        this.requestInitializer.initRequest(request);
        RequestWrapper requestWrapper = this.requestInitializer.createRequestWrapper(request);
        ResponseWrapper responseWrapper = this.requestInitializer.createResponseWrapper(response);
        RequestWrapper multipartProcessedRequest = requestWrapper;
        try {
            boolean legal = false;
            boolean isMultipartException = false;
            if (this.isMultipartContent(request.getContentType())) {
                requestWrapper.setMultipart(true);
                try {
                    if (this.multipartConfig == null) {
                        throw new RuntimeException("No 'multipartConfig' configured. It is required to multipart requests.");
                    }
                    multipartProcessedRequest = this.multipartConfig.handleMultipartRequest(requestWrapper, super.getServletContext());
                }
                catch (HdivMultipartException e) {
                    request.setAttribute("org.hdiv.exception.HDIVMultipartException", (Object)e);
                    isMultipartException = true;
                    legal = true;
                }
            }
            ValidatorHelperResult result = null;
            if (!isMultipartException) {
                result = this.validationHelper.validate((HttpServletRequest)multipartProcessedRequest);
                legal = result.isValid();
                request.setAttribute("org.hdiv.ValidatorHelperResult", (Object)result);
            }
            if (legal || this.hdivConfig.isDebugMode()) {
                this.processRequest((HttpServletRequest)multipartProcessedRequest, responseWrapper, filterChain);
            } else {
                this.errorHandler.handleValidatorError((HttpServletRequest)multipartProcessedRequest, response, result.getErrorCode());
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (ServletException e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Exception in request validation:");
                log.error((Object)("Message: " + e.getMessage()));
                StringBuffer buffer = new StringBuffer();
                StackTraceElement[] trace = e.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    buffer.append("\tat " + trace[i] + System.getProperty("line.separator"));
                }
                log.error((Object)("StackTrace: " + buffer.toString()));
                log.error((Object)("Cause: " + e.getCause()));
                log.error((Object)("Exception: " + e.toString()));
            }
            if (!this.hdivConfig.isDebugMode()) {
                response.sendRedirect(response.encodeRedirectURL(request.getContextPath() + this.hdivConfig.getErrorPage()));
            }
        }
        finally {
            this.requestInitializer.endRequest(request);
        }
    }

    protected boolean isMultipartContent(String contentType) {
        return contentType != null && contentType.indexOf("multipart/form-data") != -1;
    }

    protected void processRequest(HttpServletRequest requestWrapper, ResponseWrapper responseWrapper, FilterChain filterChain) throws IOException, ServletException {
        this.validationHelper.startPage(requestWrapper);
        filterChain.doFilter((ServletRequest)requestWrapper, (ServletResponse)responseWrapper);
        this.validationHelper.endPage(requestWrapper);
    }
}

