/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.filter;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.filter.SavedCookie;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestWrapper
extends HttpServletRequestWrapper {
    private static Log log = LogFactory.getLog(RequestWrapper.class);
    private static final String COOKIE = "cookie";
    private Set<String> editableParameters = new HashSet<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, Object> elementsFile = new HashMap<String, Object>();
    private Map<String, Object> elementsText = new HashMap<String, Object>();
    private boolean isMultipart = false;
    private boolean confidentiality = true;
    private boolean cookiesConfidentiality;

    public RequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        if (log.isDebugEnabled()) {
            log.debug((Object)"New RequestWrapper instance.");
        }
    }

    public String[] getParameterValues(String parameter) {
        if (!this.parameters.containsKey(parameter)) {
            return super.getParameterValues(parameter);
        }
        Object data = this.parameters.get(parameter);
        if (data.getClass().isArray()) {
            return (String[])data;
        }
        String[] array = new String[]{(String)this.parameters.get(parameter)};
        return array;
    }

    public String getParameter(String parameter) {
        if (!this.parameters.containsKey(parameter)) {
            return super.getParameter(parameter);
        }
        Object data = this.parameters.get(parameter);
        if (data.getClass().isArray()) {
            String[] array = (String[])data;
            return array[0];
        }
        return (String)this.parameters.get(parameter);
    }

    public Enumeration<?> getParameterNames() {
        Enumeration baseParams = super.getParameterNames();
        if (!this.isMultipart) {
            return baseParams;
        }
        Vector list = new Vector();
        while (baseParams.hasMoreElements()) {
            list.add(baseParams.nextElement());
        }
        Set<String> multipartParams = this.parameters.keySet();
        list.addAll(multipartParams);
        return Collections.enumeration(list);
    }

    public String getHeader(String name) {
        Map sessionCookies;
        String cookieHeader = super.getHeader(name);
        if (name.equalsIgnoreCase(COOKIE) && this.confidentiality && this.cookiesConfidentiality && (sessionCookies = (Map)super.getSession().getAttribute("org.hdiv.HdivCookies")) != null) {
            return this.replaceCookieString(cookieHeader, sessionCookies);
        }
        return cookieHeader;
    }

    public Enumeration<?> getHeaders(String name) {
        Enumeration headerValues = super.getHeaders(name);
        if (name.equalsIgnoreCase(COOKIE) && this.confidentiality && this.cookiesConfidentiality) {
            Vector<String> values = new Vector<String>();
            Map sessionCookies = (Map)super.getSession().getAttribute("org.hdiv.HdivCookies");
            if (sessionCookies != null) {
                while (headerValues.hasMoreElements()) {
                    String element = (String)headerValues.nextElement();
                    String replaced = this.replaceCookieString(element, sessionCookies);
                    values.add(replaced);
                }
            }
            return values.elements();
        }
        return headerValues;
    }

    private String replaceCookieString(String cookieHeader, Map<String, SavedCookie> sessionCookies) {
        String header = cookieHeader.trim();
        StringTokenizer tokens = new StringTokenizer(cookieHeader, ";");
        while (tokens.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(tokens.nextToken(), "=");
            String name = t.nextToken().trim();
            if (name.equals("JSESSIONID") || !sessionCookies.containsKey(name) || !t.hasMoreTokens()) continue;
            String value = t.nextToken().trim();
            SavedCookie savedCookie = sessionCookies.get(name);
            header = header.replaceFirst("=" + value, "=" + savedCookie.getValue());
        }
        return header;
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
        if (this.isMultipart) {
            this.addTextParameter(name, value);
        }
    }

    public Map<? extends String, ?> getParameterMap() {
        HashMap<String, Object> map = new HashMap<String, Object>(super.getRequest().getParameterMap());
        map.putAll(this.parameters);
        return map;
    }

    public Map<String, Object> getTextElements() {
        return this.elementsText;
    }

    public Map<String, Object> getFileElements() {
        return this.elementsFile;
    }

    public void addTextParameter(String name, Object value) {
        this.elementsText.put(name, value);
    }

    public void addFileItem(String name, Object values) {
        this.elementsFile.put(name, values);
    }

    public void addEditableParameter(String parameter) {
        this.editableParameters.add(parameter);
    }

    public boolean isEditableParameter(String parameter) {
        return this.editableParameters.contains(parameter);
    }

    public void setMultipart(boolean isMultipart) {
        this.isMultipart = isMultipart;
    }

    public void setCookiesConfidentiality(boolean cookiesConfidentiality) {
        this.cookiesConfidentiality = cookiesConfidentiality;
    }

    public void setConfidentiality(boolean confidentiality) {
        this.confidentiality = confidentiality;
    }
}

