/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataValidator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.dataValidator.IDataValidator;
import org.hdiv.dataValidator.IValidationResult;
import org.hdiv.dataValidator.ValidationResult;
import org.hdiv.state.IParameter;
import org.hdiv.util.HDIVUtil;

public class DataValidator
implements IDataValidator {
    private Log log = LogFactory.getLog(DataValidator.class);
    private HDIVConfig config;

    public IValidationResult validate(String value, String target, String parameter, IParameter stateParameter, String[] actionParamValues) {
        boolean confidentiality = this.config.getConfidentiality();
        boolean noConfidentiality = this.config.isParameterWithoutConfidentiality(parameter);
        if (this.log.isDebugEnabled() && noConfidentiality) {
            this.log.debug((Object)("Parameter [" + parameter + "] is ParameterWithoutConfidentiality."));
        }
        ValidationResult result = new ValidationResult();
        if (!confidentiality || noConfidentiality) {
            if (stateParameter != null) {
                if (stateParameter.existValue(value)) {
                    result.setResult(value);
                    result.setLegal(true);
                } else {
                    result.setLegal(false);
                }
                return result;
            }
            for (int i = 0; i < actionParamValues.length; ++i) {
                if (!value.equals(actionParamValues[i])) continue;
                result.setResult(value);
                result.setLegal(true);
                return result;
            }
            result.setLegal(false);
            return result;
        }
        if (!this.isInt(value)) {
            result.setLegal(false);
            return result;
        }
        int position = new Integer(value);
        if (stateParameter != null) {
            if (stateParameter.existPosition(position)) {
                result.setLegal(true);
                result.setResult(stateParameter.getValuePosition(position));
                return result;
            }
            result.setLegal(false);
            return result;
        }
        if (actionParamValues.length > position) {
            result.setLegal(true);
            result.setResult(actionParamValues[position]);
            return result;
        }
        result.setLegal(false);
        return result;
    }

    private boolean isInt(String data) {
        Pattern p = HDIVUtil.intPattern;
        Matcher m = p.matcher(data);
        return m.matches();
    }

    public void setConfig(HDIVConfig config) {
        this.config = config;
    }
}

