/*
 * Decompiled with CFR 0.152.
 */
package org.hdiv.dataComposer;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hdiv.config.HDIVConfig;
import org.hdiv.dataComposer.IDataComposer;
import org.hdiv.idGenerator.UidGenerator;
import org.hdiv.session.ISession;
import org.hdiv.state.IPage;
import org.hdiv.state.IParameter;
import org.hdiv.state.IState;
import org.hdiv.state.Page;
import org.hdiv.state.Parameter;
import org.springframework.web.util.HtmlUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataComposer
implements IDataComposer {
    private static Log log = LogFactory.getLog(AbstractDataComposer.class);
    protected static final String DASH = "-";
    protected ISession session;
    protected UidGenerator uidGenerator;
    protected IPage page;
    private Stack<IState> statesStack;
    protected HDIVConfig hdivConfig;

    @Override
    public void init() {
        this.setPage(new Page());
        this.statesStack = new Stack();
    }

    public void initPage() {
        this.page = new Page();
        int pageId = this.session.getPageId();
        this.page.setId(pageId);
    }

    @Override
    public String compose(String parameter, String value, boolean editable) {
        return this.compose(parameter, value, editable, false);
    }

    @Override
    public String compose(String action, String parameter, String value, boolean editable) {
        return this.compose(action, parameter, value, editable, false, "UTF-8");
    }

    public String compose(String parameter, String value, boolean editable, boolean isActionParam) {
        return this.compose(parameter, value, editable, isActionParam, "UTF-8");
    }

    @Override
    public String compose(String parameter, String value, boolean editable, String editableName) {
        return this.compose(parameter, value, editable, editableName, false, null, "UTF-8");
    }

    @Override
    public String compose(String action, String parameter, String value, boolean editable, boolean isActionParam, String charEncoding) {
        IState state = this.getStatesStack().peek();
        if (state.getAction() != null && state.getAction().trim().length() == 0) {
            state.setAction(action);
        }
        return this.compose(parameter, value, editable, isActionParam, charEncoding);
    }

    @Override
    public String compose(String parameter, String value, boolean editable, boolean isActionParam, String charEncoding) {
        return this.compose(parameter, value, editable, null, isActionParam, null, charEncoding);
    }

    public String compose(String parameter, String value, boolean editable, String editableName, boolean isActionParam, String method) {
        return this.compose(parameter, value, editable, editableName, isActionParam, method, "UTF-8");
    }

    @Override
    public String composeParams(String parameters, String method, String charEncoding) {
        if (parameters == null || parameters.length() == 0) {
            return null;
        }
        IState state = this.getStatesStack().peek();
        state.setParams(parameters);
        if (this.hdivConfig.getConfidentiality()) {
            parameters = this.applyConfidentialityToParams(parameters, method);
        }
        return parameters;
    }

    private String applyConfidentialityToParams(String parameters, String method) {
        HashMap<String, Integer> pCount = new HashMap<String, Integer>();
        String newParameters = parameters;
        int beginIndex = 0;
        int endIndex = parameters.indexOf("&") > 0 ? parameters.indexOf("&") : parameters.length();
        do {
            int index;
            String param;
            String name;
            if (this.isConfidentialParam(name = param.substring(0, index = (index = (param = parameters.substring(beginIndex, endIndex)).indexOf("=")) < 0 ? param.length() : index), method)) {
                Integer count = (Integer)pCount.get(name);
                int num = count == null ? 0 : count + 1;
                pCount.put(name, num);
                newParameters = newParameters.replaceFirst(param, name + "=" + num);
            }
            beginIndex = endIndex + 1;
            if ((endIndex = parameters.indexOf("&", endIndex + 1)) >= 0) continue;
            endIndex = parameters.length();
        } while (endIndex > beginIndex);
        return newParameters;
    }

    @Override
    public String composeFormField(String parameter, String value, boolean editable, String editableName) {
        return this.compose(parameter, value, editable, editableName, false, "POST", "UTF-8");
    }

    @Override
    public String compose(String parameterName, String value, boolean editable, String editableName, boolean isActionParam, String method, String charEncoding) {
        if (!this.isRequestStarted()) {
            return value;
        }
        if (method == null || method.length() == 0) {
            method = "GET";
        }
        IParameter parameter = this.composeParameter(parameterName, value, editable, editableName, isActionParam, charEncoding);
        if (this.isConfidentialParam(parameterName, method)) {
            return parameter.getConfidentialValue();
        }
        return value;
    }

    protected boolean isConfidentialParam(String parameterName, String method) {
        if (!this.hdivConfig.getConfidentiality()) {
            return false;
        }
        if (this.hdivConfig.isStartParameter(parameterName)) {
            return false;
        }
        if (this.isUserDefinedNonValidationParameter(parameterName)) {
            return false;
        }
        return !this.hdivConfig.isParameterWithoutConfidentiality(parameterName);
    }

    protected boolean isUserDefinedNonValidationParameter(String parameter) {
        IState state = this.getStatesStack().peek();
        String action = state.getAction();
        if (this.hdivConfig.isParameterWithoutValidation(action, parameter)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("parameter " + parameter + " doesn't need validation. It is user defined parameter."));
            }
            return true;
        }
        return false;
    }

    protected IParameter composeParameter(String parameterName, String value, boolean editable, String editableDataType, boolean isActionParam, String charEncoding) {
        IState state;
        IParameter parameter;
        String decodedValue = null;
        if (!editable) {
            decodedValue = this.getDecodedValue(value, charEncoding);
        }
        if ((parameter = (state = this.getStatesStack().peek()).getParameter(parameterName)) != null) {
            parameter.addValue(decodedValue);
        } else {
            parameter = this.createParameter(parameterName, decodedValue, editable, editableDataType, isActionParam, charEncoding);
            state.addParameter(parameter);
        }
        return parameter;
    }

    protected IParameter createParameter(String parameterName, String decodedValue, boolean editable, String editableDataType, boolean isActionParam, String charEncoding) {
        return new Parameter(parameterName, decodedValue, editable, editableDataType, isActionParam);
    }

    @Override
    public void mergeParameters(String oldParameter, String newParameter) {
        IState state = this.getStatesStack().peek();
        IParameter storedParameter = state.getParameter(oldParameter);
        if (storedParameter.getValues().size() > 0) {
            IParameter parameter = this.composeParameter(newParameter, storedParameter.getValuePosition(0), false, "", false, "UTF-8");
            String currentValue = null;
            for (int i = 1; i < storedParameter.getValues().size(); ++i) {
                currentValue = storedParameter.getValuePosition(i);
                parameter.addValue(currentValue);
            }
        }
    }

    private String getDecodedValue(String value, String charEncoding) {
        String decodedValue = null;
        try {
            decodedValue = URLDecoder.decode(value, charEncoding);
        }
        catch (UnsupportedEncodingException e) {
            decodedValue = value;
        }
        if (decodedValue == null) {
            return "";
        }
        if (decodedValue.contains("&")) {
            decodedValue = HtmlUtils.htmlUnescape((String)decodedValue);
        }
        return decodedValue == null ? "" : decodedValue;
    }

    @Override
    public boolean isRequestStarted() {
        return this.statesStack.size() > 0;
    }

    @Override
    public void addFlowId(String id) {
        this.page.setFlowId(id);
    }

    protected String getStateSuffix(String method) {
        String randomToken = this.page.getRandomToken(method);
        if (randomToken == null) {
            randomToken = this.uidGenerator.generateUid().toString();
            this.page.setRandomToken(randomToken, method);
        }
        return randomToken;
    }

    public void setSession(ISession session) {
        this.session = session;
    }

    public IPage getPage() {
        return this.page;
    }

    public void setPage(IPage page) {
        this.page = page;
    }

    public void setUidGenerator(UidGenerator uidGenerator) {
        this.uidGenerator = uidGenerator;
    }

    public Stack<IState> getStatesStack() {
        return this.statesStack;
    }

    public void setHdivConfig(HDIVConfig hdivConfig) {
        this.hdivConfig = hdivConfig;
    }
}

